/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.resource.provider;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.EnvironmentEntryType;

public class ResourceProviderRegistry {
    private Map<Class<?>, MCBasedResourceProvider<? extends EnvironmentEntryType>> resourceProviders = new ConcurrentHashMap();

    public void setResourceProviders(Collection<MCBasedResourceProvider<EnvironmentEntryType>> providers) {
        if (providers == null) {
            throw new IllegalArgumentException("ResourceProvider(s) cannot be null during registration");
        }
        for (MCBasedResourceProvider<EnvironmentEntryType> provider : providers) {
            this.registerProvider(provider);
        }
    }

    public void registerProvider(MCBasedResourceProvider<? extends EnvironmentEntryType> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("ResourceProvider cannot be null during registration");
        }
        Class type = provider.getEnvironmentEntryType();
        this.resourceProviders.put(type, provider);
    }

    public MCBasedResourceProvider<EnvironmentEntryType> getResourceProvider(Class<? extends EnvironmentEntryType> type) {
        Class<?>[] interfaces;
        MCBasedResourceProvider<? extends EnvironmentEntryType> provider = this.resourceProviders.get(type);
        if (provider != null) {
            return provider;
        }
        for (Class<? extends EnvironmentEntryType> entryType = type.getSuperclass(); entryType != null && EnvironmentEntryType.class.isAssignableFrom(entryType); entryType = entryType.getSuperclass()) {
            provider = this.getResourceProvider(entryType);
            if (provider == null) continue;
            return provider;
        }
        for (Class<?> intf : interfaces = type.getInterfaces()) {
            if (!EnvironmentEntryType.class.isAssignableFrom(intf) || (provider = this.getResourceProvider(intf)) == null) continue;
            return provider;
        }
        return provider;
    }
}

