/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.resource.deployers.DataSourceDeployerHelper;
import org.jboss.resource.deployers.DataSourceResource;
import org.jboss.switchboard.impl.resource.LinkRefResource;
import org.jboss.switchboard.javaee.jboss.environment.JBossResourceRefType;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

public class DataSourceResRefResourceProvider
implements MCBasedResourceProvider<JBossResourceRefType> {
    private static Logger logger = Logger.getLogger(DataSourceResRefResourceProvider.class);
    private JavaEEComponentInformer informer;

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer informer) {
        this.informer = informer;
    }

    public Class<JBossResourceRefType> getEnvironmentEntryType() {
        return JBossResourceRefType.class;
    }

    public Resource provide(DeploymentUnit unit, JBossResourceRefType resRef) {
        String lookupName = resRef.getLookupName();
        if (lookupName != null && !lookupName.trim().isEmpty()) {
            return new LinkRefResource(lookupName, null, resRef.isIgnoreDependency());
        }
        String mappedName = resRef.getMappedName();
        if (mappedName != null && !mappedName.trim().isEmpty()) {
            return new LinkRefResource(mappedName, null, resRef.isIgnoreDependency());
        }
        String jndiName = resRef.getJNDIName();
        if (jndiName != null && !jndiName.trim().isEmpty()) {
            return new LinkRefResource(jndiName, null, resRef.isIgnoreDependency());
        }
        String internalJndiNameWithoutNamespace = DataSourceDeployerHelper.normalizeJndiName(resRef.getName(), unit, this.informer);
        String targetJndiName = "java:/" + internalJndiNameWithoutNamespace;
        String binderName = "jboss.jca:name=" + internalJndiNameWithoutNamespace + ",service=DataSourceBinding";
        logger.debug((Object)("No jndi-name/mapped-name/lookup specified for res-ref: " + resRef.getName() + " of type datasource. Will return a Resource which depends on datasource binder: " + binderName));
        return new DataSourceResource(targetJndiName, binderName);
    }
}

