/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCCMPFieldPropertyMetaData {
    private final JDBCCMPFieldMetaData cmpField;
    private final String propertyName;
    private final String columnName;
    private final int jdbcType;
    private final String sqlType;
    private final boolean notNull;

    public JDBCCMPFieldPropertyMetaData(JDBCCMPFieldMetaData cmpField, Element element) throws DeploymentException {
        this.cmpField = cmpField;
        this.propertyName = MetaData.getUniqueChildContent((Element)element, (String)"property-name");
        String columnStr = MetaData.getOptionalChildContent((Element)element, (String)"column-name");
        this.columnName = columnStr != null ? columnStr : null;
        String jdbcStr = MetaData.getOptionalChildContent((Element)element, (String)"jdbc-type");
        if (jdbcStr != null) {
            this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcStr);
            this.sqlType = MetaData.getUniqueChildContent((Element)element, (String)"sql-type");
        } else {
            this.jdbcType = Integer.MIN_VALUE;
            this.sqlType = null;
        }
        this.notNull = MetaData.getOptionalChild((Element)element, (String)"not-null") != null;
    }

    public JDBCCMPFieldPropertyMetaData(JDBCCMPFieldMetaData cmpField, JDBCCMPFieldPropertyMetaData defaultValues) {
        this.cmpField = cmpField;
        this.propertyName = defaultValues.propertyName;
        this.columnName = defaultValues.columnName;
        this.jdbcType = defaultValues.jdbcType;
        this.sqlType = defaultValues.sqlType;
        this.notNull = defaultValues.notNull;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getJDBCType() {
        return this.jdbcType;
    }

    public String getSQLType() {
        return this.sqlType;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCCMPFieldPropertyMetaData) {
            JDBCCMPFieldPropertyMetaData cmpFieldProperty = (JDBCCMPFieldPropertyMetaData)o;
            return this.propertyName.equals(cmpFieldProperty.propertyName) && this.cmpField.equals(cmpFieldProperty.cmpField);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.cmpField.hashCode();
        result = 37 * result + this.propertyName.hashCode();
        return result;
    }

    public String toString() {
        return "[JDBCCMPFieldPropertyMetaData : propertyName=" + this.propertyName + ", " + this.cmpField + "]";
    }
}

