/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractOptionalRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.BootstrapInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBootstrapInfoDeployer
extends AbstractOptionalRealDeployer<BootstrapInfo> {
    protected AbstractBootstrapInfoDeployer(boolean isPassThroughBootstrapInfo) {
        super(BootstrapInfo.class);
        this.setTopLevelOnly(true);
        this.setStage(DeploymentStages.PRE_REAL);
        this.addInput("WELD_FILES");
        if (isPassThroughBootstrapInfo) {
            this.addOutput(BootstrapInfo.class);
        }
    }

    public final void deploy(DeploymentUnit unit, BootstrapInfo info) throws DeploymentException {
        if (info != null) {
            this.deployInternal(unit, info);
        } else if (DeployersUtils.checkForWeldFilesAcrossDeployment(unit)) {
            info = new BootstrapInfo();
            unit.addAttachment(BootstrapInfo.class, (Object)info);
            this.deployInternal(unit, info);
        }
    }

    public void undeploy(DeploymentUnit unit, BootstrapInfo info) {
        if (info != null) {
            this.undeployInternal(unit, info);
        }
    }

    protected void undeployInternal(DeploymentUnit unit, BootstrapInfo info) {
    }

    protected abstract void deployInternal(DeploymentUnit var1, BootstrapInfo var2) throws DeploymentException;

    protected static ValueMetaData createServiceConnector(String name, String bean, DeploymentUnit unit) {
        String beanName = unit.getName() + "_" + name;
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)bean);
        builder.setFactory(name);
        builder.setFactoryMethod("createBean");
        builder.addPropertyMetaData("deploymentUnit", (Object)unit);
        unit.addAttachment(beanName + "_" + BeanMetaData.class.getSimpleName(), (Object)builder.getBeanMetaData());
        return builder.createInject((Object)beanName);
    }
}

