/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactoryWithClassLoaderSupport;
import org.jboss.aop.advice.SecurityActions;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAspectFactory
extends AspectFactoryWithClassLoaderSupport {
    private static final Logger logger = Logger.getLogger(GenericAspectFactory.class);
    static final Class<?>[] ADVISOR_INJECTOR_SIGNATURE = new Class[]{Advisor.class};
    static final Class<?>[] INSTANCE_ADVISOR_INJECTOR_SIGNATURE = new Class[]{InstanceAdvisor.class};
    static final Class<?>[] JOINPOINT_INJECTOR_SIGNATURE = new Class[]{Joinpoint.class};
    private String classname;
    private Element element;

    public GenericAspectFactory(String classname, Element element) {
        this.classname = classname;
        this.element = element;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    @Override
    public String getName() {
        return this.classname;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    @Deprecated
    public Class<?> getClazz() {
        try {
            return this.loadClass(this.classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> getClazz(Advisor advisor) {
        try {
            ClassLoader cl = null;
            if (advisor != null) {
                Class<?> clazz = advisor.getClazz();
                cl = SecurityActions.getClassLoader(clazz != null ? clazz : advisor.getClass());
            }
            if (cl != null) {
                this.pushScopedClassLoader(cl);
            }
            Class<?> clazz = this.loadClass(this.classname);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.popScopedClassLoader();
        }
    }

    @Override
    public Object createPerVM() {
        try {
            Object aspect = this.getClazz(null).newInstance();
            this.configureInstance(aspect, null, null, null);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    @Override
    public Object createPerClass(Advisor advisor) {
        try {
            Object aspect = this.getClazz(advisor).newInstance();
            this.configureInstance(aspect, advisor, null, null);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    @Override
    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        try {
            Object aspect = this.getClazz(advisor).newInstance();
            this.configureInstance(aspect, advisor, instanceAdvisor, null);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    @Override
    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        try {
            Object aspect = this.getClazz(advisor).newInstance();
            this.configureInstance(aspect, advisor, null, jp);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    @Override
    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        try {
            Object aspect = this.getClazz(advisor).newInstance();
            this.configureInstance(aspect, advisor, instanceAdvisor, jp);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    protected void configureInstance(Object instance, Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        if (this.element == null) {
            return;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(instance.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        NodeList children = this.element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tagname = element.getTagName();
            String attributeName = element.getAttribute("name");
            if (tagname.equals("attribute")) {
                String attributeText = element.getFirstChild().getNodeValue();
                this.setAttribute(instance, descriptors, attributeName, attributeText);
                continue;
            }
            if (tagname.equals("advisor-attribute")) {
                this.injectAdvisor(instance, advisor, attributeName);
                continue;
            }
            if (tagname.equals("joinpoint-attribute")) {
                this.injectJoinpoint(instance, jp, attributeName);
                continue;
            }
            if (!tagname.equals("instance-advisor-attribute")) continue;
            this.injectInstanceAdvisor(instance, instanceAdvisor, attributeName);
        }
    }

    protected void setAttribute(Object instance, PropertyDescriptor[] descriptors, String attributeName, String attributeText) {
        boolean foundProperty = false;
        for (int i = 0; i < descriptors.length; ++i) {
            if (!attributeName.equalsIgnoreCase(descriptors[i].getName())) continue;
            foundProperty = true;
            Class<?> typeClass = descriptors[i].getPropertyType();
            PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
            if (editor == null) {
                throw new RuntimeException("No property editor for attribute: " + attributeName + "; type=" + typeClass + " in " + this.classname);
            }
            editor.setAsText(attributeText);
            Object value = editor.getValue();
            try {
                descriptors[i].getWriteMethod().invoke(instance, value);
                break;
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting attribute '" + attributeName + "' in " + this.classname, e);
            }
        }
        if (!foundProperty) {
            throw new RuntimeException("Could not find attribute '" + attributeName + "' in aspect/interceptor class " + this.classname);
        }
    }

    protected void injectAdvisor(Object instance, Advisor advisor, String attributeName) {
        if (advisor == null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring attempt to set advisor attribute on PER_VM scoped aspect/interceptor: " + this.classname));
            }
            return;
        }
        String injector = this.getInjectorName(attributeName);
        try {
            Method m = instance.getClass().getMethod(injector, ADVISOR_INJECTOR_SIGNATURE);
            m.invoke(instance, advisor);
        }
        catch (Exception e) {
            throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.Advisor injector called " + injector);
        }
    }

    protected void injectJoinpoint(Object instance, Joinpoint jp, String attributeName) {
        if (jp == null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring attempt to set joinpoint attribute on aspect/interceptor: " + this.classname + " which is not scoped PER_JOINPOINT"));
            }
            return;
        }
        String injector = this.getInjectorName(attributeName);
        try {
            Method m = instance.getClass().getMethod(injector, JOINPOINT_INJECTOR_SIGNATURE);
            m.invoke(instance, jp);
        }
        catch (Exception e) {
            throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.Joinpoint injector called " + injector);
        }
    }

    protected void injectInstanceAdvisor(Object instance, InstanceAdvisor instanceAdvisor, String attributeName) {
        if (instanceAdvisor == null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring attempt to set instance advisor attribute on aspect/interceptor: " + this.classname + " which is not scoped PER_INSTANCE or PER_JOINPOINT"));
            }
            return;
        }
        String injector = this.getInjectorName(attributeName);
        try {
            Method m = instance.getClass().getMethod(injector, INSTANCE_ADVISOR_INJECTOR_SIGNATURE);
            m.invoke(instance, instanceAdvisor);
        }
        catch (Exception e) {
            throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.InstanceAdvisor injector called " + injector);
        }
    }

    protected String getInjectorName(String attributeName) {
        char firstChar = attributeName.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            attributeName = Character.toUpperCase(firstChar) + attributeName.substring(1);
        }
        return "set" + attributeName;
    }

    static {
        SecurityActions.initEditors();
    }
}

