/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.RunAs;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.RunAsPrincipal;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.PerClassAspectFactoryAdaptor;
import org.jboss.ejb3.security.RunAsSecurityInterceptorv2;
import org.jboss.ejb3.security.SecurityDomainManager;
import org.jboss.ejb3.tx.NullInterceptor;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.security.RunAsIdentity;

public class RunAsSecurityInterceptorFactory
extends PerClassAspectFactoryAdaptor
implements AspectFactory {
    private static final Logger log = Logger.getLogger(RunAsSecurityInterceptorFactory.class);

    protected RunAsIdentity getRunAsIdentity(EJBContainer container) {
        JBossAssemblyDescriptorMetaData ad;
        Map principalVsRoleMap;
        Set roles;
        RunAs runAs = container.getAnnotation(RunAs.class);
        if (runAs == null) {
            return null;
        }
        RunAsPrincipal rap = (RunAsPrincipal)container.resolveAnnotation(RunAsPrincipal.class);
        String runAsPrincipal = null;
        if (rap != null) {
            runAsPrincipal = rap.value();
        }
        HashSet extraRoles = new HashSet();
        JBossEnterpriseBeanMetaData jbEnterpriseBeanMetaData = container.getXml();
        if (jbEnterpriseBeanMetaData != null) {
            SecurityIdentityMetaData securityIdentity = jbEnterpriseBeanMetaData.getSecurityIdentity();
            if (securityIdentity.isUseCallerId()) {
                return null;
            }
            String s = securityIdentity.getRunAsPrincipal();
            if (s != null && s.length() != 0) {
                runAsPrincipal = s;
            }
        }
        if (runAsPrincipal != null && (roles = (Set)(principalVsRoleMap = jbEnterpriseBeanMetaData.getSecurityRolesPrincipalVersusRolesMap()).get(runAsPrincipal)) != null) {
            extraRoles.addAll(roles);
        }
        if ((ad = container.getAssemblyDescriptor()) != null && runAsPrincipal != null) {
            extraRoles.addAll(ad.getSecurityRoleNamesByPrincipal(runAsPrincipal));
        }
        return new RunAsIdentity(runAs.value(), runAsPrincipal, extraRoles);
    }

    @Override
    public Object createPerClass(Advisor advisor) {
        Object container = EJBContainer.getEJBContainer(advisor);
        Object domain = null;
        try {
            InitialContext ctx = ((EJBContainer)container).getInitialContext();
            SecurityDomain securityDomain = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
            if (securityDomain != null) {
                String domainName = securityDomain.value();
                domain = SecurityDomainManager.getSecurityManager((String)domainName, (InitialContext)ctx);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        Object interceptor = new NullInterceptor();
        if (domain != null) {
            interceptor = new RunAsSecurityInterceptorv2((EJBContainer)container, this.getRunAsIdentity((EJBContainer)container));
        }
        return interceptor;
    }
}

