/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class InetAddressChecksTest {
    ProtocolStack stack = null;
    Protocol protocol = null;
    static final String ipCheckNoConsistentProps = "org.jgroups.tests.InetAddressChecksTest$IPCHECK(inetAddress1=127.0.0.1;inetAddress2=::1;inetAddress3=192.168.0.100;i=3)";
    static final String ipCheckConsistentProps = "org.jgroups.tests.InetAddressChecksTest$IPCHECK(inetAddress1=127.0.0.1;inetAddress2=127.0.0.1;inetAddress3=192.168.0.100;i=3)";
    List<String> order = new LinkedList<String>();

    @BeforeMethod
    void setUp() {
        this.stack = new ProtocolStack();
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testIPVersionCheckingNoConsistentVersion() throws Exception {
        Vector<ProtocolConfiguration> protocol_configs = new Vector<ProtocolConfiguration>();
        Vector<Protocol> protocols = new Vector<Protocol>();
        this.protocol = Configurator.createProtocol(ipCheckNoConsistentProps, this.stack);
        protocol_configs.add(new ProtocolConfiguration(ipCheckNoConsistentProps));
        protocols.add(this.protocol);
        Map<String, Map<String, Configurator.InetAddressInfo>> inetAddressMap = null;
        try {
            inetAddressMap = Configurator.createInetAddressMap(protocol_configs, protocols);
            Collection<InetAddress> addrs = Configurator.getAddresses(inetAddressMap);
            Configurator.determineIpVersionFromAddresses(addrs);
        }
        catch (RuntimeException e) {
            System.out.println("Expected exception received: " + e.getMessage());
            throw e;
        }
        InetAddress a = ((IPCHECK)this.protocol).getInetAddress1();
        System.out.println("value of inetAddress1 = " + a);
        InetAddress b = ((IPCHECK)this.protocol).getInetAddress2();
        System.out.println("value of inetAddress2 = " + b);
        InetAddress c = ((IPCHECK)this.protocol).getInetAddress3();
        System.out.println("value of inetAddress3 = " + c);
    }

    public void testIPVersionCheckingConsistentVersion() throws Exception {
        Vector<ProtocolConfiguration> protocol_configs = new Vector<ProtocolConfiguration>();
        Vector<Protocol> protocols = new Vector<Protocol>();
        this.protocol = Configurator.createProtocol(ipCheckConsistentProps, this.stack);
        protocol_configs.add(new ProtocolConfiguration(ipCheckConsistentProps));
        protocols.add(this.protocol);
        Map<String, Map<String, Configurator.InetAddressInfo>> inetAddressMap = null;
        inetAddressMap = Configurator.createInetAddressMap(protocol_configs, protocols);
        Collection<InetAddress> addrs = Configurator.getAddresses(inetAddressMap);
        Configurator.determineIpVersionFromAddresses(addrs);
        InetAddress a = ((IPCHECK)this.protocol).getInetAddress1();
        System.out.println("value of inetAddress1 = " + a);
        InetAddress b = ((IPCHECK)this.protocol).getInetAddress2();
        System.out.println("value of inetAddress2 = " + b);
        InetAddress c = ((IPCHECK)this.protocol).getInetAddress3();
        System.out.println("value of inetAddress3 = " + c);
    }

    public static void testWhichIPStacksAvailable() throws Exception {
        boolean isIPv4 = Util.isStackAvailable(true);
        boolean isIPv6 = Util.isStackAvailable(false);
        System.out.println("isIPv4 = " + isIPv4);
        System.out.println("isIPv6 = " + isIPv6);
    }

    public static class IPCHECK
    extends Protocol {
        @Property(name="inetAddress1")
        InetAddress inetAddress1;
        @Property(name="inetAddress2")
        InetAddress inetAddress2;
        @Property(name="inetAddress3")
        InetAddress inetAddress3;
        @Property(description="wilma")
        int i = 0;

        public InetAddress getInetAddress1() {
            return this.inetAddress1;
        }

        public InetAddress getInetAddress2() {
            return this.inetAddress2;
        }

        public InetAddress getInetAddress3() {
            return this.inetAddress3;
        }

        @Override
        public Object down(Event evt) {
            return this.down_prot.down(evt);
        }

        @Override
        public Object up(Event evt) {
            return this.up_prot.up(evt);
        }
    }
}

