/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FcHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@MBean(description="Simple flow control protocol based on a credit system")
public abstract class FlowControl
extends Protocol {
    protected static final FcHeader REPLENISH_HDR = new FcHeader(1);
    protected static final FcHeader CREDIT_REQUEST_HDR = new FcHeader(2);
    @Property(description="Max number of bytes to send per receiver until an ack must be received to proceed")
    protected long max_credits = 500000L;
    @Property(description="Max time (in milliseconds) to block. Default is 5000 msec")
    protected long max_block_time = 5000L;
    protected Map<Long, Long> max_block_times = null;
    @Property(description="The threshold (as a percentage of max_credits) at which a receiver sends more credits to a sender. Example: if max_credits is 1'000'000, and min_threshold 0.25, then we send ca. 250'000 credits to P once we've got only 250'000 credits left for P (we've received 750'000 bytes from P)")
    protected double min_threshold = 0.4;
    @Property(description="Computed as max_credits x min_theshold unless explicitly set")
    protected long min_credits = 0L;
    @Property(description="Does not block a down message if it is a result of handling an up message in thesame thread. Fixes JGRP-928")
    protected boolean ignore_synchronous_response = true;
    protected int num_credit_requests_received = 0;
    protected int num_credit_requests_sent = 0;
    protected int num_credit_responses_sent = 0;
    protected int num_credit_responses_received = 0;
    protected final Map<Address, Credit> received = Util.createConcurrentMap();
    protected volatile boolean running = true;
    protected boolean frag_size_received = false;
    protected final ThreadLocal<Boolean> ignore_thread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_credit_requests_sent = 0;
        this.num_credit_requests_received = 0;
        this.num_credit_responses_received = 0;
        this.num_credit_responses_sent = 0;
    }

    public long getMaxCredits() {
        return this.max_credits;
    }

    public void setMaxCredits(long max_credits) {
        this.max_credits = max_credits;
    }

    public double getMinThreshold() {
        return this.min_threshold;
    }

    public void setMinThreshold(double min_threshold) {
        this.min_threshold = min_threshold;
    }

    public long getMinCredits() {
        return this.min_credits;
    }

    public void setMinCredits(long min_credits) {
        this.min_credits = min_credits;
    }

    public abstract int getNumberOfBlockings();

    public long getMaxBlockTime() {
        return this.max_block_time;
    }

    public void setMaxBlockTime(long t) {
        this.max_block_time = t;
    }

    @Property(description="Max times to block for the listed messages sizes (Message.getLength()). Example: \"1000:10,5000:30,10000:500\"")
    public void setMaxBlockTimes(String str) {
        if (str == null) {
            return;
        }
        Long prev_key = null;
        Long prev_val = null;
        List<String> vals = Util.parseCommaDelimitedStrings(str);
        if (this.max_block_times == null) {
            this.max_block_times = new TreeMap<Long, Long>();
        }
        for (String tmp : vals) {
            int index = tmp.indexOf(58);
            if (index == -1) {
                throw new IllegalArgumentException("element '" + tmp + "'  is missing a ':' separator");
            }
            Long key = Long.parseLong(tmp.substring(0, index).trim());
            Long val = Long.parseLong(tmp.substring(index + 1).trim());
            if (key < 0L || val < 0L) {
                throw new IllegalArgumentException("keys and values must be >= 0");
            }
            if (prev_key != null && key <= prev_key) {
                throw new IllegalArgumentException("keys are not sorted: " + vals);
            }
            prev_key = key;
            if (prev_val != null && val <= prev_val) {
                throw new IllegalArgumentException("values are not sorted: " + vals);
            }
            prev_val = val;
            this.max_block_times.put(key, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("max_block_times: " + this.max_block_times);
        }
    }

    public String getMaxBlockTimes() {
        if (this.max_block_times == null) {
            return "n/a";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<Long, Long> entry : this.max_block_times.entrySet()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(entry.getKey()).append(":").append(entry.getValue());
        }
        return sb.toString();
    }

    public abstract long getTotalTimeBlocked();

    @ManagedAttribute(description="Average time spent in a flow control block")
    public double getAverageTimeBlocked() {
        long number_of_blockings = this.getNumberOfBlockings();
        return number_of_blockings == 0L ? 0.0 : (double)this.getTotalTimeBlocked() / (double)number_of_blockings;
    }

    @ManagedAttribute(description="Number of credit requests received")
    public int getNumberOfCreditRequestsReceived() {
        return this.num_credit_requests_received;
    }

    @ManagedAttribute(description="Number of credit requests sent")
    public int getNumberOfCreditRequestsSent() {
        return this.num_credit_requests_sent;
    }

    @ManagedAttribute(description="Number of credit responses received")
    public int getNumberOfCreditResponsesReceived() {
        return this.num_credit_responses_received;
    }

    @ManagedAttribute(description="Number of credit responses sent")
    public int getNumberOfCreditResponsesSent() {
        return this.num_credit_responses_sent;
    }

    public abstract String printSenderCredits();

    @ManagedOperation(description="Print receiver credits")
    public String printReceiverCredits() {
        return FlowControl.printMap(this.received);
    }

    public String printCredits() {
        StringBuilder sb = new StringBuilder();
        sb.append("receivers:\n").append(FlowControl.printMap(this.received));
        return sb.toString();
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("receivers", FlowControl.printMap(this.received));
        return retval;
    }

    protected long getMaxBlockTime(long length) {
        if (this.max_block_times == null) {
            return 0L;
        }
        Long retval = null;
        for (Map.Entry<Long, Long> entry : this.max_block_times.entrySet()) {
            retval = entry.getValue();
            if (length > entry.getKey()) continue;
            break;
        }
        return retval != null ? retval : 0L;
    }

    protected abstract boolean handleMulticastMessage();

    protected abstract void handleCredit(Address var1, long var2);

    @ManagedOperation(description="Unblocks all senders")
    public void unblock() {
    }

    @Override
    public void init() throws Exception {
        boolean min_credits_set;
        boolean bl = min_credits_set = this.min_credits != 0L;
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (!this.frag_size_received) {
            this.log.warn("No fragmentation protocol was found. When flow control is used, we recommend a fragmentation protocol, due to http://jira.jboss.com/jira/browse/JGRP-590");
        }
        this.running = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.running = false;
        this.ignore_thread.set(false);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                int length;
                boolean process;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet((byte)8)) break;
                Address dest = msg.getDest();
                boolean multicast = dest == null || dest.isMulticastAddress();
                boolean handle_multicasts = this.handleMulticastMessage();
                boolean bl = process = handle_multicasts && multicast || !handle_multicasts && !multicast;
                if (!process || (length = msg.getLength()) == 0) break;
                if (this.ignore_synchronous_response && this.ignore_thread.get().booleanValue()) {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("bypassing flow control because of synchronous response " + Thread.currentThread());
                    break;
                }
                return this.handleDownMessage(evt, msg, dest, length);
            }
            case 56: {
                this.handleConfigEvent((Map)evt.getArg());
                break;
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                boolean process;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet((byte)8)) break;
                Address dest = msg.getDest();
                boolean multicast = dest == null || dest.isMulticastAddress();
                boolean handle_multicasts = this.handleMulticastMessage();
                FcHeader hdr = (FcHeader)msg.getHeader(this.id);
                boolean bl = process = handle_multicasts && multicast || !handle_multicasts && !multicast || hdr != null;
                if (!process) break;
                if (hdr != null) {
                    switch (hdr.type) {
                        case 1: {
                            ++this.num_credit_responses_received;
                            this.handleCredit(msg.getSrc(), (Long)msg.getObject());
                            break;
                        }
                        case 2: {
                            ++this.num_credit_requests_received;
                            Address sender = msg.getSrc();
                            Long requested_credits = (Long)msg.getObject();
                            if (requested_credits == null) break;
                            this.handleCreditRequest(this.received, sender, requested_credits);
                            break;
                        }
                        default: {
                            this.log.error("header type " + hdr.type + " not known");
                        }
                    }
                    return null;
                }
                Address sender = msg.getSrc();
                long new_credits = this.adjustCredit(this.received, sender, msg.getLength());
                if (this.ignore_synchronous_response) {
                    this.ignore_thread.set(true);
                }
                try {
                    Object object = this.up_prot.up(evt);
                    return object;
                }
                finally {
                    if (this.ignore_synchronous_response) {
                        this.ignore_thread.set(false);
                    }
                    if (new_credits > 0L) {
                        this.sendCredit(sender, new_credits);
                    }
                }
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
                break;
            }
            case 56: {
                Map map = (Map)evt.getArg();
                this.handleConfigEvent(map);
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleConfigEvent(Map<String, Object> info) {
        Integer frag_size;
        if (info != null && (frag_size = (Integer)info.get("frag_size")) != null) {
            if ((long)frag_size.intValue() > this.max_credits) {
                this.log.warn("The fragmentation size of the fragmentation protocol is " + frag_size + ", which is greater than the max credits. While this is not incorrect, " + "it may lead to long blockings. Frag size should be less than max_credits " + "(http://jira.jboss.com/jira/browse/JGRP-590)");
            }
            this.frag_size_received = true;
        }
    }

    protected abstract Object handleDownMessage(Event var1, Message var2, Address var3, int var4);

    protected long adjustCredit(Map<Address, Credit> map, Address sender, int length) {
        Credit cred;
        if (sender == null || length == 0 || (cred = map.get(sender)) == null) {
            return 0L;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(sender + " used " + length + " credits, " + (cred.get() - (long)length) + " remaining");
        }
        return cred.decrementAndGet(length);
    }

    protected void handleCreditRequest(Map<Address, Credit> map, Address sender, long requested_credits) {
        Credit cred;
        if (sender == null || (cred = map.get(sender)) == null) {
            return;
        }
        long credit_response = Math.min(this.max_credits, Math.min(requested_credits, this.max_credits - cred.get()));
        if (credit_response > 0L) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("received credit request from " + sender + ": sending " + credit_response + " credits");
            }
            cred.set(this.max_credits);
            this.sendCredit(sender, credit_response);
        }
    }

    protected void sendCredit(Address dest, long credits) {
        if (this.log.isTraceEnabled() && this.log.isTraceEnabled()) {
            this.log.trace("sending " + credits + " credits to " + dest);
        }
        Message msg = new Message(dest, null, new Long(credits));
        msg.setFlag((byte)1);
        msg.putHeader(this.id, REPLENISH_HDR);
        this.down_prot.down(new Event(1, msg));
        ++this.num_credit_responses_sent;
    }

    protected void sendCreditRequest(Address dest, Long credits_needed) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("sending request for " + credits_needed + " credits to " + dest);
        }
        Message msg = new Message(dest, null, credits_needed);
        msg.putHeader(this.id, CREDIT_REQUEST_HDR);
        this.down_prot.down(new Event(1, msg));
        ++this.num_credit_requests_sent;
    }

    protected void handleViewChange(Vector<Address> mbrs) {
        if (mbrs == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("new membership: " + mbrs);
        }
        for (Address addr : mbrs) {
            if (this.received.containsKey(addr)) continue;
            this.received.put(addr, new Credit(this.max_credits));
        }
        Iterator<Address> it = this.received.keySet().iterator();
        while (it.hasNext()) {
            Address addr;
            addr = it.next();
            if (mbrs.contains(addr)) continue;
            it.remove();
        }
    }

    protected static String printMap(Map<Address, Credit> m) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Credit> entry : m.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    protected class Credit {
        protected long credits_left;
        protected int num_blockings = 0;
        protected long total_blocking_time = 0L;
        protected long last_credit_request = 0L;

        protected Credit(long credits) {
            this.credits_left = credits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized boolean decrementIfEnoughCredits(long credits, long timeout) {
            if (this.decrement(credits)) {
                return true;
            }
            if (timeout <= 0L) {
                return false;
            }
            long start = System.currentTimeMillis();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
            }
            finally {
                this.total_blocking_time += System.currentTimeMillis() - start;
                ++this.num_blockings;
            }
            return this.decrement(credits);
        }

        protected boolean decrement(long credits) {
            if (credits <= this.credits_left) {
                this.credits_left -= credits;
                return true;
            }
            return false;
        }

        protected synchronized long decrementAndGet(long credits) {
            this.credits_left = Math.max(0L, this.credits_left - credits);
            if (this.credits_left <= FlowControl.this.min_credits) {
                long credit_response = Math.min(FlowControl.this.max_credits, FlowControl.this.max_credits - this.credits_left);
                this.credits_left = FlowControl.this.max_credits;
                return credit_response;
            }
            return 0L;
        }

        protected synchronized void increment(long credits) {
            this.credits_left = Math.min(FlowControl.this.max_credits, this.credits_left + credits);
            this.notifyAll();
        }

        protected synchronized boolean needToSendCreditRequest() {
            long current_time = System.currentTimeMillis();
            if (current_time - this.last_credit_request >= FlowControl.this.max_block_time) {
                this.last_credit_request = current_time;
                return true;
            }
            return false;
        }

        protected int getNumBlockings() {
            return this.num_blockings;
        }

        protected long getTotalBlockingTime() {
            return this.total_blocking_time;
        }

        protected synchronized long get() {
            return this.credits_left;
        }

        protected synchronized void set(long new_credits) {
            this.credits_left = Math.min(FlowControl.this.max_credits, new_credits);
            this.notifyAll();
        }

        public String toString() {
            return String.valueOf(this.credits_left);
        }
    }
}

