/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn.config.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.infinispan.config.InfinispanConfiguration;
import org.jboss.ha.ispn.config.CacheContainerRegistryConfiguration;
import org.jboss.ha.ispn.config.CacheContainerRegistryConfigurationSource;
import org.jboss.ha.ispn.config.xml.NamespaceResourceResolver;
import org.jboss.ha.ispn.config.xml.PropertyReplacementFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLCacheContainerRegistryConfigurationSource
implements CacheContainerRegistryConfigurationSource {
    private static final String SCHEMA = "META-INF/infinispan-configs.xsd";
    private static final String INFINISPAN_NAMESPACE = "urn:infinispan:config:4.2";
    private static final String INFINISPAN_SCHEMA = InfinispanConfiguration.resolveSchemaPath();
    private final URL infinispanSchemaURL;
    private final URL schemaURL;
    private final URL xmlURL;

    public XMLCacheContainerRegistryConfigurationSource(URL url) {
        this.xmlURL = url;
        this.schemaURL = XMLCacheContainerRegistryConfigurationSource.findResource(SCHEMA);
        this.infinispanSchemaURL = XMLCacheContainerRegistryConfigurationSource.findResource(INFINISPAN_SCHEMA);
    }

    public XMLCacheContainerRegistryConfigurationSource(String resource) {
        this(XMLCacheContainerRegistryConfigurationSource.findResource(resource));
    }

    private static URL findResource(String resource) {
        try {
            return new URL(resource);
        }
        catch (MalformedURLException e) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
            if (url == null) {
                throw new IllegalArgumentException("Failed to locate resource: " + resource);
            }
            return url;
        }
    }

    public CacheContainerRegistryConfiguration getRegistryConfiguration() throws JAXBException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Map<String, URL> schemaURLs = Collections.singletonMap(INFINISPAN_NAMESPACE, this.infinispanSchemaURL);
        schemaFactory.setResourceResolver(new NamespaceResourceResolver(Collections.singletonMap("http://www.w3.org/2001/XMLSchema", schemaURLs)));
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{CacheContainerRegistryConfiguration.class}).createUnmarshaller();
        unmarshaller.setSchema(schemaFactory.newSchema(this.schemaURL));
        PropertyReplacementFilter reader = new PropertyReplacementFilter(XMLReaderFactory.createXMLReader());
        SAXSource source = new SAXSource(reader, new InputSource(this.xmlURL.toString()));
        return (CacheContainerRegistryConfiguration)unmarshaller.unmarshal((Source)source);
    }
}

