/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.factory.session.stateful;

import java.io.Serializable;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.impl.factory.session.SessionSpecProxyFactory;
import org.jboss.ejb3.proxy.impl.factory.session.stateful.StatefulSessionProxyFactoryBase;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.impl.handler.session.SessionRemoteProxyInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionRemoteProxyFactory
extends StatefulSessionProxyFactoryBase
implements SessionSpecProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulSessionRemoteProxyFactory.class);
    private static final String DEFAULT_STACK_NAME_STATEFUL_SESSION_CLIENT_INTERCEPTORS = "StatefulSessionClientInterceptors";
    private String url;

    public StatefulSessionRemoteProxyFactory(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, String url, Advisor advisor, String interceptorStackName) {
        super(name, containerName, containerGuid, metadata, classloader, advisor, interceptorStackName);
        this.setUrl(url);
    }

    @Override
    protected final Set<String> getBusinessInterfaceTypes() {
        return this.getMetadata().getBusinessRemotes();
    }

    @Override
    protected final String getHomeType() {
        return this.getMetadata().getHome();
    }

    @Override
    protected final String getEjb2xInterfaceType() {
        return this.getMetadata().getRemote();
    }

    @Override
    protected SessionProxyInvocationHandler createBusinessInterfaceSpecificInvocationHandler(Serializable target, String businessInterfaceName) {
        String containerName = this.getContainerName();
        String url = this.getUrl();
        String containerGuid = this.getContainerGuid();
        Interceptor[] interceptors = this.getInterceptors();
        SessionRemoteProxyInvocationHandler handler = new SessionRemoteProxyInvocationHandler(containerName, containerGuid, interceptors, businessInterfaceName, target, url);
        return handler;
    }

    @Override
    protected SessionProxyInvocationHandler createBusinessDefaultInvocationHandler(Serializable target) {
        return this.createBusinessInterfaceSpecificInvocationHandler(target, null);
    }

    @Override
    protected SessionProxyInvocationHandler createEjb2xComponentInterfaceInvocationHandler(Serializable target) {
        return this.createBusinessDefaultInvocationHandler(target);
    }

    @Override
    protected SessionProxyInvocationHandler createHomeInvocationHandler() {
        return this.createBusinessDefaultInvocationHandler(null);
    }

    @Override
    protected String getDefaultInterceptorStackName() {
        return DEFAULT_STACK_NAME_STATEFUL_SESSION_CLIENT_INTERCEPTORS;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

