/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.music.encoders.BuiltinEncoder;
import com.pugh.sockso.music.encoders.Encoders;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.User;
import com.pugh.sockso.web.action.FileServer;
import com.pugh.sockso.web.action.MusicStream;
import com.pugh.sockso.web.action.WebAction;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class Streamer
extends WebAction {
    private static final int STREAM_BUFFER_SIZE = 8192;
    private static final Logger log = Logger.getLogger(Streamer.class);

    public void handleRequest() throws SQLException, IOException, BadRequestException {
        Request req = this.getRequest();
        String trackId = req.getUrlParam(1);
        this.playTrack(Integer.parseInt(trackId));
    }

    public boolean requiresLogin() {
        Properties p = this.getProperties();
        return p.get("stream.requireLogin").equals("yes");
    }

    protected void playTrack(int trackId) throws SQLException, IOException, BadRequestException {
        Track track = this.getTrack(trackId);
        MusicStream ms = this.getMusicStream(track);
        this.logTrackPlayed(track);
        this.sendTrackHeaders(track, ms.getMimeType());
        this.playMusicStream(ms);
    }

    protected Track getTrack(int trackId) throws SQLException, BadRequestException {
        block3: {
            Track track;
            ResultSet rs = null;
            PreparedStatement st = null;
            try {
                Database db = this.getDatabase();
                String sql = Track.getSelectFromSql() + " where t.id = ? ";
                st = db.prepare(sql);
                st.setInt(1, trackId);
                rs = st.executeQuery();
                if (!rs.next()) break block3;
                track = Track.createFromResultSet(rs);
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
            return track;
        }
        throw new BadRequestException("invalid track id specified: " + trackId, 404);
    }

    private DataInputStream getAudioStreamFromCommand(Track track, String command) throws IOException {
        String[] cmdArgs = command.split(" ");
        Object[] allArgs = new String[cmdArgs.length + 2];
        for (int i = 0; i < cmdArgs.length; ++i) {
            allArgs[i] = cmdArgs[i];
        }
        allArgs[cmdArgs.length] = track.getPath();
        allArgs[cmdArgs.length + 1] = "-";
        log.debug((Object)("Encoding with custom command: " + Arrays.toString(allArgs)));
        ProcessBuilder pb = new ProcessBuilder((String[])allArgs);
        Process process = pb.start();
        return new DataInputStream(process.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logTrackPlayed(Track track) {
        log.debug((Object)("Track: " + track.getPath()));
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            User user = this.getUser();
            String sql = " insert into play_log ( track_id, date_played, user_id )  values ( ?, current_timestamp, ? ) ";
            st = db.prepare(" insert into play_log ( track_id, date_played, user_id )  values ( ?, current_timestamp, ? ) ");
            st.setInt(1, track.getId());
            if (user != null) {
                st.setInt(2, user.getId());
            } else {
                st.setNull(2, 4);
            }
            st.execute();
            Utils.close(st);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        finally {
            Utils.close(st);
        }
    }

    private MusicStream getMusicStream(Track track) throws IOException {
        String command;
        Properties p = this.getProperties();
        String ext = Utils.getExt(track.getPath());
        String type = p.get("encoders." + ext);
        if (Encoders.Type.BUILTIN.name().equals(type)) {
            String name = p.get("encoders." + ext + ".name");
            String bitrate = p.get("encoders." + ext + ".bitrate");
            BuiltinEncoder encoder = Encoders.getBuiltinEncoderByName(name).getEncoder();
            if (encoder != null) {
                return new MusicStream(encoder.getAudioStream(track, bitrate.equals("") ? encoder.getDefaultBitrate() : Integer.valueOf(bitrate).intValue()), encoder.getOutputMimeType());
            }
        }
        if (Encoders.Type.CUSTOM.name().equals(type) && !(command = p.get("encoders." + ext + ".command")).equals("")) {
            return new MusicStream(this.getAudioStreamFromCommand(track, command), "");
        }
        log.debug((Object)"Streaming unaltered");
        return new MusicStream(new DataInputStream(new FileInputStream(track.getPath())), FileServer.getMimeType(track.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean playMusicStream(MusicStream ms) throws IOException {
        DataInputStream audio = null;
        byte[] buffer = new byte[8192];
        try {
            DataOutputStream client = new DataOutputStream(this.getResponse().getOutputStream());
            audio = ms.getAudioStream();
            while (true) {
                audio.read(buffer);
                client.write(buffer, 0, buffer.length);
            }
        }
        catch (EOFException e) {
            Utils.close(audio);
            return true;
        }
        catch (SocketException e) {
            try {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {}
            finally {
                Utils.close(audio);
                return true;
            }
        }
    }

    protected void sendTrackHeaders(Track track, String mimeType) {
        Response res = this.getResponse();
        String contentLength = Long.toString(new File(track.getPath()).length());
        String filename = track.getArtist().getName() + " - " + track.getName();
        res.addHeader("Content-type", mimeType);
        res.addHeader("Content-length", contentLength);
        res.addHeader("Content-Disposition", "filename=\"" + filename + "\"");
        res.sendHeaders();
    }
}

