/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.web.action.AbstractCoverSearch;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class AmazonCoverSearch
extends AbstractCoverSearch {
    protected static final Logger log = Logger.getLogger(AbstractCoverSearch.class);

    public AmazonCoverSearch(Database db) {
        super(db);
    }

    public BufferedImage getCover(String itemName) {
        try {
            String keywords = this.getSearchKeywords(itemName);
            if (keywords == null) {
                return null;
            }
            String urlString = this.getCoverUrl(keywords);
            if (urlString != null) {
                URL url = new URL(urlString);
                HttpURLConnection cnn = (HttpURLConnection)url.openConnection();
                BufferedImage cover = ImageIO.read(cnn.getInputStream());
                return cover;
            }
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        return null;
    }

    protected String getCoverUrl(String keywords) throws IOException {
        String searchUrl = "http://amazon.com/s/?url=search-alias%3Dpopular&field-keywords=" + Utils.URLEncode(keywords);
        log.debug((Object)("Amazon query: " + searchUrl));
        URL url = new URL(searchUrl);
        HttpURLConnection cnn = (HttpURLConnection)url.openConnection();
        cnn.setRequestMethod("GET");
        return this.getCoverFromSearchResults(cnn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCoverFromSearchResults(HttpURLConnection cnn) throws IOException {
        String string;
        String s = "";
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(cnn.getInputStream()));
            while ((s = in.readLine()) != null) {
                Pattern pattern = Pattern.compile(".*img src=\"(http://.+.images-amazon.com/images/.+/.+_SL.+_A.+_\\.(jpg|gif|png))\\\".*");
                Matcher m = pattern.matcher(s);
                if (!m.matches()) break block4;
                string = m.group(1);
            }
        }
        catch (Throwable throwable) {
            Utils.close(in);
            throw throwable;
        }
        {
            block4: {
                Utils.close(in);
                return string;
            }
            continue;
        }
        Utils.close(in);
        return null;
    }
}

