/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.action.Downloader;
import com.pugh.sockso.web.action.Feeder;
import com.pugh.sockso.web.action.FileServer;
import com.pugh.sockso.web.action.Homer;
import com.pugh.sockso.web.action.Jsoner;
import com.pugh.sockso.web.action.Nater;
import com.pugh.sockso.web.action.Player;
import com.pugh.sockso.web.action.Sharer;
import com.pugh.sockso.web.action.Streamer;
import com.pugh.sockso.web.action.Uploader;
import com.pugh.sockso.web.action.Userer;
import com.pugh.sockso.web.action.WebAction;
import com.pugh.sockso.web.action.browse.Albumer;
import com.pugh.sockso.web.action.browse.Artister;
import com.pugh.sockso.web.action.browse.ByLetterer;
import com.pugh.sockso.web.action.browse.Folderer;
import com.pugh.sockso.web.action.browse.Latester;
import com.pugh.sockso.web.action.browse.Playlister;
import com.pugh.sockso.web.action.browse.Playlistser;
import com.pugh.sockso.web.action.browse.Popularer;
import com.pugh.sockso.web.action.playlist.M3uer;
import com.pugh.sockso.web.action.playlist.Plser;
import com.pugh.sockso.web.action.playlist.Xspfer;

public class Dispatcher {
    private final Resources r;
    private final Server sv;
    private final CollectionManager cm;

    public Dispatcher(Resources r, Server sv, CollectionManager cm) {
        this.r = r;
        this.sv = sv;
        this.cm = cm;
    }

    public WebAction getAction(Request req) {
        String command = req.getUrlParam(0);
        if (command.equals("file")) {
            return new FileServer(this.r);
        }
        if (command.equals("browse")) {
            return this.getBrowseAction(req);
        }
        if (command.equals("")) {
            return new Homer();
        }
        if (command.equals("xspf")) {
            return new Xspfer(this.sv);
        }
        if (command.equals("m3u")) {
            return new M3uer(this.sv);
        }
        if (command.equals("pls")) {
            return new Plser(this.sv);
        }
        if (command.equals("stream")) {
            return new Streamer();
        }
        if (command.equals("json")) {
            return new Jsoner(this.cm);
        }
        if (command.equals("user")) {
            return new Userer();
        }
        if (command.equals("player")) {
            return new Player();
        }
        if (command.equals("download")) {
            return new Downloader();
        }
        if (command.equals("upload")) {
            return new Uploader(this.cm);
        }
        if (command.equals("share")) {
            return new Sharer(this.sv);
        }
        if (command.equals("rss")) {
            return new Feeder(this.sv);
        }
        if (command.equals("nat")) {
            return new Nater();
        }
        return null;
    }

    protected WebAction getBrowseAction(Request req) {
        String command = req.getUrlParam(1);
        if (command.equals("folders")) {
            return new Folderer();
        }
        if (command.equals("popular")) {
            return new Popularer();
        }
        if (command.equals("latest")) {
            return new Latester();
        }
        if (command.equals("letter")) {
            return new ByLetterer();
        }
        if (command.equals("artist")) {
            return new Artister();
        }
        if (command.equals("album")) {
            return new Albumer();
        }
        if (command.equals("playlists")) {
            return new Playlistser();
        }
        if (command.equals("playlist")) {
            return new Playlister();
        }
        return null;
    }
}

