/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.TMain;
import com.pugh.sockso.templates.web.browse.IMusicLinks;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TMainImpl
extends AbstractTemplateImpl
implements TMain.Intf {
    private final Locale locale;
    private final User user;
    private final Vector<Track> recentTracks;
    private final Properties properties;
    private final String title;
    private final Vector<User> recentUsers;
    private final Vector<Artist> topArtists;
    private final Vector<Album> recentAlbums;

    protected static TMain.ImplData __jamon_setOptionalArguments(TMain.ImplData p_implData) {
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        if (!p_implData.getRecentTracks__IsNotDefault()) {
            p_implData.setRecentTracks(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        if (!p_implData.getTitle__IsNotDefault()) {
            p_implData.setTitle("Sockso");
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getTopArtists__IsNotDefault()) {
            p_implData.setTopArtists(null);
        }
        if (!p_implData.getRecentAlbums__IsNotDefault()) {
            p_implData.setRecentAlbums(null);
        }
        return p_implData;
    }

    public TMainImpl(TemplateManager p_templateManager, TMain.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TMainImpl.__jamon_setOptionalArguments(p_implData));
        this.locale = p_implData.getLocale();
        this.user = p_implData.getUser();
        this.recentTracks = p_implData.getRecentTracks();
        this.properties = p_implData.getProperties();
        this.title = p_implData.getTitle();
        this.recentUsers = p_implData.getRecentUsers();
        this.topArtists = p_implData.getTopArtists();
        this.recentAlbums = p_implData.getRecentAlbums();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_2 = new IHeader(this.getTemplateManager());
        __jamon__var_2.setProperties(this.properties);
        __jamon__var_2.setTitle("Home");
        __jamon__var_2.setLocale(this.locale);
        __jamon__var_2.setUser(this.user);
        __jamon__var_2.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n");
        if (!this.properties.get("www.covers.disable").equals("yes")) {
            jamonWriter.write("\n    ");
            if (this.recentAlbums.size() > 0) {
                jamonWriter.write("\n        <div class=\"albumArt\">\n            <h2>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.recentlyPlayedAlbums")), jamonWriter);
                jamonWriter.write("</h2>\n            <ul>\n            ");
                for (Album album : this.recentAlbums) {
                    jamonWriter.write("\n                <li>\n                    <a href=\"/browse/album/");
                    Escaping.HTML.write(StandardEmitter.valueOf((int)album.getId()), jamonWriter);
                    jamonWriter.write("\" title=\"");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)(Utils.u2e(album.getArtist().getName()) + " - " + Utils.u2e(album.getName()))), jamonWriter);
                    jamonWriter.write("\"><img class=\"cover\" src=\"/file/cover/al");
                    Escaping.HTML.write(StandardEmitter.valueOf((int)album.getId()), jamonWriter);
                    jamonWriter.write("\" /></a>\n                    <div class=\"links\">\n                        ");
                    IMusicLinks __jamon__var_3 = new IMusicLinks(this.getTemplateManager());
                    __jamon__var_3.setProperties(this.properties);
                    __jamon__var_3.setPlayRandomLink(true);
                    __jamon__var_3.setLocale(this.locale);
                    __jamon__var_3.setId(album.getId());
                    __jamon__var_3.setName(album.getName());
                    __jamon__var_3.setType("al");
                    __jamon__var_3.renderNoFlush(jamonWriter);
                    jamonWriter.write("\n                    </div>\n                </li>\n            ");
                }
                jamonWriter.write("\n            </ul>\n        </div>\n    ");
            }
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n\n<div class=\"clearer\"></div>\n\n<div class=\"section\">\n    <h3>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.recentlyPlayedTracks")), jamonWriter);
        jamonWriter.write("</h3>\n    <ul class=\"musiclist\">\n    ");
        if (this.recentTracks.size() > 0) {
            jamonWriter.write("\n        ");
            for (Track track : this.recentTracks) {
                jamonWriter.write("\n            <li class=\"track\">\n                ");
                IMusicLinks __jamon__var_4 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_4.setProperties(this.properties);
                __jamon__var_4.setLocale(this.locale);
                __jamon__var_4.setId(track.getId());
                __jamon__var_4.setName(track.getName());
                __jamon__var_4.setType("tr");
                __jamon__var_4.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                <span class=\"link\">\n                    <a href=\"/browse/artist/");
                Escaping.HTML.write(StandardEmitter.valueOf((int)track.getArtist().getId()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getArtist().getName())), jamonWriter);
                jamonWriter.write("</a>\n                    -\n                    ");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getName())), jamonWriter);
                jamonWriter.write("\n                </span>\n            </li>\n        ");
            }
            jamonWriter.write("\n    ");
        } else {
            jamonWriter.write("\n        <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n    ");
        }
        jamonWriter.write("\n    </ul>\n</div>\n\n<div class=\"section\">\n    <h3>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.topArtists")), jamonWriter);
        jamonWriter.write("</h3>\n    <ul class=\"musiclist\">\n    ");
        if (this.topArtists.size() > 0) {
            jamonWriter.write("\n        ");
            for (Artist artist : this.topArtists) {
                jamonWriter.write("\n            <li class=\"artist\">\n                ");
                IMusicLinks __jamon__var_5 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_5.setProperties(this.properties);
                __jamon__var_5.setLocale(this.locale);
                __jamon__var_5.setId(artist.getId());
                __jamon__var_5.setName(artist.getName());
                __jamon__var_5.setType("ar");
                __jamon__var_5.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                <span class=\"link\">\n                    <a href=\"/browse/artist/");
                Escaping.HTML.write(StandardEmitter.valueOf((int)artist.getId()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(artist.getName())), jamonWriter);
                jamonWriter.write("</a>\n                </span>\n                <span class=\"info\">(");
                Escaping.HTML.write(StandardEmitter.valueOf((int)artist.getPlayCount()), jamonWriter);
                jamonWriter.write(" play");
                if (artist.getPlayCount() != 1) {
                    jamonWriter.write("s");
                }
                jamonWriter.write(")</span>\n            </li>\n        ");
            }
            jamonWriter.write("\n    ");
        } else {
            jamonWriter.write("\n        <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n    ");
        }
        jamonWriter.write("\n    </ul>\n</div>\n\n");
        IFooter __jamon__var_6 = new IFooter(this.getTemplateManager());
        __jamon__var_6.setLocale(this.locale);
        __jamon__var_6.setProperties(this.properties);
        __jamon__var_6.setRecentUsers(this.recentUsers);
        __jamon__var_6.setUser(this.user);
        __jamon__var_6.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

