/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.widget.HotKeyAction;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;

public class ButtonWidget
extends ImageLabelWidget
implements PropertyChangeListener {
    private Action action;
    private char mnemonics_key = (char)65535;
    private HotKeyAction mnemAction;
    public static int BORDER_RADIUS = 3;
    private Object key = new Object();
    private Object selectedImage;
    private boolean selected;
    protected static final Color BORDER_COLOR = new Color(8363449);
    private static final Color HOVER_COLOR = new Color(0xFF9900);
    private static final Color BACKGROUND_COLOR_1 = new Color(0xD2D2DD);
    private static final Color BACKGROUND_COLOR_2 = new Color(0xF8F8F8);
    private static final Color BACKGROUND_COLOR_PRESSED = new Color(0xCCCCCC);
    private static final Color BACKGROUND_COLOR_DISABLED = new Color(0xE4E4E4);

    public ButtonWidget(Scene scene, String string) {
        this(scene, null, string);
    }

    public ButtonWidget(Scene scene, Image image) {
        this(scene, image, null);
    }

    public ButtonWidget(Scene scene, Image image, String string) {
        super(scene, image, string);
        this.setRoundedBorder(BORDER_RADIUS, 0, 0, null);
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)ButtonSelectProvider.DEFAULT));
        this.getActions().addAction(scene.createWidgetHoverAction());
    }

    public ButtonWidget(Scene scene, Action action) {
        this(scene, null, ButtonWidget.getActionName(action));
        this.setAction(action);
        this.setToolTipText(ButtonWidget.getActionTooltip(action));
        this.setMnemonics(ButtonWidget.getActionMnemonics(action));
    }

    public void setRoundedBorder(int n, int n2, int n3, Color color) {
        this.setBorder(new ButtonBorder(this, new Insets(n + n3, n + n2, n + n3, n + n2), n, color));
    }

    public void setAction(Action action) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this);
        }
        this.action = action;
        if (this.action != null) {
            this.action.addPropertyChangeListener(this);
            this.setButtonEnabled(action.isEnabled());
        }
    }

    public void setMnemonics(char c) {
        this.mnemonics_key = Character.toUpperCase(c);
        if (this.mnemonics_key != '\uffff' && this.mnemAction == null) {
            this.mnemAction = new HotKeyAction(new ButtonHotKeyProvider(this));
            this.getScene().getActions().addAction((WidgetAction)this.mnemAction);
        }
    }

    public char getMnemonics() {
        return this.mnemonics_key;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.action && "enabled".equals(propertyChangeEvent.getPropertyName())) {
            this.setButtonEnabled((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public void setButtonEnabled(boolean bl) {
        this.setEnabled(bl);
        this.setPaintAsDisabled(!bl);
        this.revalidate(true);
    }

    public boolean isButtonEnabled() {
        return this.isEnabled();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            if (this.selectedImage != null) {
                this.setImage(this.selectedImage);
            }
            this.revalidate(true);
        }
    }

    public final void setImage(Object object) {
        this.selectedImage = this.getImage();
        if (this.selectedImage == null) {
            this.selectedImage = this.getImageWidget();
        }
        if (object instanceof Image) {
            super.setImage((Image)object);
        }
        if (object instanceof Widget) {
            super.setImage((Widget)object);
        }
    }

    public final void setSelectedImage(Object object) {
        this.selectedImage = object;
    }

    public void performAction() {
        if (this.isButtonEnabled() && this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 0, this.getActionCommand()));
        }
    }

    public String getActionCommand() {
        return (String)this.action.getValue("ActionCommandKey");
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        if (objectState.isWidgetAimed() != objectState2.isWidgetAimed() || objectState.isWidgetHovered() != objectState2.isWidgetHovered() || objectState.isFocused() != objectState2.isFocused()) {
            this.revalidate(true);
        }
    }

    protected boolean isAimingAllowed() {
        return true;
    }

    protected Object hashKey() {
        return this.key;
    }

    protected void notifyAdded() {
        super.notifyAdded();
        Scene scene = this.getScene();
        if (scene instanceof ObjectScene) {
            ObjectScene objectScene = (ObjectScene)scene;
            objectScene.addObject(this.hashKey(), new Widget[]{this});
        }
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        Scene scene = this.getScene();
        if (scene instanceof ObjectScene) {
            ((ObjectScene)scene).removeObject(this.hashKey());
        }
    }

    private static String getActionName(Action action) {
        return (String)action.getValue("Name");
    }

    private static Image getActionIcon(Action action) {
        Object object = action.getValue("SmallIcon");
        return object instanceof ImageIcon ? ((ImageIcon)object).getImage() : null;
    }

    private static String getActionTooltip(Action action) {
        return (String)action.getValue("ShortDescription");
    }

    private static char getActionMnemonics(Action action) {
        String string = ButtonWidget.getActionName(action);
        if (string == null) {
            return '\uffff';
        }
        Integer n = (Integer)action.getValue("MnemonicKey");
        if (n == null) {
            return '\uffff';
        }
        if (n < 0 || string.length() < n) {
            return '\uffff';
        }
        return string.charAt(n);
    }

    private static Color grayFilter(Color color) {
        int n = Math.round(0.299f * (float)color.getRed() + 0.587f * (float)color.getGreen() + 0.114f * (float)color.getBlue());
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return new Color(n, n, n);
    }

    public static final class ButtonHotKeyProvider
    implements HotKeyAction.HotKeyProvider {
        private ButtonWidget widget;

        public ButtonHotKeyProvider(ButtonWidget buttonWidget) {
            this.widget = buttonWidget;
        }

        public boolean processHotKey(Widget widget, char c) {
            if (this.widget.isVisible() && this.widget.getMnemonics() == c) {
                this.widget.performAction();
                return true;
            }
            return false;
        }
    }

    private static final class ButtonSelectProvider
    implements SelectProvider {
        public static ButtonSelectProvider DEFAULT = new ButtonSelectProvider();

        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return widget instanceof ButtonWidget && ((ButtonWidget)widget).isAimingAllowed() && widget.isHitAt(point);
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            return widget instanceof ButtonWidget && widget.isHitAt(point);
        }

        public void select(Widget widget, Point point, boolean bl) {
            if (widget instanceof ButtonWidget) {
                ((ButtonWidget)widget).performAction();
            }
        }
    }

    protected static class ButtonBorder
    implements Border {
        private ButtonWidget button;
        private Color borderColor;
        private Insets insets;
        private int radius;

        public ButtonBorder(ButtonWidget buttonWidget, Insets insets, int n, Color color) {
            this.button = buttonWidget;
            this.insets = insets;
            this.radius = n;
            this.borderColor = color != null ? color : BORDER_COLOR;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Paint paint = graphics2D.getPaint();
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double((float)rectangle.x + 0.5f, (float)rectangle.y + 0.5f, (float)rectangle.width - 1.0f, (float)rectangle.height - 1.0f, this.radius * 2, this.radius * 2);
            if (this.button.isButtonEnabled()) {
                if (this.button.isOpaque()) {
                    graphics2D.setPaint(this.button.isSelected() ? BACKGROUND_COLOR_PRESSED : new GradientPaint(0.0f, rectangle.y, BACKGROUND_COLOR_1, 0.0f, (float)rectangle.y + (float)rectangle.height * 0.5f, BACKGROUND_COLOR_2, true));
                    graphics2D.fill(double_);
                }
                if (this.button.getState().isWidgetAimed()) {
                    graphics2D.setPaint(BACKGROUND_COLOR_PRESSED);
                    graphics2D.fill(double_);
                } else {
                    Area area = new Area(double_);
                    Area area2 = new Area(new RoundRectangle2D.Double((float)rectangle.x + 2.5f, (float)rectangle.y + 2.5f, (float)rectangle.width - 5.0f, (float)rectangle.height - 5.0f, this.radius * 2, this.radius * 2));
                    area.subtract(area2);
                    if (this.button.getState().isHovered()) {
                        graphics2D.setPaint(HOVER_COLOR);
                        graphics2D.fill(area);
                    } else if (this.button.getState().isFocused()) {
                        graphics2D.setPaint(BORDER_COLOR);
                        graphics2D.fill(area);
                    }
                }
                graphics2D.setPaint(BORDER_COLOR);
                graphics2D.draw(double_);
            } else {
                if (this.button.isOpaque()) {
                    graphics2D.setPaint(BACKGROUND_COLOR_DISABLED);
                    graphics2D.fill(double_);
                }
                graphics2D.setPaint(ButtonWidget.grayFilter(BORDER_COLOR));
                graphics2D.draw(double_);
            }
            graphics2D.setPaint(paint);
        }

        public boolean isOpaque() {
            return false;
        }
    }
}

