/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorNode;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorTreeCellRenderer;

public final class SVGNavigatorTree
extends JTree {
    public static byte VISIBILITY_DIRECT = 1;
    public static byte VISIBILITY_UNDIRECT = (byte)2;
    public static byte VISIBILITY_NO = (byte)3;
    static boolean showAttributes = true;
    static boolean showIdOnly = false;
    static boolean showAnimationsOnly = false;
    private final SVGDataObject m_dObj;
    private final DefaultTreeModel m_treeModel;
    private boolean m_firstPaint;
    private String m_selectedId = null;

    public SVGNavigatorTree(SVGDataObject sVGDataObject) throws Exception {
        this.m_dObj = sVGDataObject;
        this.m_firstPaint = true;
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.putClientProperty("JTree.lineStyle", "Angled");
        DocumentElement documentElement = sVGDataObject.getModel().getModel().getRootElement();
        SVGNavigatorNode sVGNavigatorNode = new SVGNavigatorNode(documentElement, this, null, VISIBILITY_DIRECT);
        this.m_treeModel = new DefaultTreeModel(sVGNavigatorNode);
        this.setModel(this.m_treeModel);
        this.setCellRenderer(new SVGNavigatorTreeCellRenderer());
    }

    public DefaultTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    public SVGDataObject getDataObject() {
        return this.m_dObj;
    }

    String getSelectedId() {
        return this.m_selectedId;
    }

    public void filterChanged() {
        TreePath treePath;
        SVGNavigatorNode sVGNavigatorNode = (SVGNavigatorNode)this.treeModel.getRoot();
        sVGNavigatorNode.refresh();
        if (sVGNavigatorNode.getChildCount() > 0 && this.isCollapsed(treePath = new TreePath(sVGNavigatorNode))) {
            this.expandPath(treePath);
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.m_firstPaint) {
            int n = graphics.getFontMetrics(this.getFont()).getHeight();
            this.setRowHeight(n + 2);
            this.m_firstPaint = false;
        }
        super.paint(graphics);
    }

    public static boolean isTreeElement(DocumentElement documentElement) {
        return SVGFileModel.isTagElement(documentElement);
    }

    public void selectNode(String string, DocumentElement documentElement) {
        this.m_selectedId = string;
        if (string == null) {
            this.getSelectionModel().clearSelection();
            this.repaint();
        } else {
            if (documentElement == null) {
                documentElement = this.m_dObj.getModel().getElementById(string);
            }
            if (documentElement != null) {
                Object object;
                SVGNavigatorNode sVGNavigatorNode = (SVGNavigatorNode)this.treeModel.getRoot();
                SVGNavigatorNode sVGNavigatorNode2 = sVGNavigatorNode.findNode(documentElement);
                if (sVGNavigatorNode2 == null) {
                    SVGNavigatorNode sVGNavigatorNode3;
                    object = SVGFileModel.getParents(documentElement);
                    int n = object.size() - 1;
                    assert (n >= 0) : "The element must have at least one parent";
                    sVGNavigatorNode2 = sVGNavigatorNode.findNode((DocumentElement)object.get(n));
                    assert (sVGNavigatorNode2 != null) : "Tree node not found";
                    while (n > 0 && (sVGNavigatorNode3 = sVGNavigatorNode2.getChildByElemenent((DocumentElement)object.get(--n))) != null) {
                        sVGNavigatorNode2 = sVGNavigatorNode3;
                    }
                }
                object = sVGNavigatorNode2.getNodePath();
                this.makeVisible((TreePath)object);
                this.setSelectionPath((TreePath)object);
                Rectangle rectangle = this.getPathBounds((TreePath)object);
                this.scrollRectToVisible(rectangle);
                this.repaint();
            }
        }
    }

    byte checkVisibility(DocumentElement documentElement, boolean bl) {
        boolean bl2 = SVGNavigatorTree.isVisible(documentElement);
        if (!bl2 && bl) {
            for (DocumentElement documentElement2 : documentElement.getChildren()) {
                if (!SVGNavigatorTree.isTreeElement(documentElement) || this.checkVisibility(documentElement2, true) == VISIBILITY_NO) continue;
                return VISIBILITY_UNDIRECT;
            }
        }
        return bl2 ? VISIBILITY_DIRECT : VISIBILITY_NO;
    }

    private static boolean isVisible(DocumentElement documentElement) {
        String string;
        if (showIdOnly && ((string = SVGFileModel.getIdAttribute(documentElement)) == null || string.length() == 0)) {
            return false;
        }
        return !showAnimationsOnly || SVGFileModel.isAnimation(documentElement);
    }
}

