/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.project.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.ClientAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Clients;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.JaxWs;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Services;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public final class JaxWsModel {
    private JaxWs jaxws;
    private FileObject fo;
    private Object initLock = new Object();
    private List<ServiceListener> serviceListeners;
    private List<PropertyChangeListener> propertyChangeListeners;
    private ChangeSupport changeSupport;

    JaxWsModel(JaxWs jaxWs) {
        this(jaxWs, null);
    }

    JaxWsModel(JaxWs jaxWs, FileObject fileObject) {
        this.jaxws = jaxWs;
        this.fo = fileObject;
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.serviceListeners = new ArrayList<ServiceListener>();
        this.changeSupport = new ChangeSupport((Object)this);
    }

    public Service[] getServices() {
        Services services = this.jaxws.getServices();
        if (services == null) {
            return new Service[0];
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service[] serviceArray = services.getService();
        if (serviceArray == null) {
            return new Service[0];
        }
        Service[] serviceArray2 = new Service[serviceArray.length];
        for (int i = 0; i < serviceArray.length; ++i) {
            serviceArray2[i] = new Service(serviceArray[i]);
        }
        return serviceArray2;
    }

    public void setJsr109(Boolean bl) {
        this.jaxws.setJsr109(bl);
    }

    public Boolean getJsr109() {
        return this.jaxws.getJsr109();
    }

    public Service findServiceByName(String string) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.findService(string);
        return service == null ? null : new Service(service);
    }

    public Service findServiceByImplementationClass(String string) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this._findServiceByClass(string);
        return service == null ? null : new Service(service);
    }

    private org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service findService(String string) {
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service[] serviceArray = services.getService();
        if (serviceArray == null) {
            return null;
        }
        for (int i = 0; i < serviceArray.length; ++i) {
            if (!string.equals(serviceArray[i].getName())) continue;
            return serviceArray[i];
        }
        return null;
    }

    private org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service _findServiceByClass(String string) {
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service[] serviceArray = services.getService();
        if (serviceArray == null) {
            return null;
        }
        for (int i = 0; i < serviceArray.length; ++i) {
            if (!string.equals(serviceArray[i].getImplementationClass())) continue;
            return serviceArray[i];
        }
        return null;
    }

    public boolean removeService(String string) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.findService(string);
        if (string == null) {
            return false;
        }
        this.fireServiceRemoved(string);
        this.jaxws.getServices().removeService(service);
        return true;
    }

    public boolean removeServiceByClassName(String string) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service;
        if (string != null && (service = this._findServiceByClass(string)) != null) {
            this.fireServiceRemoved(service.getName());
            this.jaxws.getServices().removeService(service);
            return true;
        }
        return false;
    }

    public Service addService(String string, String string2) throws ServiceAlreadyExistsExeption {
        if (this.findService(string) != null) {
            throw new ServiceAlreadyExistsExeption(string);
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.jaxws.getServices().newService();
        service.setName(string);
        service.setImplementationClass(string2);
        this.jaxws.getServices().addService(service);
        this.fireServiceAdded(string, string2);
        return new Service(service);
    }

    public Service addService(String string, String string2, String string3, String string4, String string5, String string6) throws ServiceAlreadyExistsExeption {
        if (this.findService(string) != null) {
            throw new ServiceAlreadyExistsExeption(string);
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.jaxws.getServices().newService();
        service.setName(string);
        service.setImplementationClass(string2);
        service.setWsdlUrl(string3);
        service.setServiceName(string4);
        service.setPortName(string5);
        service.setPackageName(string6);
        this.jaxws.getServices().addService(service);
        return new Service(service);
    }

    public Client[] getClients() {
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return new Client[0];
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client[] clientArray = clients.getClient();
        if (clientArray == null) {
            return new Client[0];
        }
        Client[] clientArray2 = new Client[clientArray.length];
        for (int i = 0; i < clientArray.length; ++i) {
            clientArray2[i] = new Client(clientArray[i]);
        }
        return clientArray2;
    }

    public Client findClientByName(String string) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client client = this.findClient(string);
        return client == null ? null : new Client(client);
    }

    public Client findClientByWsdlUrl(String string) {
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client[] clientArray = clients.getClient();
        if (clientArray == null) {
            return null;
        }
        for (int i = 0; i < clientArray.length; ++i) {
            if (!string.equals(clientArray[i].getWsdlUrl())) continue;
            return new Client(clientArray[i]);
        }
        return null;
    }

    private org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client findClient(String string) {
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client[] clientArray = clients.getClient();
        if (clientArray == null) {
            return null;
        }
        for (int i = 0; i < clientArray.length; ++i) {
            if (!string.equals(clientArray[i].getName())) continue;
            return clientArray[i];
        }
        return null;
    }

    public boolean removeClient(String string) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client client = this.findClient(string);
        if (client == null) {
            return false;
        }
        this.jaxws.getClients().removeClient(client);
        return true;
    }

    public Client addClient(String string, String string2, String string3) throws ClientAlreadyExistsExeption {
        if (this.findClient(string) != null) {
            throw new ClientAlreadyExistsExeption(string);
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client client = this.jaxws.getClients().newClient();
        client.setName(string);
        client.setWsdlUrl(string2);
        if (string3 != null) {
            client.setPackageName(string3);
            client.setPackageNameForceReplace("true");
        }
        this.jaxws.getClients().addClient(client);
        return new Client(client);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        JaxWsPCL jaxWsPCL = new JaxWsPCL(propertyChangeListener);
        this.propertyChangeListeners.add(jaxWsPCL);
        this.jaxws.addPropertyChangeListener(jaxWsPCL);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (PropertyChangeListener propertyChangeListener2 : this.propertyChangeListeners) {
            if (propertyChangeListener != ((JaxWsPCL)propertyChangeListener2).getOriginalListener()) continue;
            this.jaxws.removePropertyChangeListener(propertyChangeListener2);
            this.propertyChangeListeners.remove(propertyChangeListener2);
            break;
        }
    }

    public void merge(JaxWsModel jaxWsModel) {
        if (jaxWsModel.jaxws != null) {
            this.jaxws.merge(jaxWsModel.jaxws, 3);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.jaxws.write(outputStream);
    }

    public FileObject getJaxWsFile() {
        return this.fo;
    }

    public void setJaxWsFile(FileObject fileObject) {
        this.fo = fileObject;
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (this.fo != null) {
            FileLock fileLock = null;
            OutputStream outputStream = null;
            try {
                fileLock = this.fo.lock();
                outputStream = this.fo.getOutputStream(fileLock);
                this.write(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        } else {
            throw new IOException("No FileObject for writing specified");
        }
    }

    public synchronized void addServiceListener(ServiceListener serviceListener) {
        if (serviceListener != null) {
            this.serviceListeners.add(serviceListener);
        }
    }

    public synchronized void removeServiceListener(ServiceListener serviceListener) {
        this.serviceListeners.remove(serviceListener);
    }

    void fireServiceAdded(String string, String string2) {
        Iterator<ServiceListener> iterator = this.serviceListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().serviceAdded(string, string2);
        }
    }

    void fireServiceRemoved(String string) {
        Iterator<ServiceListener> iterator = this.serviceListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().serviceRemoved(string);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private class JaxWsPCL
    implements PropertyChangeListener {
        PropertyChangeListener originalListener;

        JaxWsPCL(PropertyChangeListener propertyChangeListener) {
            this.originalListener = propertyChangeListener;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 != null) {
                if (object2 instanceof org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client) {
                    object2 = new Client((org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client)((Object)object2));
                }
                if (object2 instanceof org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service) {
                    object2 = new Service((org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service)((Object)object2));
                }
            }
            if ((object = propertyChangeEvent.getNewValue()) != null) {
                if (object instanceof org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client) {
                    object = new Client((org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client)((Object)object));
                }
                if (object instanceof org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service) {
                    object = new Service((org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service)((Object)object));
                }
            }
            this.originalListener.propertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), object2, object));
        }

        PropertyChangeListener getOriginalListener() {
            return this.originalListener;
        }
    }

    public static interface ServiceListener {
        public void serviceAdded(String var1, String var2);

        public void serviceRemoved(String var1);
    }
}

