/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public final class SimpleXmlVisitor
implements Visitor {
    private static char[] pom = new char[0];
    private static Class CHAR_ARRAY = pom.getClass();
    private Writer writer;
    private IOException storedException;

    public SimpleXmlVisitor(File file) throws IOException {
        this.writer = new OutputStreamWriter(new FileOutputStream(file));
        this.writer.write("<insane>\n");
    }

    public void close() throws IOException {
        this.writer.write("</insane>\n");
        this.writer.close();
        if (this.storedException != null) {
            throw this.storedException;
        }
    }

    public void visitClass(Class clazz) {
    }

    public void visitObject(ObjectMap objectMap, Object object) {
        try {
            if (CHAR_ARRAY == object.getClass()) {
                char[] cArray = (char[])((char[])object).clone();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] < ' ') {
                        cArray[i] = 46;
                    }
                    if (cArray[i] >= '\u0080') {
                        cArray[i] = 46;
                    }
                    if (cArray[i] == '\'') {
                        cArray[i] = 34;
                    }
                    if (cArray[i] == '<') {
                        cArray[i] = 95;
                    }
                    if (cArray[i] != '&') continue;
                    cArray[i] = 95;
                }
                this.writer.write("<object id='" + objectMap.getID(object) + "' type='" + object.getClass().getName() + "' size='" + ScannerUtils.sizeOf(object) + "' value='" + new String(cArray) + "'/>\n");
            } else {
                this.writer.write("<object id='" + objectMap.getID(object) + "' type='" + object.getClass().getName() + "' size='" + ScannerUtils.sizeOf(object) + "'/>\n");
            }
        }
        catch (IOException iOException) {
            this.storedException = iOException;
        }
    }

    public void visitObjectReference(ObjectMap objectMap, Object object, Object object2, Field field) {
        try {
            this.writer.write("<ref from='" + objectMap.getID(object) + "' name='" + SimpleXmlVisitor.getFldName(field) + "' to='" + objectMap.getID(object2) + "'/>\n");
        }
        catch (IOException iOException) {
            this.storedException = iOException;
        }
    }

    public void visitStaticReference(ObjectMap objectMap, Object object, Field field) {
        try {
            this.writer.write("<ref name='" + SimpleXmlVisitor.getFldName(field) + "' to='" + objectMap.getID(object) + "'/>\n");
        }
        catch (IOException iOException) {
            this.storedException = iOException;
        }
    }

    public void visitArrayReference(ObjectMap objectMap, Object object, Object object2, int n) {
        try {
            this.writer.write("<ref from='" + objectMap.getID(object) + "' name='" + n + "' to='" + objectMap.getID(object2) + "'/>\n");
        }
        catch (IOException iOException) {
            this.storedException = iOException;
        }
    }

    private static String getFldName(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }
}

