/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.highlight.error.HighlightProvider;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.EditorAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;

public final class HighlightProviderTaskFactory
extends EditorAwareCsmFileTaskFactory
implements PropertyChangeListener {
    public HighlightProviderTaskFactory() {
        SemanticHighlightingOptions.instance().addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (FileObject fileObject : OpenedEditors.getDefault().getVisibleEditorsFiles()) {
            this.reschedule(fileObject);
        }
    }

    protected CsmFileTaskFactory.PhaseRunner createTask(FileObject fileObject) {
        CsmFileTaskFactory.PhaseRunner phaseRunner = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            CsmFile csmFile = CsmUtilities.getCsmFile((DataObject)dataObject, (boolean)false);
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument != null && csmFile != null) {
                phaseRunner = new PhaseRunnerImpl(dataObject, csmFile, styledDocument);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        return phaseRunner != null ? phaseRunner : HighlightProviderTaskFactory.lazyRunner();
    }

    protected int taskDelay() {
        return ModelUtils.HIGHLIGHT_DELAY;
    }

    protected int rescheduleDelay() {
        return ModelUtils.RESCHEDULE_HIGHLIGHT_DELAY;
    }

    private static class PhaseRunnerImpl
    implements CsmFileTaskFactory.PhaseRunner {
        private final Collection<Cancellable> listeners = new HashSet<Cancellable>();
        private final DataObject dobj;
        private final CsmFile file;
        private final WeakReference<BaseDocument> weakDoc;

        private PhaseRunnerImpl(DataObject dataObject, CsmFile csmFile, Document document) {
            this.dobj = dataObject;
            this.file = csmFile;
            this.weakDoc = document instanceof BaseDocument ? new WeakReference<BaseDocument>((BaseDocument)document) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
            BaseDocument baseDocument = this.getDocument();
            if (baseDocument != null) {
                if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT || phase == CsmFileTaskFactory.PhaseRunner.Phase.PROJECT_PARSED) {
                    MyInterruptor myInterruptor = new MyInterruptor();
                    this.addCancelListener(myInterruptor);
                    try {
                        HighlightProvider.getInstance().update(this.file, (Document)baseDocument, this.dobj, myInterruptor);
                    }
                    finally {
                        this.removeCancelListener(myInterruptor);
                    }
                } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP) {
                    HighlightProvider.getInstance().clear((Document)baseDocument);
                }
            }
        }

        protected BaseDocument getDocument() {
            return this.weakDoc != null ? (BaseDocument)this.weakDoc.get() : null;
        }

        public boolean isValid() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addCancelListener(Cancellable cancellable) {
            Collection<Cancellable> collection = this.listeners;
            synchronized (collection) {
                this.listeners.add(cancellable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeCancelListener(Cancellable cancellable) {
            Collection<Cancellable> collection = this.listeners;
            synchronized (collection) {
                this.listeners.remove(cancellable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Collection<Cancellable> collection = this.listeners;
            synchronized (collection) {
                for (Cancellable cancellable : this.listeners) {
                    cancellable.cancel();
                }
            }
        }

        public boolean isHighPriority() {
            return false;
        }

        protected static class MyInterruptor
        implements CsmReferenceRepository.Interrupter,
        Cancellable {
            private boolean canceled = false;

            protected MyInterruptor() {
            }

            public boolean cancelled() {
                return this.canceled;
            }

            public boolean cancel() {
                this.canceled = true;
                return true;
            }
        }
    }
}

