/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.junit.nodes.JUnitTestRunnerNodeFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JUnitOutputListenerProvider
implements OutputProcessor {
    private Project prj;
    private NbMavenProject mavenproject;
    TestSession session;
    private Pattern runningPattern;
    private Pattern outDirPattern2;
    private Pattern outDirPattern;
    String outputDir;
    String runningTestClass;
    private Pattern testNamePattern = Pattern.compile(".*\\((.*)\\).*<<< (?:FAILURE)?(?:ERROR)?!\\s*");
    private Logger LOG = Logger.getLogger(JUnitOutputListenerProvider.class.getName());
    private RunConfig config;
    private static Pattern COMPARISON_PATTERN = Pattern.compile(".*expected:<(.*)> but was:<(.*)>$");

    public JUnitOutputListenerProvider(Project project, RunConfig runConfig) {
        this.prj = project;
        this.mavenproject = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        this.runningPattern = Pattern.compile("(?:\\[surefire\\] )?Running (.*)", 32);
        this.outDirPattern = Pattern.compile("Surefire report directory\\: (.*)", 32);
        this.outDirPattern2 = Pattern.compile("Setting reports dir\\: (.*)", 32);
        this.config = runConfig;
    }

    public String[] getRegisteredOutputSequences() {
        return new String[]{"mojo-execute#surefire:test"};
    }

    public void processLine(String string, OutputVisitor outputVisitor) {
        if (this.session == null) {
            return;
        }
        Matcher matcher = this.outDirPattern.matcher(string);
        if (matcher.matches()) {
            this.outputDir = matcher.group(1);
            return;
        }
        matcher = this.outDirPattern2.matcher(string);
        if (matcher.matches()) {
            this.outputDir = matcher.group(1);
            return;
        }
        matcher = this.runningPattern.matcher(string);
        if (matcher.matches()) {
            if (this.runningTestClass != null && this.outputDir != null) {
                FileObject fileObject = this.getTestReportFileObject(this.outputDir, "TEST-" + this.runningTestClass + ".xml");
                this.generateTest(fileObject);
            }
            this.runningTestClass = matcher.group(1);
            return;
        }
    }

    public void sequenceStart(String string, OutputVisitor outputVisitor) {
        if (this.session == null) {
            TestSession.SessionType sessionType = TestSession.SessionType.TEST;
            String string2 = this.config.getActionName();
            if (string2 != null && string2.contains("debug")) {
                sessionType = TestSession.SessionType.DEBUG;
            }
            final TestSession.SessionType sessionType2 = sessionType;
            this.session = new TestSession(this.mavenproject.getMavenProject().getId(), this.prj, TestSession.SessionType.TEST, (TestRunnerNodeFactory)new JUnitTestRunnerNodeFactory(this.session, this.prj));
            this.session.setRerunHandler(new RerunHandler(){

                public void rerun() {
                    RunUtils.executeMaven((RunConfig)JUnitOutputListenerProvider.this.config);
                }

                public boolean enabled() {
                    return sessionType2.equals((Object)TestSession.SessionType.TEST);
                }

                public void addChangeListener(ChangeListener changeListener) {
                }

                public void removeChangeListener(ChangeListener changeListener) {
                }
            });
            Manager.getInstance().testStarted(this.session);
        }
    }

    public void sequenceEnd(String string, OutputVisitor outputVisitor) {
        if (this.session == null) {
            return;
        }
        if (this.runningTestClass != null && this.outputDir != null) {
            FileObject fileObject = this.getTestReportFileObject(this.outputDir, "TEST-" + this.runningTestClass + ".xml");
            this.generateTest(fileObject);
        }
        Manager.getInstance().sessionFinished(this.session);
        this.runningTestClass = null;
        this.outputDir = null;
    }

    static Trouble constructTrouble(String string, String string2, String string3, boolean bl) {
        String[] stringArray;
        Trouble trouble = new Trouble(bl);
        if (string2 != null && (stringArray = COMPARISON_PATTERN.matcher(string2)).matches()) {
            trouble.setComparisonFailure(new Trouble.ComparisonFailure(stringArray.group(1), stringArray.group(2)));
        }
        if (string3 != null) {
            stringArray = StringUtils.split((String)string3, (String)"\n");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(string);
            for (int i = 1; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            trouble.setStackTrace(arrayList.toArray(new String[0]));
        }
        return trouble;
    }

    private FileObject getTestReportFileObject(String string, String string2) {
        assert (string != null);
        File file = FileUtil.normalizeFile((File)new File(this.outputDir));
        FileUtil.refreshFor((File[])new File[]{file});
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            FileObject fileObject2 = fileObject.getFileObject(string2);
            return fileObject2;
        }
        return null;
    }

    public void sequenceFail(String string, OutputVisitor outputVisitor) {
        this.sequenceEnd(string, outputVisitor);
    }

    private void generateTest(FileObject fileObject) {
        if (fileObject == null) {
            return;
        }
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            InputStream inputStream = fileObject.getInputStream();
            Document document = sAXBuilder.build(inputStream);
            Element element = document.getRootElement();
            assert ("testsuite".equals(element.getName())) : "Root name " + element.getName();
            TestSuite testSuite = new TestSuite(element.getAttributeValue("name"));
            this.session.addSuite(testSuite);
            Manager.getInstance().displaySuiteRunning(this.session, testSuite.getName());
            List list = element.getChildren("testcase");
            for (Element element2 : list) {
                String string;
                String string2;
                Element element3;
                String string3 = element2.getAttributeValue("name");
                Testcase testcase = new Testcase(string3, null, this.session);
                Element element4 = element2.getChild("system-out");
                if (element4 != null) {
                    this.logText(element4.getText(), testcase, false);
                }
                Element element5 = element2.getChild("failure");
                Status status = Status.PASSED;
                Trouble trouble = null;
                if (element5 != null) {
                    status = Status.FAILED;
                    trouble = JUnitOutputListenerProvider.constructTrouble(element5.getAttributeValue("type"), element5.getAttributeValue("message"), element5.getText(), false);
                }
                if ((element3 = element2.getChild("error")) != null) {
                    status = Status.ERROR;
                    trouble = JUnitOutputListenerProvider.constructTrouble(element3.getAttributeValue("type"), element3.getAttributeValue("message"), element3.getText(), true);
                }
                testcase.setStatus(status);
                if (trouble != null) {
                    testcase.setTrouble(trouble);
                }
                if ((string2 = element2.getAttributeValue("time")) != null) {
                    float f = Float.parseFloat(string2);
                    testcase.setTimeMillis((long)(f * 1000.0f));
                }
                if ((string = element2.getAttributeValue("classname")) != null) {
                    testcase.setClassName(string);
                    testcase.setLocation(testcase.getClassName().replace('.', '/') + ".java");
                }
                this.session.addTestCase(testcase);
            }
            String string = element.getAttributeValue("time");
            float f = Float.parseFloat(string);
            long l = (long)(f * 1000.0f);
            Manager.getInstance().displayReport(this.session, this.session.getReport(l));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private void logText(String string, Testcase testcase, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        Manager.getInstance().displayOutput(this.session, string, bl);
        testcase.addOutputLines(arrayList);
    }
}

