/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.modules.cnd.repository.sfs.FileRWAccess;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;

public class SimpleRWAccess
implements FileRWAccess {
    private RandomAccessFile randomAccessFile;
    private final Object lock = new Lock();

    public SimpleRWAccess(File file) throws IOException {
        this.randomAccessFile = new RandomAccessFile(file, "rw");
    }

    public long size() throws IOException {
        return this.randomAccessFile.length();
    }

    public void truncate(long l) throws IOException {
        this.randomAccessFile.setLength(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(long l, int n, long l2) throws IOException {
        byte[] byArray = new byte[n];
        Object object = this.lock;
        synchronized (object) {
            this.randomAccessFile.seek(l);
            this.randomAccessFile.read(byArray);
            this.randomAccessFile.seek(l2);
            this.randomAccessFile.write(byArray);
        }
    }

    public void move(FileRWAccess fileRWAccess, long l, int n, long l2) throws IOException {
        if (!(fileRWAccess instanceof SimpleRWAccess)) {
            throw new IllegalArgumentException("Illegal class to move from: " + fileRWAccess.getClass().getName());
        }
        SimpleRWAccess simpleRWAccess = (SimpleRWAccess)fileRWAccess;
        byte[] byArray = new byte[n];
        simpleRWAccess.randomAccessFile.seek(l);
        simpleRWAccess.randomAccessFile.read(byArray);
        this.randomAccessFile.seek(l2);
        this.randomAccessFile.write(byArray);
    }

    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(PersistentFactory persistentFactory, Persistent persistent, long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.randomAccessFile.seek(l);
            persistentFactory.write((DataOutput)this.randomAccessFile, persistent);
            return (int)(this.randomAccessFile.getFilePointer() - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent read(PersistentFactory persistentFactory, long l, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.randomAccessFile.seek(l);
            return persistentFactory.read((DataInput)this.randomAccessFile);
        }
    }

    public FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

