/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.railsprojects.RailsFileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerManager;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.GotoTest;
import org.netbeans.modules.ruby.rubyproject.Migrations;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseActionProvider;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunner;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RailsActionProvider
extends RubyBaseActionProvider {
    private static final Logger LOGGER = Logger.getLogger(RailsActionProvider.class.getName());
    public static final String COMMAND_RAILS_CONSOLE = "rails-console";
    private static final String[] supportedActions = new String[]{"autotest", "autospec", "rdoc", "rails-console", "run", "run.single", "debug", "debug.single", "test", "rspec", "test.single", "debug.test.single", "delete", "copy", "move", "rename"};
    private static final String[] MIME_TYPES = new String[]{"text/x-ruby", "application/x-httpd-eruby"};
    final RailsProject project;

    public RailsActionProvider(RailsProject railsProject, UpdateHelper updateHelper) {
        super((RubyBaseProject)railsProject, updateHelper);
        this.project = railsProject;
    }

    protected FileObject[] getSourceRoots() {
        return this.project.getSourceRoots().getRoots();
    }

    protected FileObject[] getTestSourceRoots() {
        return this.project.getTestSourceRoots().getRoots();
    }

    protected String[] getMimeTypes() {
        return MIME_TYPES;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    private boolean isMigrationFile(FileObject fileObject) {
        if (fileObject.getParent() == null || !fileObject.getParent().getName().equals("migrate")) {
            return false;
        }
        if (fileObject.getParent().getParent() == null || !fileObject.getParent().getParent().getName().equals("db")) {
            return false;
        }
        if (!fileObject.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        return Migrations.getMigrationVersion((String)fileObject.getName()) != null;
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        assert (rubyPlatform != null) : "Action '" + string + "' should be disabled when platform is invalid";
        boolean bl = "debug".equals(string);
        boolean bl2 = "debug.single".equals(string);
        if ("run".equals(string) || bl) {
            LifecycleManager.getDefault().saveAll();
            this.runServer("", bl);
            return;
        }
        if ("test".equals(string)) {
            boolean bl3;
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.TEST_UNIT);
            boolean bl4 = bl3 = RakeSupport.getRakeTask((Project)this.project, (String)"test") != null;
            if (bl3) {
                File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setPWD(file);
                rakeRunner.setFileLocator((RubyFileLocator)new RailsFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.setDebug("debug.single".equals(string));
                rakeRunner.run(new String[]{"test"});
            } else if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if ("test.single".equals(string) || "debug.test.single".equals(string)) {
            if (!rubyPlatform.isValid(true)) {
                return;
            }
            FileObject fileObject = this.getCurrentFile(lookup);
            if (fileObject == null) {
                return;
            }
            RailsActionProvider.saveFile((FileObject)fileObject);
            DeclarationFinder.DeclarationLocation declarationLocation = new GotoTest().findTest(fileObject, -1);
            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                fileObject = declarationLocation.getFileObject();
                RailsActionProvider.saveFile((FileObject)fileObject);
            } else if (RubyUtils.isRhtmlFile((FileObject)fileObject)) {
                return;
            }
            boolean bl5 = "debug.test.single".equals(string);
            RSpecSupport rSpecSupport = new RSpecSupport((Project)this.project);
            if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)fileObject)) {
                TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
                if (testRunner != null) {
                    testRunner.runTest(fileObject, bl5);
                } else {
                    rSpecSupport.runRSpec(null, fileObject, fileObject.getName(), (LineConvertors.FileLocator)new RailsFileLocator(lookup, (Project)this.project), true, bl5, new String[0]);
                }
                return;
            }
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.TEST_UNIT);
            if (testRunner != null) {
                testRunner.getInstance().runTest(fileObject, bl5);
            } else {
                this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl5, new LineConvertor[]{new TestNotifierLineConvertor(true, true)});
            }
            return;
        }
        if ("run.single".equals(string) || bl2) {
            if (!rubyPlatform.isValid(true)) {
                return;
            }
            FileObject fileObject = this.getCurrentFile(lookup);
            if (fileObject == null) {
                return;
            }
            if (RakeSupport.isRakeFile((FileObject)fileObject)) {
                LifecycleManager.getDefault().saveAll();
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setRakeFile(fileObject);
                rakeRunner.setFileLocator((RubyFileLocator)new RailsFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.setDebug("debug.single".equals(string));
                rakeRunner.run(new String[0]);
                return;
            }
            RSpecSupport rSpecSupport = new RSpecSupport((Project)this.project);
            if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)fileObject)) {
                TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
                boolean bl6 = "debug.single".equals(string);
                if (testRunner != null) {
                    RailsActionProvider.saveFile((FileObject)fileObject);
                    testRunner.runTest(fileObject, bl6);
                } else {
                    LifecycleManager.getDefault().saveAll();
                    rSpecSupport.runRSpec(null, fileObject, fileObject.getName(), (LineConvertors.FileLocator)new RailsFileLocator(lookup, (Project)this.project), true, bl2, new String[0]);
                }
                return;
            }
            RailsActionProvider.saveFile((FileObject)fileObject);
            if (this.isMigrationFile(fileObject)) {
                String string2 = fileObject.getName();
                Long l = Migrations.getMigrationVersion((String)string2);
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setPWD(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
                rakeRunner.setFileLocator((RubyFileLocator)new RailsFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.setParameters(new String[]{"VERSION=" + l});
                rakeRunner.run(new String[]{"db:migrate"});
                return;
            }
            String string3 = "";
            String string4 = fileObject.getName();
            if (fileObject.getExt().equals("rhtml") || fileObject.getExt().equals("erb")) {
                if (string4.endsWith(".html")) {
                    string4 = string4.substring(0, string4.length() - ".html".length());
                }
                if (!string4.startsWith("_")) {
                    string3 = string4;
                }
                FileObject fileObject2 = this.project.getProjectDirectory();
                for (FileObject fileObject3 = fileObject.getParent(); fileObject3 != null && fileObject3 != fileObject2 && (!fileObject3.getName().equals("views") || fileObject3.getParent() != null && !fileObject3.getParent().getName().equals("app")); fileObject3 = fileObject3.getParent()) {
                    string3 = fileObject3.getNameExt() + "/" + string3;
                }
            } else if (string4.endsWith("_controller")) {
                String string5;
                int n;
                FileObject fileObject4;
                FileObject fileObject5;
                string3 = string4.substring(0, string4.length() - "_controller".length());
                FileObject fileObject6 = this.project.getProjectDirectory();
                for (fileObject5 = fileObject.getParent(); fileObject5 != null && fileObject5 != fileObject6; fileObject5 = fileObject5.getParent()) {
                    if (fileObject5.getName().equals("controllers") && (fileObject5.getParent() == null || fileObject5.getParent().getName().equals("app"))) {
                        fileObject5 = fileObject5.getParent();
                        break;
                    }
                    string3 = fileObject5.getNameExt() + "/" + string3;
                }
                JTextComponent jTextComponent = GsfUtilities.getOpenPane();
                if (fileObject5 != null && jTextComponent != null && jTextComponent.getCaret() != null && (fileObject4 = GsfUtilities.findFileObject((JTextComponent)jTextComponent)) != null && (n = jTextComponent.getCaret().getDot()) >= 0 && (string5 = AstUtilities.getMethodName((FileObject)fileObject, (int)n)) != null) {
                    string3 = string3 + "/" + string5;
                }
            } else if (string4.endsWith("_helper")) {
                string3 = string4.substring(0, string4.length() - "_helper".length());
                FileObject fileObject7 = this.project.getProjectDirectory();
                for (FileObject fileObject8 = fileObject.getParent(); fileObject8 != null && fileObject8 != fileObject7 && (!fileObject8.getName().equals("helpers") || fileObject8.getParent() != null && !fileObject8.getParent().getName().equals("app")); fileObject8 = fileObject8.getParent()) {
                    string3 = fileObject8.getNameExt() + "/" + string3;
                }
            } else if (string4.endsWith("_test")) {
                TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.TEST_UNIT);
                if (testRunner != null) {
                    testRunner.getInstance().runTest(fileObject, "debug.single".equals(string));
                } else {
                    this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl2, new LineConvertor[]{new TestNotifierLineConvertor(true, true)});
                }
                return;
            }
            if (string3.length() == 0) {
                this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl2, new LineConvertor[0]);
                return;
            }
            this.runServer(string3, bl || bl2);
            return;
        }
        if ("rspec".equals(string)) {
            boolean bl7 = RakeSupport.getRakeTask((Project)this.project, (String)"spec") != null;
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
            if (bl7) {
                File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setPWD(file);
                rakeRunner.setFileLocator(new RubyFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.run(new String[]{"spec"});
            } else if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if ("rspec-all".equals(string)) {
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
            if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if ("autotest".equals(string)) {
            if (AutoTestSupport.isInstalled((Project)this.project, (TestRunner.TestType)TestRunner.TestType.AUTOTEST)) {
                AutoTestSupport autoTestSupport = new AutoTestSupport(lookup, (Project)this.project, this.getSourceEncoding());
                autoTestSupport.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                autoTestSupport.start(TestRunner.TestType.AUTOTEST);
            }
            return;
        }
        if ("autospec".equals(string)) {
            if (AutoTestSupport.isInstalled((Project)this.project, (TestRunner.TestType)TestRunner.TestType.AUTOSPEC)) {
                AutoTestSupport autoTestSupport = new AutoTestSupport(lookup, (Project)this.project, this.getSourceEncoding());
                autoTestSupport.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                autoTestSupport.start(TestRunner.TestType.AUTOSPEC);
            }
            return;
        }
        if (COMMAND_RAILS_CONSOLE.equals(string)) {
            this.openRailsConsole(lookup);
            return;
        }
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
    }

    private void openRailsConsole(Lookup lookup) {
        String string = NbBundle.getMessage(RailsActionProvider.class, (String)"RailsConsole");
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String string2 = "script" + File.separator + "console";
        String string3 = this.project.evaluator().getProperty("javac.classpath");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Utilities.isWindows() && !this.getPlatform().isJRuby()) {
            arrayList.add("--irb=irb.bat --noreadline");
        } else {
            arrayList.add("--irb=irb --noreadline");
        }
        String string4 = this.project.evaluator().getProperty("rails.env");
        if (string4 != null && !"".equals(string4.trim())) {
            arrayList.add(string4);
        }
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(this.getPlatform(), string, file, string2).showSuspended(false).showProgress(false).classPath(string3).allowInput().additionalArgs(arrayList.toArray(new String[arrayList.size()])).fileLocator((LineConvertors.FileLocator)new RailsFileLocator(lookup, (Project)this.project));
        rubyExecutionDescriptor.addStandardRecognizers();
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, this.getSourceEncoding());
        ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string).run();
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
        if (topComponent != null) {
            topComponent.requestActive();
        } else {
            LOGGER.info("Could not find the output window using id output");
        }
    }

    public RubyExecutionDescriptor getScriptDescriptor(File file, FileObject fileObject, String string, String string2, Lookup lookup, boolean bl, LineConvertor ... lineConvertorArray) {
        RubyCoverageProvider rubyCoverageProvider;
        String string3 = SharedRubyProjectProperties.getRubyOptions((RubyBaseProject)this.project);
        String string4 = RubyProjectUtil.getLoadPath((Project)this.project);
        string3 = string3 != null ? string4 + " " + string3 : string4;
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        if (!new File(string).exists() && fileObjectArray != null && fileObjectArray.length > 0) {
            FileObject fileObject2;
            boolean bl2 = false;
            for (FileObject fileObject3 : fileObjectArray) {
                fileObject2 = fileObject3.getFileObject(string);
                if (fileObject2 == null) continue;
                string = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
                bl2 = true;
                break;
            }
            if (!bl2 && fileObjectArray2 != null) {
                for (FileObject fileObject3 : fileObjectArray2) {
                    fileObject2 = fileObject3.getFileObject(string);
                    if (fileObject2 == null) continue;
                    string = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
                    break;
                }
            }
        }
        if (file == null) {
            file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        String string5 = this.project.evaluator().getProperty("javac.classpath");
        String string6 = this.project.evaluator().getProperty("jvm.args");
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(this.getPlatform(), string2, file, string);
        rubyExecutionDescriptor.debug(bl);
        rubyExecutionDescriptor.showSuspended(true);
        rubyExecutionDescriptor.allowInput();
        rubyExecutionDescriptor.initialArgs(string3);
        rubyExecutionDescriptor.jvmArguments(string6);
        rubyExecutionDescriptor.classPath(string5);
        rubyExecutionDescriptor.additionalArgs(this.getApplicationArguments());
        rubyExecutionDescriptor.fileLocator((LineConvertors.FileLocator)new RailsFileLocator(lookup, (Project)this.project));
        rubyExecutionDescriptor.addStandardRecognizers();
        rubyExecutionDescriptor.addOutConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)rubyExecutionDescriptor.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        rubyExecutionDescriptor.addErrConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)rubyExecutionDescriptor.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        if (lineConvertorArray != null) {
            for (LineConvertor lineConvertor : lineConvertorArray) {
                rubyExecutionDescriptor.addOutConvertor(lineConvertor);
            }
        }
        if ((rubyCoverageProvider = RubyCoverageProvider.get((Project)this.project)) != null && rubyCoverageProvider.isEnabled()) {
            rubyExecutionDescriptor = rubyCoverageProvider.wrapWithCoverage(rubyExecutionDescriptor, false, null);
        }
        return rubyExecutionDescriptor;
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        return this.getPlatform() != null;
    }

    private void runServer(String string, boolean bl) {
        if (!bl) {
            this.runServer(string, false, false);
        } else {
            boolean bl2;
            boolean bl3;
            if (!WebClientToolsSessionStarterService.isAvailable()) {
                bl3 = false;
                bl2 = true;
            } else {
                boolean bl4 = WebClientToolsProjectUtils.showDebugDialog((Project)this.project);
                if (!bl4) {
                    return;
                }
                bl2 = WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project);
                bl3 = WebClientToolsProjectUtils.getClientDebugProperty((Project)this.project);
            }
            assert (bl2 || bl3);
            this.runServer(string, bl2, bl3);
        }
    }

    private void runServer(String string, boolean bl, boolean bl2) {
        RailsServerManager railsServerManager = (RailsServerManager)this.project.getLookup().lookup(RailsServerManager.class);
        if (railsServerManager != null) {
            String string2;
            railsServerManager.setDebug(bl);
            railsServerManager.setClientDebug(bl2);
            if ((string == null || "".equals(string)) && (string2 = this.project.evaluator().getProperty("rails.url")) != null) {
                string = string2;
            }
            railsServerManager.showUrl(string);
        }
    }
}

