/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.support.Computable;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.TasksCachedProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowsSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final WindowsSupport instance = new WindowsSupport();
    private final TasksCachedProcessor<PathConverterParams, String> converter = new TasksCachedProcessor<PathConverterParams, String>(new PathConverter(), false);
    private final boolean isWindows = Utilities.isWindows();
    private Shell activeShell = null;
    private Map<String, String> env = null;
    private String REG_EXE;

    private WindowsSupport() {
        this.init();
        if (this.activeShell == null) {
            log.fine("WindowsSupport: no shell found");
        } else {
            log.fine("WindowsSupport: found " + (Object)((Object)this.activeShell.type) + " shell in " + this.activeShell.bindir.getAbsolutePath());
        }
    }

    public static WindowsSupport getInstance() {
        return instance;
    }

    public String getShell() {
        return this.activeShell == null ? null : this.activeShell.shell;
    }

    public synchronized void init() {
        this.init(null);
    }

    public void init(String string) {
        if (!this.isWindows) {
            return;
        }
        this.converter.resetCache();
        this.activeShell = this.findShell(string);
    }

    private Shell findShell(String string) {
        String[][] stringArrayArray;
        String[][] stringArrayArray2;
        Shell shell = null;
        Shell shell2 = null;
        String string2 = "reg.exe";
        try {
            stringArrayArray2 = System.getenv("WINDIR");
            stringArrayArray = new File((String)stringArrayArray2, "System32");
            string2 = new File((File)stringArrayArray, "reg.exe").getPath();
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        this.REG_EXE = string2;
        for (String[] stringArray : stringArrayArray2 = new String[][]{{"HKLM\\SOFTWARE\\cygwin\\setup\\", "rootdir", ".*rootdir.*REG_SZ(.*)"}, {"HKLM\\SOFTWARE\\Wow6432Node\\cygwin\\setup\\", "rootdir", ".*rootdir.*REG_SZ(.*)"}, {"HKLM\\SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/", "native", ".*native.*REG_SZ(.*)"}, {"HKLM\\SOFTWARE\\Wow6432Node\\Cygnus Solutions\\Cygwin\\mounts v2\\/", "native", ".*native.*REG_SZ(.*)"}}) {
            shell = this.initShell(Shell.ShellType.CYGWIN, this.queryWindowsRegistry(stringArray[0], stringArray[1], stringArray[2]));
            if (shell == null) continue;
            return shell;
        }
        stringArrayArray = new String[]{"HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MSYS-1.0_is1", "HKLM\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MSYS-1.0_is1"};
        for (String[] stringArray : stringArrayArray) {
            shell = this.initShell(Shell.ShellType.MSYS, this.queryWindowsRegistry((String)stringArray, "Inno Setup: App Path", ".*REG_SZ(.*)"));
            if (shell == null) continue;
            return shell;
        }
        Object object = System.getenv("PATH");
        if (string != null && string.length() > 0) {
            object = string + ';' + (String)object;
        }
        if (object != null) {
            for (String string3 : ((String)object).split(";")) {
                File file = new File(string3, "sh.exe");
                File file2 = file.getParentFile();
                if (!file.exists() || !file.canRead() || !"bin".equals(file2.getName())) continue;
                if (new File(file2, "cygcheck.exe").exists()) {
                    ShellValidationSupport.ShellValidationStatus shellValidationStatus;
                    if (shell2 == null) {
                        shell2 = new Shell(Shell.ShellType.CYGWIN, file.getAbsolutePath(), file2);
                    }
                    if (!(shellValidationStatus = ShellValidationSupport.getValidationStatus(shell2)).isValid() || shellValidationStatus.hasWarnings()) continue;
                    return shell2;
                }
                if (!new File(file2, "msysinfo").exists()) continue;
                return new Shell(Shell.ShellType.MSYS, file.getAbsolutePath(), file2);
            }
        }
        return shell2;
    }

    public int getWinPID(int n) {
        ProcessBuilder processBuilder = null;
        File file = new File(this.getActiveShell().bindir, "ps.exe");
        if (!file.exists()) {
            return n;
        }
        String string = file.getAbsolutePath();
        switch (this.getActiveShell().type) {
            case CYGWIN: {
                processBuilder = new ProcessBuilder(string, "-W", "-p", Integer.toString(n));
                break;
            }
            case MSYS: {
                processBuilder = new ProcessBuilder(string, "-W");
                break;
            }
            default: {
                return n;
            }
        }
        try {
            Process process = processBuilder.start();
            List<String> list = ProcessUtils.readProcessOutput(process);
            Pattern pattern = Pattern.compile("[I]*[\t ]*([0-9]+)[\t ]*([0-9]+)[\t ]*([0-9]+)[\t ]*([0-9]+).*");
            for (String string2 : list) {
                Integer n2;
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches() || (n2 = Integer.valueOf(Integer.parseInt(matcher.group(1)))) != n) continue;
                return Integer.parseInt(matcher.group(4));
            }
        }
        catch (IOException iOException) {
            return n;
        }
        return n;
    }

    private String queryWindowsRegistry(String string, String string2, String string3) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.REG_EXE, "query", string, "/v", string2);
            Process process = processBuilder.start();
            Pattern pattern = Pattern.compile(string3);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List<String> list = ProcessUtils.readProcessOutput(process);
            for (String string4 : list) {
                Matcher matcher = pattern.matcher(string4);
                if (!matcher.matches()) continue;
                return matcher.group(1).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string.toLowerCase().startsWith("hklm")) {
            return this.queryWindowsRegistry("HKCU" + string.substring(4), string2, string3);
        }
        return null;
    }

    public String convertToCygwinPath(String string) {
        return this.convert(Shell.PathType.WINDOWS, Shell.PathType.CYGWIN, string, true);
    }

    public String convertFromCygwinPath(String string) {
        return this.convert(Shell.PathType.CYGWIN, Shell.PathType.WINDOWS, string, true);
    }

    public String convertToMSysPath(String string) {
        return this.convert(Shell.PathType.WINDOWS, Shell.PathType.MSYS, string, true);
    }

    public String convertFromMSysPath(String string) {
        return this.convert(Shell.PathType.MSYS, Shell.PathType.WINDOWS, string, true);
    }

    public String convertToShellPath(String string) {
        return this.activeShell == null ? null : this.convert(Shell.PathType.WINDOWS, this.activeShell.type.toPathType(), string, true);
    }

    public String convertToWindowsPath(String string) {
        return this.activeShell == null ? null : this.convert(this.activeShell.type.toPathType(), Shell.PathType.WINDOWS, string, true);
    }

    public String convertToAllShellPaths(String string) {
        return this.activeShell == null ? null : this.convert(Shell.PathType.WINDOWS, this.activeShell.type.toPathType(), string, false);
    }

    private String convert(Shell.PathType pathType, Shell.PathType pathType2, String string, boolean bl) {
        if (pathType2 == null || pathType == null) {
            return null;
        }
        if (!(pathType != Shell.PathType.CYGWIN && pathType2 != Shell.PathType.CYGWIN || this.activeShell != null && this.activeShell.type == Shell.ShellType.CYGWIN)) {
            return null;
        }
        try {
            return this.converter.compute(new PathConverterParams(pathType, pathType2, string, bl));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public synchronized Map<String, String> getEnv() {
        if (this.env == null && this.isWindows) {
            this.env = Collections.unmodifiableMap(WindowsSupport.readEnv());
        }
        return this.env;
    }

    private static Map<String, String> readEnv() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(new CaseInsensitiveComparator());
        try {
            String string = System.getProperty("os.name").toLowerCase();
            String string2 = "cmd";
            if (string.contains("windows 9")) {
                string2 = "command.com";
            }
            ProcessBuilder processBuilder = new ProcessBuilder(string2, "/c", "set");
            Process process = processBuilder.start();
            List<String> list = ProcessUtils.readProcessOutput(process);
            for (String string3 : list) {
                int n = string3.indexOf(61);
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(n + 1);
                treeMap.put(string4, string5);
            }
            int n = -1;
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n != 0) {
                log.log(Level.FINE, "Unable to read environment");
                ProcessUtils.logError(Level.FINE, log, process);
            }
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "Unable to read environment", iOException);
        }
        return treeMap;
    }

    private Shell initShell(Shell.ShellType shellType, String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string + "/bin/sh.exe");
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        return new Shell(shellType, file.getAbsolutePath(), file.getParentFile().getAbsoluteFile());
    }

    public Shell getActiveShell() {
        return this.activeShell;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PathConverter
    implements Computable<PathConverterParams, String> {
        private PathConverter() {
        }

        @Override
        public String compute(PathConverterParams pathConverterParams) throws InterruptedException {
            String string = pathConverterParams.path;
            if (string == null || string.length() == 0 || !WindowsSupport.this.isWindows) {
                return string;
            }
            if (pathConverterParams.isSinglePath) {
                return this.convertSingle(pathConverterParams);
            }
            return this.convertMulty(pathConverterParams);
        }

        private String convertSingle(PathConverterParams pathConverterParams) {
            String string = "";
            String string2 = pathConverterParams.path;
            if (pathConverterParams.trgType == Shell.PathType.WINDOWS) {
                switch (pathConverterParams.srcType) {
                    case CYGWIN: {
                        List<String> list = this.cygpath("-w", Arrays.asList(string2));
                        return list == null ? null : list.get(0);
                    }
                    case MSYS: {
                        if (string2.startsWith("/") && string2.charAt(2) == '/') {
                            string = string2.charAt(1) + ":";
                            string2 = string2.substring(2);
                        }
                        string = (string + string2).replaceAll("/", "\\\\");
                        break;
                    }
                    default: {
                        string = string2;
                        break;
                    }
                }
            } else {
                switch (pathConverterParams.trgType) {
                    case CYGWIN: {
                        List<String> list = this.cygpath("-u", Arrays.asList(string2));
                        return list == null ? null : list.get(0);
                    }
                    case MSYS: {
                        string = string2;
                        if (string.length() > 2 && string.charAt(1) == ':') {
                            string = "/" + string.replaceFirst(":", "");
                        }
                        string = string.replaceAll("\\\\", "/");
                        break;
                    }
                    default: {
                        string = string2;
                    }
                }
            }
            return string;
        }

        private String convertMulty(PathConverterParams pathConverterParams) {
            String string = "";
            String string2 = pathConverterParams.path;
            if (pathConverterParams.srcType == Shell.PathType.WINDOWS) {
                Object object;
                String[] stringArray = string2.split(";");
                ArrayList<String> arrayList = new ArrayList<String>();
                switch (pathConverterParams.trgType) {
                    case CYGWIN: {
                        object = this.cygpath("-u", Arrays.asList(stringArray));
                        if (object == null) {
                            return null;
                        }
                        arrayList.addAll((Collection<String>)object);
                        break;
                    }
                    case MSYS: {
                        for (String string3 : stringArray) {
                            String string4;
                            if (string3.trim().length() <= 0 || (string4 = this.convertSingle(new PathConverterParams(Shell.PathType.WINDOWS, Shell.PathType.MSYS, string3.trim(), true))) == null) continue;
                            arrayList.add(string4);
                        }
                        break;
                    }
                }
                object = new StringBuilder();
                for (String string5 : arrayList) {
                    ((StringBuilder)object).append(string5).append(':');
                }
                string = ((StringBuilder)object).toString();
            } else {
                string = string2;
            }
            return string;
        }

        private List<String> cygpath(String string, List<String> list) {
            if (WindowsSupport.this.activeShell == null) {
                return null;
            }
            File file = new File(((WindowsSupport)WindowsSupport.this).activeShell.bindir, "cygpath.exe");
            if (!file.exists()) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            arrayList.add(string);
            arrayList.addAll(list);
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            try {
                Process process = processBuilder.start();
                List<String> list2 = ProcessUtils.readProcessOutput(process);
                int n = process.waitFor();
                if (n == 0) {
                    return list2;
                }
                log.fine(file.getAbsolutePath() + " failed.");
                ProcessUtils.logError(Level.FINE, log, process);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class PathConverterParams {
        private final Shell.PathType srcType;
        private final Shell.PathType trgType;
        private final String path;
        private final boolean isSinglePath;

        public PathConverterParams(Shell.PathType pathType, Shell.PathType pathType2, String string, boolean bl) {
            this.srcType = pathType;
            this.trgType = pathType2;
            this.path = string;
            this.isSinglePath = bl;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PathConverterParams)) {
                return false;
            }
            PathConverterParams pathConverterParams = (PathConverterParams)object;
            return this.srcType == pathConverterParams.srcType && this.trgType == pathConverterParams.trgType && this.isSinglePath == pathConverterParams.isSinglePath && (this.path == null ? pathConverterParams.path == null : this.path.equals(pathConverterParams.path));
        }

        public int hashCode() {
            int n = 7;
            n = 43 * n + this.srcType.hashCode();
            n = 43 * n + this.trgType.hashCode();
            n = 43 * n + (this.path != null ? this.path.hashCode() : 0);
            n = 43 * n + (this.isSinglePath ? 1 : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            return string.toUpperCase().compareTo(string2.toUpperCase());
        }
    }
}

