/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.ui.ShellValidationStatusPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ShellValidationSupport {
    protected static final ShellValidationStatus NOSHELL = new ShellValidationStatus(null, Arrays.asList("No shell"), null);
    protected static final ShellValidationStatus VALID = new ShellValidationStatus(null, null, null);

    private ShellValidationSupport() {
    }

    public static ShellValidationStatus getValidationStatus(Shell shell) {
        if (shell == null) {
            return NOSHELL;
        }
        if (shell.type == Shell.ShellType.CYGWIN) {
            return ShellValidationSupport.validateCygwinShell(shell);
        }
        return VALID;
    }

    private static ShellValidationStatus validateCygwinShell(Shell shell) {
        assert (shell != null && shell.type == Shell.ShellType.CYGWIN);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            File file = new File(shell.bindir, "mount.exe");
            File file2 = new File(shell.bindir, "cygpath.exe");
            if (!file.exists()) {
                arrayList.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.fileNotFound", file.getAbsolutePath()));
            }
            if (!file2.exists()) {
                arrayList.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.fileNotFound", file2.getAbsolutePath()));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(file.getAbsolutePath());
            Process process = processBuilder.start();
            List<String> list = ProcessUtils.readProcessOutput(process);
            int n = process.waitFor();
            if (n != 0) {
                arrayList.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.validationFailed", shell.bindir.getAbsolutePath()));
            }
            Pattern pattern = Pattern.compile("(.*) on (/.*) type .*");
            boolean bl = false;
            for (String string : list) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                String string2 = matcher.group(1);
                File file3 = new File(string2);
                String string3 = matcher.group(2);
                if (string3.equals("/")) {
                    bl = true;
                }
                if (!file3.exists()) {
                    arrayList.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.absentMountPoint", string2, string3));
                    continue;
                }
                if (!string3.startsWith("/usr")) continue;
                String string4 = (file3.getParentFile().getAbsolutePath() + '\\').toLowerCase();
                String string5 = (shell.bindir.getParentFile().getAbsolutePath() + '\\').toLowerCase();
                if (string5.startsWith(string4)) continue;
                arrayList2.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.wrongMountPoint", string2, string3));
            }
            if (!bl) {
                arrayList.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.rootIsNotMounted", new String[0]));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ShellValidationStatus(shell, arrayList, arrayList2);
    }

    public static boolean confirm(ShellValidationStatus shellValidationStatus) {
        return ShellValidationSupport.confirm(null, null, shellValidationStatus);
    }

    public static boolean confirm(String string, String string2, ShellValidationStatus shellValidationStatus) {
        if (shellValidationStatus == null || shellValidationStatus == NOSHELL) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ShellValidationSupport.loc("ShellValidationSupport.ValidationError.NoShell", new String[0]), 0));
            return false;
        }
        if (shellValidationStatus.isValid() && !shellValidationStatus.hasWarnings()) {
            return true;
        }
        String string3 = shellValidationStatus.shell.toString();
        String string4 = NbPreferences.forModule(WindowsSupport.class).get(string3, "no");
        if ("yes".equals(string4)) {
            return true;
        }
        final ShellValidationStatusPanel shellValidationStatusPanel = new ShellValidationStatusPanel(string, string2, shellValidationStatus.shell);
        final JButton jButton = new JButton("No");
        shellValidationStatusPanel.setActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(!shellValidationStatusPanel.isRememberDecision());
            }
        });
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)shellValidationStatusPanel, ShellValidationSupport.loc("ShellValidationSupport.ValidationError.ErrorDialogTitle", "cygwin"), true, new Object[]{DialogDescriptor.YES_OPTION, jButton}, (Object)jButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        Object object = dialogDescriptor.getValue();
        if (object == DialogDescriptor.YES_OPTION && shellValidationStatusPanel.isRememberDecision()) {
            NbPreferences.forModule(WindowsSupport.class).put(string3, "yes");
        }
        return object == DialogDescriptor.YES_OPTION;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(ShellValidationSupport.class, (String)string, (Object[])stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShellValidationStatus {
        private final List<String> errors = new ArrayList<String>();
        private final List<String> warnings = new ArrayList<String>();
        private final Shell shell;

        private ShellValidationStatus(Shell shell, List<String> list, List<String> list2) {
            if (list != null) {
                this.errors.addAll(list);
            }
            if (list2 != null) {
                this.warnings.addAll(list2);
            }
            this.shell = shell;
        }

        public boolean isValid() {
            return this.errors.isEmpty();
        }

        public List<String> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        public List<String> getWarnings() {
            return Collections.unmodifiableList(this.warnings);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }
}

