/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.Settings;
import org.openide.util.Lookup;

public final class PaletteController {
    public static final DataFlavor ITEM_DATA_FLAVOR;
    public static final String ATTR_ITEM_WIDTH = "itemWidth";
    public static final String ATTR_SHOW_ITEM_NAMES = "showItemNames";
    public static final String ATTR_ICON_SIZE = "iconSize";
    public static final String ATTR_IS_EXPANDED = "isExpanded";
    public static final String ATTR_IS_VISIBLE = "isVisible";
    public static final String ATTR_IS_READONLY = "isReadonly";
    public static final String ATTR_HELP_ID = "helpId";
    public static final String ATTR_PALETTE_DEFAULT_VISIBILITY = "paletteDefaultVisible";
    public static final String PROP_SELECTED_ITEM = "selectedItem";
    private Model model;
    private Settings settings;
    private PropertyChangeSupport support;

    private PaletteController() {
    }

    PaletteController(Model model, Settings settings) {
        this.model = model;
        this.settings = settings;
        this.support = new PropertyChangeSupport(this);
        this.model.addModelListener(new ModelListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PaletteController.PROP_SELECTED_ITEM.equals(propertyChangeEvent.getPropertyName())) {
                    Lookup lookup = null == propertyChangeEvent.getOldValue() ? Lookup.EMPTY : ((Item)propertyChangeEvent.getOldValue()).getLookup();
                    Lookup lookup2 = null == propertyChangeEvent.getNewValue() ? Lookup.EMPTY : ((Item)propertyChangeEvent.getNewValue()).getLookup();
                    PaletteController.this.support.firePropertyChange(PaletteController.PROP_SELECTED_ITEM, lookup, lookup2);
                }
            }

            public void categoriesRemoved(Category[] categoryArray) {
            }

            public void categoriesAdded(Category[] categoryArray) {
            }

            public void categoriesReordered() {
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Lookup getSelectedItem() {
        Item item = this.model.getSelectedItem();
        return null == item ? Lookup.EMPTY : item.getLookup();
    }

    public void setSelectedItem(Lookup lookup, Lookup lookup2) {
        this.model.setSelectedItem(lookup, lookup2);
    }

    public Lookup getSelectedCategory() {
        Category category = this.model.getSelectedCategory();
        return null == category ? Lookup.EMPTY : category.getLookup();
    }

    public void clearSelection() {
        this.model.clearSelection();
    }

    public void refresh() {
        this.model.refresh();
    }

    public void showCustomizer() {
        this.model.showCustomizer(this, this.settings);
    }

    public Lookup getRoot() {
        return this.model.getRoot();
    }

    Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    Settings getSettings() {
        return this.settings;
    }

    static {
        try {
            ITEM_DATA_FLAVOR = new DataFlavor("application/x-java-openide-paletteitem;class=org.openide.util.Lookup", "Paste Item", Lookup.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }
}

