/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.netbeans.modules.debugger.jpda.ui.SwitcherTable;
import org.netbeans.modules.debugger.jpda.ui.SwitcherTableItem;
import org.openide.util.Utilities;

final class ButtonPopupSwitcher
implements MouseInputListener,
AWTEventListener {
    private static Popup popup;
    private Component invokingComponent = null;
    private long invocationTime = -1L;
    private static boolean shown;
    private SwitcherTable pTable;
    private int x;
    private int y;

    public static void selectItem(JComponent jComponent, SwitcherTableItem[] switcherTableItemArray, int n, int n2) {
        ButtonPopupSwitcher buttonPopupSwitcher = new ButtonPopupSwitcher(jComponent, switcherTableItemArray, n, n2);
        buttonPopupSwitcher.doSelect(jComponent);
    }

    private ButtonPopupSwitcher(JComponent jComponent, SwitcherTableItem[] switcherTableItemArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = jComponent.getWidth();
        int n8 = jComponent.getHeight();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        int n9 = n2 == 0 ? 10 : 5;
        int n10 = 0;
        int n11 = n - rectangle.x;
        int n12 = rectangle.x + rectangle.width - n;
        if (n11 < n12 / 2) {
            n6 = 1;
            n5 = n + 1;
        } else {
            n6 = -1;
            n5 = n + n7;
        }
        int n13 = n2 - rectangle.y;
        int n14 = rectangle.y + rectangle.height - n2;
        if (n14 < n13 / 4) {
            n4 = -1;
            n10 = n13 - n9;
            n3 = n2;
        } else {
            n4 = 1;
            n3 = n2 + n8;
            n10 = rectangle.height - n3 - n9;
        }
        this.pTable = new SwitcherTable(switcherTableItemArray, n10);
        this.x = n5 - (n6 == -1 ? (int)this.pTable.getPreferredSize().getWidth() : 0);
        this.y = n3 - (n4 == -1 ? (int)this.pTable.getPreferredSize().getHeight() : 0);
    }

    private void doSelect(JComponent jComponent) {
        this.invokingComponent = jComponent;
        this.invokingComponent.addMouseListener(this);
        this.invokingComponent.addMouseMotionListener(this);
        this.pTable.addMouseListener(this);
        this.pTable.addMouseMotionListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        popup = PopupFactory.getSharedInstance().getPopup(this.invokingComponent, this.pTable, this.x, this.y);
        popup.show();
        shown = true;
        this.invocationTime = System.currentTimeMillis();
    }

    public static boolean isShown() {
        return shown;
    }

    private synchronized void hideCurrentPopup() {
        this.pTable.removeMouseListener(this);
        this.pTable.removeMouseMotionListener(this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.invokingComponent != null) {
            this.invokingComponent.removeMouseListener(this);
            this.invokingComponent.removeMouseMotionListener(this);
            this.invokingComponent = null;
        }
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
            popup = null;
            shown = false;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getSource() != this) {
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        }
        if (this.pTable.contains(point)) {
            int n = this.pTable.rowAtPoint(point);
            int n2 = this.pTable.columnAtPoint(point);
            this.pTable.changeSelection(n, n2, false, false);
        } else {
            this.pTable.clearSelection();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        SwitcherTableItem switcherTableItem;
        mouseEvent.consume();
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        if (this.pTable.contains(point) && (switcherTableItem = this.pTable.getSelectedItem()) != null) {
            switcherTableItem.activate();
            this.hideCurrentPopup();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        long l;
        if (mouseEvent.getSource() == this.invokingComponent && (l = System.currentTimeMillis()) - this.invocationTime > 500L) {
            this.mousePressed(mouseEvent);
        }
        mouseEvent.consume();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        mouseEvent.consume();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.pTable.clearSelection();
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
        mouseEvent.consume();
    }

    private boolean onSwitcherTable(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (!(mouseEvent.getSource() instanceof Component)) {
            return false;
        }
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        return this.pTable.contains(point);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() == this) {
            return;
        }
        if (aWTEvent instanceof MouseEvent) {
            if (aWTEvent.getID() == 502) {
                long l = System.currentTimeMillis();
                if (l - this.invocationTime > 500L && !this.onSwitcherTable((MouseEvent)aWTEvent)) {
                    this.hideCurrentPopup();
                }
            } else if (aWTEvent.getID() == 501 && !this.onSwitcherTable((MouseEvent)aWTEvent) && aWTEvent.getSource() != this.invokingComponent) {
                this.hideCurrentPopup();
            }
        } else if (aWTEvent instanceof KeyEvent && aWTEvent.getID() == 401) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.hideCurrentPopup();
        }
    }

    private class PopupHider
    implements Runnable {
        private Popup toHide;

        public PopupHider(Popup popup) {
            this.toHide = popup;
        }

        public void run() {
            this.toHide.hide();
            this.toHide = null;
        }
    }
}

