/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.hyperlink;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.GsfHtmlFormatter;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.core.UiUtils;
import org.netbeans.modules.csl.editor.hyperlink.DeclarationPopup;
import org.netbeans.modules.csl.editor.hyperlink.PopupUtil;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoToSupport {
    private static final Logger LOG = Logger.getLogger(GoToSupport.class.getName());
    static final boolean IM_FEELING_LUCKY = Boolean.getBoolean("gsf.im_feeling_lucky");

    private GoToSupport() {
    }

    public static String getGoToElementTooltip(Document document, int n) {
        return GoToSupport.perform(document, n, true, new AtomicBoolean());
    }

    public static void performGoTo(final Document document, final int n) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        String string = NbBundle.getMessage(GoToSupport.class, (String)"NM_GoToDeclaration");
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            public void run() {
                GoToSupport.perform(document, n, false, atomicBoolean);
            }
        }, (String)string, (AtomicBoolean)atomicBoolean, (boolean)false);
    }

    private static String perform(final Document document, final int n, final boolean bl, final AtomicBoolean atomicBoolean) {
        if (bl && PopupUtil.isPopupShowing()) {
            return null;
        }
        FileObject fileObject = GoToSupport.getFileObject(document);
        if (fileObject == null) {
            return null;
        }
        Source source = Source.create((FileObject)fileObject);
        if (source == null) {
            return null;
        }
        final String[] stringArray = new String[]{null};
        final DeclarationFinder.DeclarationLocation[] declarationLocationArray = new DeclarationFinder.DeclarationLocation[]{null};
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    if (atomicBoolean.get()) {
                        return;
                    }
                    Parser.Result result = resultIterator.getParserResult(n);
                    if (!(result instanceof ParserResult)) {
                        return;
                    }
                    ParserResult parserResult = (ParserResult)result;
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(parserResult.getSnapshot().getMimeType());
                    if (language == null) {
                        return;
                    }
                    DeclarationFinder declarationFinder = language.getDeclarationFinder();
                    if (declarationFinder == null) {
                        return;
                    }
                    GoToSupport.getIdentifierSpan(document, n);
                    declarationLocationArray[0] = declarationFinder.findDeclaration(parserResult, n);
                    if (atomicBoolean.get()) {
                        return;
                    }
                    if (bl) {
                        String string;
                        ElementHandle elementHandle;
                        CodeCompletionHandler codeCompletionHandler = language.getCompletionProvider();
                        if (declarationLocationArray[0] != DeclarationFinder.DeclarationLocation.NONE && codeCompletionHandler != null && (elementHandle = declarationLocationArray[0].getElement()) != null && (string = codeCompletionHandler.document(parserResult, elementHandle)) != null) {
                            stringArray[0] = "<html><body>" + string;
                        }
                    } else if (declarationLocationArray[0] != DeclarationFinder.DeclarationLocation.NONE && declarationLocationArray[0] != null) {
                        final URL uRL = declarationLocationArray[0].getUrl();
                        final String string = declarationLocationArray[0].getInvalidMessage();
                        if (uRL != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                                }
                            });
                        } else if (string != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    StatusDisplayer.getDefault().setStatusText(string);
                                    Toolkit.getDefaultToolkit().beep();
                                }
                            });
                        } else if (!IM_FEELING_LUCKY && declarationLocationArray[0].getAlternativeLocations().size() > 0 && !PopupUtil.isPopupShowing()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (!GoToSupport.chooseAlternatives(document, n, declarationLocationArray[0].getAlternativeLocations())) {
                                        GoToSupport.openLocation(declarationLocationArray[0]);
                                    }
                                }
                            });
                        } else {
                            GoToSupport.openLocation(declarationLocationArray[0]);
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        });
                    }
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
        }
        return stringArray[0];
    }

    private static void openLocation(DeclarationFinder.DeclarationLocation declarationLocation) {
        FileObject fileObject = declarationLocation.getFileObject();
        int n = declarationLocation.getOffset();
        if (fileObject != null && fileObject.isValid()) {
            UiUtils.open(fileObject, n);
        }
    }

    private static JTextComponent findEditor(Document document) {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent.getDocument() == document) {
            return jTextComponent;
        }
        List list = EditorRegistry.componentList();
        for (JTextComponent jTextComponent2 : list) {
            if (jTextComponent.getDocument() != document) continue;
            return jTextComponent;
        }
        return null;
    }

    private static boolean chooseAlternatives(Document document, int n, List<DeclarationFinder.AlternativeLocation> list) {
        Object object;
        Collections.sort(list);
        int n2 = 30;
        String string = "";
        GsfHtmlFormatter gsfHtmlFormatter = new GsfHtmlFormatter();
        int n3 = 0;
        ArrayList<DeclarationFinder.AlternativeLocation> arrayList = new ArrayList<DeclarationFinder.AlternativeLocation>(list.size());
        for (DeclarationFinder.AlternativeLocation object2 : list) {
            object = object2.getDisplayHtml(gsfHtmlFormatter);
            if (((String)object).equals(string)) continue;
            arrayList.add(object2);
            string = object;
            if (++n3 != n2) continue;
            break;
        }
        if ((list = arrayList).size() <= 1) {
            return false;
        }
        JTextComponent jTextComponent = GoToSupport.findEditor(document);
        if (jTextComponent != null) {
            try {
                Rectangle badLocationException = jTextComponent.modelToView(n);
                object = new Point(badLocationException.x, badLocationException.y + badLocationException.height);
                SwingUtilities.convertPointToScreen((Point)object, jTextComponent);
                String string2 = NbBundle.getMessage(GoToSupport.class, (String)"ChooseDecl");
                PopupUtil.showPopup(new DeclarationPopup(string2, list), string2, ((Point)object).x, ((Point)object).y, true, 0);
                return true;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    private static FileObject getFileObject(Document document) {
        return DataLoadersBridge.getDefault().getFileObject(document);
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        return GoToSupport.getIdentifierSpan(document, n);
    }

    public static int[] getIdentifierSpan(Document document, int n) {
        FileObject fileObject = GoToSupport.getFileObject(document);
        if (fileObject == null) {
            return null;
        }
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)document, n);
        Language language = null;
        for (Language object2 : list) {
            if (object2.getDeclarationFinder() == null) continue;
            language = object2;
            break;
        }
        if (language == null) {
            return null;
        }
        DeclarationFinder declarationFinder = language.getDeclarationFinder();
        assert (declarationFinder != null);
        OffsetRange offsetRange = declarationFinder.getReferenceSpan(document, n);
        if (offsetRange == null) {
            throw new NullPointerException(declarationFinder + " violates its contract; should not return null from getReferenceSpan.");
        }
        if (offsetRange != OffsetRange.NONE) {
            return new int[]{offsetRange.getStart(), offsetRange.getEnd()};
        }
        return null;
    }
}

