/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.ui.copy.CreateCopyPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateCopy
extends CopyDialog
implements DocumentListener,
FocusListener,
ActionListener,
PropertyChangeListener {
    private final RepositoryPaths copyToRepositoryPaths;
    private final RepositoryPaths copyFromRepositoryPaths;
    private final File localeFile;
    private final RepositoryFile repositoryFile;
    private final boolean localChanges;

    public CreateCopy(RepositoryFile repositoryFile, File file, boolean bl) {
        super(new CreateCopyPanel(), NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyDialog_Prompt", (Object)file.getName()), NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyDialog_Title"));
        this.localeFile = file;
        this.repositoryFile = repositoryFile;
        this.localChanges = bl;
        CreateCopyPanel createCopyPanel = this.getCreateCopyPanel();
        createCopyPanel.localRadioButton.addActionListener(this);
        createCopyPanel.remoteRadioButton.addActionListener(this);
        createCopyPanel.skipCheckBox.addActionListener(this);
        createCopyPanel.copyFromLocalTextField.setText(file.getAbsolutePath());
        createCopyPanel.copyFromRemoteTextField.setText(repositoryFile.getFileUrl().toString());
        this.copyFromRepositoryPaths = new RepositoryPaths(repositoryFile, createCopyPanel.copyFromRemoteTextField, null, createCopyPanel.copyFromRevisionTextField, createCopyPanel.searchButton);
        if (file.isFile()) {
            Mnemonics.setLocalizedText((AbstractButton)createCopyPanel.localRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromLocalFile"));
            Mnemonics.setLocalizedText((AbstractButton)createCopyPanel.remoteRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromRemoteFile"));
            createCopyPanel.skipCheckBox.setEnabled(false);
        } else {
            Mnemonics.setLocalizedText((AbstractButton)createCopyPanel.localRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromLocalFolder"));
            Mnemonics.setLocalizedText((AbstractButton)createCopyPanel.remoteRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromRemoteFolder"));
        }
        createCopyPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyDialog_Title"));
        this.copyToRepositoryPaths = new RepositoryPaths(repositoryFile, (JTextComponent)createCopyPanel.urlComboBox.getEditor().getEditorComponent(), createCopyPanel.browseRepositoryButton, null, null);
        String string = "";
        string = file.isFile() ? NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageCopyFile") : NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageCopyFolder");
        String string2 = file.isFile() ? "" : file.getName();
        int n = 2;
        this.copyToRepositoryPaths.setupBehavior(string, n, new BrowserAction[]{new CreateFolderAction(string2)}, "org.netbeans.modules.subversion.ui.browser.copy", null);
        this.copyToRepositoryPaths.addPropertyChangeListener(this);
        this.setupUrlComboBox(createCopyPanel.urlComboBox, CreateCopy.class.getName());
        createCopyPanel.messageTextArea.getDocument().addDocumentListener(this);
        ((JTextComponent)createCopyPanel.urlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.setFromLocal();
        this.validateUserInput();
    }

    protected void validateUserInput() {
        String string = this.getCreateCopyPanel().messageTextArea.getText();
        try {
            RepositoryFile[] repositoryFileArray = this.copyToRepositoryPaths.getRepositoryFiles();
            if (repositoryFileArray == null || repositoryFileArray.length == 0) {
                this.setErrorText(NbBundle.getMessage(CreateCopy.class, (String)"LBL_MISSING_REPOSITORY_FOLDER"));
                this.getOKButton().setEnabled(false);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorText(numberFormatException.getLocalizedMessage());
            this.getOKButton().setEnabled(false);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorText(malformedURLException.getLocalizedMessage());
            this.getOKButton().setEnabled(false);
            return;
        }
        if (string == null || string.length() == 0) {
            this.setErrorText(NbBundle.getMessage(CreateCopy.class, (String)"LBL_MISSING_COPY_MESSAGE"));
            this.getOKButton().setEnabled(false);
            return;
        }
        this.resetErrorText();
        this.getOKButton().setEnabled(true);
    }

    void setErrorText(String string) {
        CreateCopyPanel createCopyPanel = this.getCreateCopyPanel();
        createCopyPanel.invalidValuesLabel.setVisible(true);
        createCopyPanel.invalidValuesLabel.setText(string);
    }

    private void resetErrorText() {
        CreateCopyPanel createCopyPanel = this.getCreateCopyPanel();
        createCopyPanel.invalidValuesLabel.setVisible(false);
        createCopyPanel.invalidValuesLabel.setText("");
    }

    CreateCopyPanel getCreateCopyPanel() {
        return (CreateCopyPanel)this.getPanel();
    }

    RepositoryFile getToRepositoryFile() {
        try {
            return this.getToRepositoryFileIntern();
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, null, malformedURLException);
        }
        catch (NumberFormatException numberFormatException) {
            Subversion.LOG.log(Level.INFO, null, numberFormatException);
        }
        return null;
    }

    private RepositoryFile getToRepositoryFileIntern() throws NumberFormatException, MalformedURLException {
        RepositoryFile[] repositoryFileArray = this.copyToRepositoryPaths.getRepositoryFiles();
        if (repositoryFileArray.length > 0) {
            RepositoryFile repositoryFile = repositoryFileArray[0];
            if (this.skipContents()) {
                return repositoryFile;
            }
            if (this.isLocal()) {
                return repositoryFile.appendPath(this.localeFile.getName());
            }
            return repositoryFile.appendPath(this.repositoryFile.getFileUrl().getLastPathSegment());
        }
        return null;
    }

    String getMessage() {
        return SvnUtils.fixLineEndings(this.getCreateCopyPanel().messageTextArea.getText());
    }

    boolean isLocal() {
        return this.getCreateCopyPanel().localRadioButton.isSelected();
    }

    File getLocalFile() {
        return this.localeFile;
    }

    RepositoryFile getFromRepositoryFile() {
        try {
            return this.copyFromRepositoryPaths.getRepositoryFiles()[0];
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, null, malformedURLException);
        }
        catch (NumberFormatException numberFormatException) {
            Subversion.LOG.log(Level.INFO, null, numberFormatException);
        }
        return null;
    }

    boolean switchTo() {
        return this.getCreateCopyPanel().switchToCheckBox.isSelected();
    }

    boolean skipContents() {
        return this.getCreateCopyPanel().skipCheckBox.isSelected();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
        this.setPreview();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
        this.setPreview();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
        this.setPreview();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validateUserInput();
        this.setPreview();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.validateUserInput();
            } else {
                this.getOKButton().setEnabled(bl);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getCreateCopyPanel().localRadioButton) {
            this.setFromLocal();
            this.setPreview();
        } else if (actionEvent.getSource() == this.getCreateCopyPanel().remoteRadioButton) {
            this.selectFromRemote();
            this.setPreview();
        } else if (actionEvent.getSource() == this.getCreateCopyPanel().skipCheckBox) {
            this.setPreview();
        }
    }

    private void setFromLocal() {
        CreateCopyPanel createCopyPanel = this.getCreateCopyPanel();
        createCopyPanel.copyFromLocalTextField.setEnabled(true);
        createCopyPanel.copyFromRemoteTextField.setEnabled(false);
        createCopyPanel.copyFromRevisionTextField.setEnabled(false);
        createCopyPanel.searchButton.setEnabled(false);
        createCopyPanel.warningLabel.setVisible(this.localChanges);
    }

    private void selectFromRemote() {
        CreateCopyPanel createCopyPanel = this.getCreateCopyPanel();
        createCopyPanel.copyFromLocalTextField.setEnabled(false);
        createCopyPanel.copyFromRemoteTextField.setEnabled(true);
        createCopyPanel.copyFromRevisionTextField.setEnabled(true);
        createCopyPanel.searchButton.setEnabled(true);
        createCopyPanel.warningLabel.setVisible(false);
    }

    private void setPreview() {
        try {
            RepositoryFile repositoryFile = this.getToRepositoryFileIntern();
            if (repositoryFile != null) {
                this.getCreateCopyPanel().previewTextField.setText(repositoryFile.getFileUrl().toString());
            } else {
                this.getCreateCopyPanel().previewTextField.setText("");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.getCreateCopyPanel().previewTextField.setText("");
        }
        catch (MalformedURLException malformedURLException) {
            this.getCreateCopyPanel().previewTextField.setText("");
        }
    }
}

