/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.Util;

public abstract class TreeChild
extends TreeNode {
    public static final String PROP_PARENT_NODE = "parentNode";
    private TreeParentNode parentNode;

    protected TreeChild() {
    }

    protected TreeChild(TreeChild treeChild) {
        super(treeChild);
    }

    public final TreeDocumentRoot getOwnerDocument() {
        if (this instanceof TreeDocumentRoot) {
            return (TreeDocumentRoot)((Object)this);
        }
        if (this.getParentNode() == null) {
            return null;
        }
        return this.getParentNode().getOwnerDocument();
    }

    public final boolean isInContext() {
        return this.getParentNode() != null;
    }

    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.getParentNode().removeChild(this);
        }
    }

    public final TreeParentNode getParentNode() {
        return this.parentNode;
    }

    protected final void setParentNode(TreeParentNode treeParentNode) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeChild::setParentNode [ " + this + " ] : newParentNode = " + treeParentNode);
        }
        if (Util.equals(this.parentNode, treeParentNode)) {
            return;
        }
        TreeParentNode treeParentNode2 = this.parentNode;
        this.parentNode = treeParentNode;
        this.firePropertyChange(PROP_PARENT_NODE, treeParentNode2, treeParentNode);
    }

    public final TreeChild getPreviousSibling() {
        int n = this.index();
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        return (TreeChild)this.getParentNode().getChildNodes().get(n - 1);
    }

    public final TreeChild getNextSibling() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeChild [ " + this + " ] ::getNextSibling: parentNode = " + this.getParentNode());
        }
        int n = this.index();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    index : " + n);
        }
        if (n == -1) {
            return null;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    parentNode.childNodes.size : " + this.getParentNode().getChildNodes().size());
        }
        if (n + 1 == this.getParentNode().getChildNodes().size()) {
            return null;
        }
        return (TreeChild)this.getParentNode().getChildNodes().get(n + 1);
    }

    public final int index() {
        if (this.getParentNode() == null) {
            return -1;
        }
        return this.getParentNode().indexOf(this);
    }

    public final boolean isDescendantOf(TreeParentNode treeParentNode) {
        for (TreeParentNode treeParentNode2 = this.getParentNode(); treeParentNode2 != null; treeParentNode2 = treeParentNode2.getParentNode()) {
            if (treeParentNode2 != treeParentNode) continue;
            return true;
        }
        return false;
    }
}

