/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"StructLayout"}, parent="Object")
public final class StructLayout
extends Type {
    static final Storage nullStorage = new NullStorage();
    static final String CLASS_NAME = "StructLayout";
    private final Map<IRubyObject, Member> fieldMap;
    private final List<RubySymbol> fieldNames;
    private final List<Member> fields;
    private final int cacheableFieldCount;
    private final int[] cacheIndexMap;
    private final int referenceFieldCount;
    private final int[] referenceIndexMap;

    public static RubyClass createStructLayoutClass(Ruby runtime2, RubyModule module) {
        RubyClass layoutClass = runtime2.defineClassUnder(CLASS_NAME, module.fastGetClass("Type"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, module);
        layoutClass.defineAnnotatedMethods(StructLayout.class);
        layoutClass.defineAnnotatedConstants(StructLayout.class);
        RubyClass arrayClass = runtime2.defineClassUnder("Array", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        arrayClass.includeModule(runtime2.getEnumerable());
        arrayClass.defineAnnotatedMethods(Array.class);
        RubyClass fieldClass = runtime2.defineClassUnder("Field", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        fieldClass.defineAnnotatedMethods(Member.class);
        return layoutClass;
    }

    StructLayout(Ruby runtime2, Collection<RubySymbol> fieldNames, Map<IRubyObject, Member> fields2, int size2, int minAlign) {
        super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME), NativeType.STRUCT, size2, minAlign);
        this.fieldMap = StructLayout.immutableMap(fields2);
        this.cacheIndexMap = new int[fieldNames.size()];
        this.referenceIndexMap = new int[fieldNames.size()];
        int cfCount = 0;
        int refCount = 0;
        ArrayList<Member> fieldList = new ArrayList<Member>(fieldNames.size());
        for (RubySymbol fieldName : fieldNames) {
            Member m = fields2.get(fieldName);
            fieldList.add(m);
            this.cacheIndexMap[m.index] = m.isCacheable() ? cfCount++ : -1;
            if (m.isValueReferenceNeeded()) {
                this.referenceIndexMap[m.index] = refCount++;
                continue;
            }
            this.referenceIndexMap[m.index] = -1;
        }
        this.cacheableFieldCount = cfCount;
        this.referenceFieldCount = refCount;
        this.fieldNames = Collections.unmodifiableList(new ArrayList<RubySymbol>(fieldNames));
        this.fields = Collections.unmodifiableList(fieldList);
    }

    private static Map<IRubyObject, Member> immutableMap(Map<IRubyObject, Member> fields2) {
        return Collections.unmodifiableMap(new LinkedHashMap<IRubyObject, Member>(fields2));
    }

    @JRubyMethod(name={"get"}, required=2)
    public IRubyObject get(ThreadContext context, IRubyObject ptr, IRubyObject name2) {
        return this.getMember(context.getRuntime(), name2).get(context.getRuntime(), nullStorage, ptr);
    }

    @JRubyMethod(name={"put"}, required=3)
    public IRubyObject put(ThreadContext context, IRubyObject ptr, IRubyObject name2, IRubyObject value2) {
        this.getMember(context.getRuntime(), name2).put(context.getRuntime(), nullStorage, ptr, value2);
        return value2;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        RubyArray members2 = RubyArray.newArray(context.getRuntime());
        for (RubySymbol name2 : this.fieldNames) {
            members2.append(name2);
        }
        return members2;
    }

    @JRubyMethod(name={"offsets"})
    public IRubyObject offsets(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray offsets2 = RubyArray.newArray(runtime2);
        for (RubySymbol name2 : this.fieldNames) {
            RubyArray offset2 = RubyArray.newArray(runtime2);
            offset2.append(name2);
            offset2.append(runtime2.newFixnum(this.fieldMap.get((Object)name2).offset));
            offsets2.append(offset2);
        }
        return offsets2;
    }

    @Override
    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.getNativeSize());
    }

    @Override
    @JRubyMethod(name={"alignment"})
    public IRubyObject alignment(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.getNativeAlignment());
    }

    @JRubyMethod(name={"offset_of"})
    public IRubyObject offset_of(ThreadContext context, IRubyObject fieldName) {
        Member member = this.getMember(context.getRuntime(), fieldName);
        return RubyFixnum.newFixnum(context.getRuntime(), member.offset);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(ThreadContext context, IRubyObject fieldName) {
        return this.getMember(context.getRuntime(), fieldName);
    }

    @JRubyMethod
    public IRubyObject fields(ThreadContext context) {
        return RubyArray.newArray(context.getRuntime(), this.fields);
    }

    final Member getMember(Ruby runtime2, IRubyObject name2) {
        Member f = this.fieldMap.get(name2);
        if (f != null) {
            return f;
        }
        throw runtime2.newArgumentError("Unknown field: " + name2);
    }

    public final int getMinimumAlignment() {
        return this.getNativeAlignment();
    }

    public final int getSize() {
        return this.getNativeSize();
    }

    final int getReferenceFieldCount() {
        return this.referenceFieldCount;
    }

    final int getReferenceFieldIndex(Member member) {
        return this.referenceIndexMap[member.index];
    }

    final int getCacheableFieldCount() {
        return this.cacheableFieldCount;
    }

    final int getCacheableFieldIndex(Member member) {
        return this.cacheIndexMap[member.index];
    }

    public final int getFieldCount() {
        return this.fields.size();
    }

    public final Collection<Member> getFields() {
        return this.fields;
    }

    @JRubyClass(name={"FFI::StructLayout::Array"}, parent="Object")
    public static final class Array
    extends RubyObject {
        private final AbstractMemory ptr;
        private final MemoryOp aio;
        private final long offset;
        private final Type.Array arrayType;

        Array(Ruby runtime2, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Array"));
            this.ptr = (AbstractMemory)ptr;
            this.offset = offset2;
            this.arrayType = type2;
            this.aio = aio;
        }

        private final long getOffset(IRubyObject index2) {
            return this.offset + Util.uint32Value(index2) * (long)this.arrayType.getComponentType().getNativeSize();
        }

        private final long getOffset(int index2) {
            return this.offset + (long)(index2 * this.arrayType.getComponentType().getNativeSize());
        }

        private IRubyObject get(Ruby runtime2, int index2) {
            return this.aio.get(runtime2, this.ptr.getMemoryIO(), this.getOffset(index2));
        }

        @JRubyMethod(name={"[]"})
        public IRubyObject get(ThreadContext context, IRubyObject index2) {
            return this.aio.get(context.getRuntime(), this.ptr.getMemoryIO(), this.getOffset(index2));
        }

        @JRubyMethod(name={"[]="})
        public IRubyObject put(ThreadContext context, IRubyObject index2, IRubyObject value2) {
            this.aio.put(context.getRuntime(), this.ptr.getMemoryIO(), this.getOffset(index2), value2);
            return value2;
        }

        @JRubyMethod(name={"to_a", "to_ary"})
        public IRubyObject get(ThreadContext context) {
            Ruby runtime2 = context.getRuntime();
            IRubyObject[] elems = new IRubyObject[this.arrayType.length()];
            for (int i = 0; i < elems.length; ++i) {
                elems[i] = this.get(runtime2, i);
            }
            return RubyArray.newArrayNoCopy(runtime2, elems);
        }

        @JRubyMethod(name={"to_ptr"})
        public IRubyObject to_ptr(ThreadContext context) {
            return this.ptr.slice(context.getRuntime(), this.offset);
        }

        @JRubyMethod(name={"size"})
        public IRubyObject size(ThreadContext context) {
            return context.getRuntime().newFixnum(this.arrayType.getNativeSize());
        }

        @JRubyMethod(name={"each"}, frame=true)
        public IRubyObject each(ThreadContext context, Block block) {
            if (!block.isGiven()) {
                throw context.getRuntime().newLocalJumpErrorNoBlock();
            }
            for (int i = 0; i < this.arrayType.length(); ++i) {
                block.yield(context, this.get(context.getRuntime(), i));
            }
            return this;
        }
    }

    static class NullStorage
    implements Storage {
        NullStorage() {
        }

        public IRubyObject getCachedValue(Member member) {
            return null;
        }

        public void putCachedValue(Member member, IRubyObject value2) {
        }

        public void putReference(Member member, IRubyObject value2) {
        }
    }

    public static interface Storage {
        public IRubyObject getCachedValue(Member var1);

        public void putCachedValue(Member var1, IRubyObject var2);

        public void putReference(Member var1, IRubyObject var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Aggregate {
        public Collection<Member> getMembers();
    }

    @JRubyClass(name={"FFI::StructLayout::Field"}, parent="Object")
    public static abstract class Member
    extends RubyObject {
        protected final IRubyObject name;
        protected final Type type;
        protected final long offset;
        protected final int index;

        protected Member(IRubyObject name2, Type type2, int index2, long offset2) {
            super(type2.getRuntime(), type2.getRuntime().fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Field"));
            this.name = name2;
            this.type = type2;
            this.index = index2;
            this.offset = offset2;
        }

        static final MemoryIO getMemoryIO(IRubyObject ptr) {
            return ((AbstractMemory)ptr).getMemoryIO();
        }

        final long getOffset(IRubyObject ptr) {
            return this.offset;
        }

        final int getIndex() {
            return this.index;
        }

        public final NativeType getNativeType() {
            return this.type.getNativeType();
        }

        public boolean equals(Object obj) {
            return obj instanceof Member && ((Member)obj).offset == this.offset;
        }

        public int hashCode() {
            return 265 + (int)(this.offset ^ this.offset >>> 32);
        }

        public abstract void put(Ruby var1, Storage var2, IRubyObject var3, IRubyObject var4);

        public abstract IRubyObject get(Ruby var1, Storage var2, IRubyObject var3);

        protected boolean isCacheable() {
            return false;
        }

        protected boolean isValueReferenceNeeded() {
            return false;
        }

        @JRubyMethod
        public IRubyObject size(ThreadContext context) {
            return context.getRuntime().newFixnum(this.type.getNativeSize());
        }

        @JRubyMethod
        public IRubyObject alignment(ThreadContext context) {
            return context.getRuntime().newFixnum(this.type.getNativeAlignment());
        }

        @JRubyMethod
        public IRubyObject offset(ThreadContext context) {
            return context.getRuntime().newFixnum(this.offset);
        }

        @JRubyMethod(name={"type", "ffi_type"})
        public IRubyObject ffi_type(ThreadContext context) {
            return this.type;
        }
    }
}

