/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.versioning.util.VCSNotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public abstract class VCSKenaiSupport {
    public static final String PROP_KENAI_VCS_NOTIFICATION = "kenai.vcs.notification";
    protected static Logger LOG = Logger.getLogger("org.netbeans.modules.versioning.util.VCSKenaiSupport");

    public abstract PasswordAuthentication getPasswordAuthentication();

    public abstract PasswordAuthentication getPasswordAuthentication(boolean var1);

    public abstract boolean isKenai(String var1);

    public abstract boolean showLogin();

    public abstract void setFirmAssociations(File[] var1, String var2);

    public abstract boolean isLogged();

    public abstract KenaiUser forName(String var1);

    public abstract boolean isUserOnline(String var1);

    public abstract void addVCSNoficationListener(PropertyChangeListener var1);

    public abstract void removeVCSNoficationListener(PropertyChangeListener var1);

    public abstract String getRevisionUrl(String var1, String var2);

    public abstract void logVcsUsage(String var1, String var2);

    public static abstract class KenaiNotificationListener
    extends VCSNotificationDisplayer
    implements PropertyChangeListener {
        protected static Logger LOG = LOG;
        private RequestProcessor rp = new RequestProcessor("Kenai VCS notifications");

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(VCSKenaiSupport.PROP_KENAI_VCS_NOTIFICATION)) {
                final VCSKenaiNotification vCSKenaiNotification = (VCSKenaiNotification)propertyChangeEvent.getNewValue();
                this.rp.post(new Runnable(){

                    public void run() {
                        KenaiNotificationListener.this.handleVCSNotification(vCSKenaiNotification);
                    }
                });
            }
        }

        protected abstract void handleVCSNotification(VCSKenaiNotification var1);
    }

    public static abstract class VCSKenaiModification {
        public abstract Type getType();

        public abstract String getResource();

        public abstract String getId();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            NEW,
            CHANGE,
            DELETE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class VCSKenaiNotification {
        public abstract URI getUri();

        public abstract Date getStamp();

        public abstract Service getService();

        public abstract List<VCSKenaiModification> getModifications();

        public abstract String getAuthor();

        public abstract File getProjectDirectory();
    }

    public static abstract class KenaiUser {
        public abstract boolean isOnline();

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);

        public abstract Icon getIcon();

        public abstract JLabel createUserWidget();

        public abstract String getUser();

        public abstract void startChat();

        public abstract void startChat(String var1);

        public static String getChatLink(Document document, int n) {
            Project project;
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string = "";
            string = classPath != null ? classPath.getResourceName(fileObject) : ((project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null ? "{$" + ProjectUtils.getInformation((Project)project).getName() + "}/" + FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fileObject) : fileObject.getPath());
            string = string + ":" + n;
            string = "FILE:" + string;
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Service {
        VCS_SVN,
        VCS_HG,
        UNKNOWN;

    }
}

