/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchExecutor;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SearchHistoryTopComponent
extends TopComponent
implements DiffSetupSource {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;

    public SearchHistoryTopComponent() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
    }

    public SearchHistoryTopComponent(File[] fileArray) {
        this(fileArray, null, null, null, null);
    }

    public SearchHistoryTopComponent(File[] fileArray, String string, String string2, Date date, Date date2) {
        this();
        this.initComponents(fileArray, string, string2, date, date2);
    }

    SearchHistoryTopComponent(File file, DiffResultsViewFactory diffResultsViewFactory) {
        this();
        this.initComponents(new File[]{file}, null, null, null, null);
        this.shp.setDiffResultsViewFactory(diffResultsViewFactory);
        this.shp.disableFileChangesOption(false);
    }

    public void search() {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(false);
    }

    public void searchOut() {
        this.shp.setOutSearch();
        this.scp.setTo("");
    }

    public void searchIncoming() {
        this.shp.setIncomingSearch();
        this.scp.setTo("");
    }

    private void initComponents(File[] fileArray, String string, String string2, Date date, Date date2) {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel();
        this.scp.setCommitMessage(string);
        this.scp.setUsername(string2);
        if (date != null) {
            this.scp.setFrom(SearchExecutor.simpleDateFormat.format(date));
        }
        if (date2 != null) {
            this.scp.setTo(SearchExecutor.simpleDateFormat.format(date2));
        }
        this.shp = new SearchHistoryPanel(fileArray, this.scp);
        this.add(this.shp);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected String preferredID() {
        if (this.shp.isIncomingSearch()) {
            return "Hg.IncomingSearchHistoryTopComponent";
        }
        if (this.shp.isOutSearch()) {
            return "Hg.OutSearchHistoryTopComponent";
        }
        return "Hg.SearchHistoryTopComponent";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public Collection getSetups() {
        return this.shp.getSetups();
    }

    public String getSetupDisplayName() {
        return this.getDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiffResultsViewFactory {
        DiffResultsView createDiffResultsView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
            return new DiffResultsView(searchHistoryPanel, list);
        }
    }
}

