/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.XsdBasedValidator;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLInlineSchemaValidator
extends XsdBasedValidator {
    public static final ValidationResult EMPTY_RESULT = new ValidationResult((Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET);
    Pattern pattern = Pattern.compile("(<\\s*)(\\S*schema)(\\s*)");

    public String getName() {
        return "WSDLInlineSchemaValidator";
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        if (model instanceof WSDLModel) {
            WSDLModel wSDLModel = (WSDLModel)model;
            ArrayList<Model> arrayList = new ArrayList<Model>();
            Vector vector = new Vector();
            if (validationType.equals((Object)Validation.ValidationType.COMPLETE) || validationType.equals((Object)Validation.ValidationType.PARTIAL)) {
                if (wSDLModel.getState() == Model.State.NOT_WELL_FORMED) {
                    return EMPTY_RESULT;
                }
                Definitions definitions = wSDLModel.getDefinitions();
                Map map = ((AbstractDocumentComponent)definitions).getPrefixes();
                String string = this.getSystemId(wSDLModel);
                Types types = definitions.getTypes();
                if (types != null) {
                    List<WSDLSchema> list = types.getExtensibilityElements(WSDLSchema.class);
                    String string2 = this.getWSDLText(wSDLModel);
                    assert (string2 != null) : "there is no content in the wsdl document or couldnt be read";
                    List<Integer> list2 = this.setupLinePositions(string2);
                    WSDLLSResourceResolver wSDLLSResourceResolver = new WSDLLSResourceResolver(wSDLModel, string, string2, map, list2);
                    for (WSDLSchema wSDLSchema : list) {
                        Reader reader = this.createInlineSchemaSource(string2, map, list2, wSDLSchema);
                        if (reader == null) continue;
                        SAXSource sAXSource = new SAXSource(new InputSource(reader));
                        sAXSource.setSystemId(string);
                        int n = wSDLSchema.findPosition();
                        int n2 = this.getLineNumber(n, list2);
                        InlineSchemaValidatorHandler inlineSchemaValidatorHandler = new InlineSchemaValidatorHandler((Model)wSDLModel, n2);
                        this.validate(wSDLModel, sAXSource, inlineSchemaValidatorHandler, wSDLLSResourceResolver);
                        vector.addAll(inlineSchemaValidatorHandler.getResultItems());
                    }
                    arrayList.add(model);
                    return new ValidationResult(vector, arrayList);
                }
            }
        }
        return null;
    }

    private String getSystemId(WSDLModel wSDLModel) {
        File file = (File)wSDLModel.getModelSource().getLookup().lookup(File.class);
        if (file != null) {
            return file.toURI().toString();
        }
        Source source = (Source)wSDLModel.getModelSource().getLookup().lookup(Source.class);
        if (source != null) {
            return source.getSystemId();
        }
        return null;
    }

    private void validate(WSDLModel wSDLModel, Source source, XsdBasedValidator.Handler handler, LSResourceResolver lSResourceResolver) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (lSResourceResolver != null) {
                schemaFactory.setResourceResolver(lSResourceResolver);
            }
            schemaFactory.setErrorHandler((ErrorHandler)handler);
            if (source == null) {
                return;
            }
            schemaFactory.newSchema(source);
        }
        catch (SAXException sAXException) {
        }
        catch (Exception exception) {
            handler.logValidationErrors(Validator.ResultType.ERROR, exception.getMessage());
        }
    }

    private String getEndTag(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.find()) {
            return "</" + matcher.group(2) + ">";
        }
        return null;
    }

    private List<Integer> setupLinePositions(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = string.split("\n");
        arrayList.add(-1);
        int n = 0;
        for (String string2 : stringArray) {
            arrayList.add(n);
            n += string2.length() + 1;
        }
        return arrayList;
    }

    private int getLineNumber(int n, List<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (n >= list.get(i)) continue;
            return i - 1;
        }
        return -1;
    }

    protected javax.xml.validation.Schema getSchema(Model model) {
        return null;
    }

    private String getWSDLText(WSDLModel wSDLModel) {
        Document document = (Document)wSDLModel.getModelSource().getLookup().lookup(Document.class);
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "getWSDLText", badLocationException);
            return null;
        }
    }

    public DocumentModel resolveResource(String string, Model model) {
        if (model instanceof WSDLModel && string.equals(this.getSystemId((WSDLModel)model))) {
            return (WSDLModel)model;
        }
        try {
            CatalogModel catalogModel = (CatalogModel)model.getModelSource().getLookup().lookup(CatalogModel.class);
            ModelSource modelSource = catalogModel.getModelSource(new URI(string));
            if (modelSource != null) {
                return SchemaModelFactory.getDefault().getModel(modelSource);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", uRISyntaxException);
        }
        catch (CatalogModelException catalogModelException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", catalogModelException);
        }
        return null;
    }

    private Reader createInlineSchemaSource(String string, Map<String, String> map, List<Integer> list, WSDLSchema wSDLSchema) {
        StringReader stringReader = null;
        int n = wSDLSchema.findPosition();
        int n2 = this.getLineNumber(n, list);
        String string2 = wSDLSchema.getContentFragment();
        if (string == null || string2 == null) {
            return null;
        }
        int n3 = string.indexOf(string2, n);
        if (string2 != null && string2.trim().length() > 0) {
            assert (n3 != -1) : "the text content under schema couldnt be found in the wsdl document";
            String string3 = string.substring(n, n3);
            String[] stringArray = string3.split(">");
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray.length > 0) {
                stringBuffer.append(stringArray[0]);
                Map map2 = ((AbstractDocumentComponent)wSDLSchema.getSchemaModel().getSchema()).getPrefixes();
                for (String string4 : map.keySet()) {
                    if (string4 == null || string4.length() == 0 || map2.containsKey(string4)) continue;
                    stringBuffer.append(" ").append("xmlns:").append(string4).append("=\"").append(map.get(string4)).append("\"");
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuffer.append(">").append(stringArray[i]);
                }
                stringBuffer.append(">");
                stringBuffer.append(string2).append(this.getEndTag(stringArray[0]));
                string2 = null;
                stringArray = null;
                string3 = null;
            }
            stringReader = new StringReader(stringBuffer.toString());
            stringBuffer = null;
        }
        return stringReader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WSDLLSResourceResolver
    implements LSResourceResolver {
        private WSDLModel mModel;
        private LSResourceResolver mDelegate;
        private String mWsdlSystemId;
        private String mWsdlText;
        private Map<String, String> mWsdlPrefixes;
        private List<Integer> mWsdlLinePositions;

        public WSDLLSResourceResolver(WSDLModel wSDLModel, String string, String string2, Map<String, String> map, List<Integer> list) {
            this.mModel = wSDLModel;
            this.mWsdlSystemId = string;
            this.mWsdlText = string2;
            this.mWsdlPrefixes = map;
            this.mWsdlLinePositions = list;
            this.mDelegate = CatalogModelFactory.getDefault().getLSResourceResolver();
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            Reader reader;
            WSDLSchema wSDLSchema;
            LSInput lSInput = this.mDelegate.resolveResource(string, string2, string3, string4, string5);
            if (lSInput == null && (wSDLSchema = this.findSchema(string2)) != null && (reader = WSDLInlineSchemaValidator.this.createInlineSchemaSource(this.mWsdlText, this.mWsdlPrefixes, this.mWsdlLinePositions, wSDLSchema)) != null) {
                DOMImplementation dOMImplementation = null;
                try {
                    dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "resolveResource", parserConfigurationException);
                    return null;
                }
                DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
                lSInput = dOMImplementationLS.createLSInput();
                lSInput.setCharacterStream(reader);
                if (this.mWsdlSystemId != null) {
                    lSInput.setSystemId(this.mWsdlSystemId);
                }
                return lSInput;
            }
            return lSInput;
        }

        private WSDLSchema findSchema(String string) {
            WSDLSchema wSDLSchema = null;
            Definitions definitions = this.mModel.getDefinitions();
            Types types = definitions.getTypes();
            if (types != null) {
                List<WSDLSchema> list = types.getExtensibilityElements(WSDLSchema.class);
                for (WSDLSchema wSDLSchema2 : list) {
                    Schema schema;
                    SchemaModel schemaModel = wSDLSchema2.getSchemaModel();
                    if (schemaModel == null || (schema = schemaModel.getSchema()) == null || schema.getTargetNamespace() == null || !schema.getTargetNamespace().equals(string)) continue;
                    wSDLSchema = wSDLSchema2;
                    break;
                }
            }
            return wSDLSchema;
        }
    }

    class InlineSchemaValidatorHandler
    extends XsdBasedValidator.Handler {
        int startingLineNumber;

        public InlineSchemaValidatorHandler(Model model, int n) {
            super((XsdBasedValidator)WSDLInlineSchemaValidator.this, model);
            this.startingLineNumber = n - 1;
        }

        public void logValidationErrors(Validator.ResultType resultType, String string, int n, int n2) {
            super.logValidationErrors(resultType, string, this.startingLineNumber + n, n2);
        }
    }
}

