/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.ruby.lexer.RubyStringTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyStringLexer
implements Lexer<RubyStringTokenId> {
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<RubyStringTokenId> tokenFactory;
    private final boolean substituting;

    public RubyStringLexer(LexerRestartInfo<RubyStringTokenId> lexerRestartInfo, boolean bl) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        this.substituting = bl;
        assert (lexerRestartInfo.state() == null);
    }

    public Object state() {
        return null;
    }

    public Token<RubyStringTokenId> nextToken() {
        return this.substituting ? this.nextTokenDoubleQuotes() : this.nextTokenSingleQuotes();
    }

    public Token<RubyStringTokenId> nextTokenSingleQuotes() {
        while (true) {
            int n = this.input.read();
            switch (n) {
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(RubyStringTokenId.STRING_TEXT);
                    }
                    return null;
                }
                case 92: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)RubyStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    n = this.input.read();
                    switch (n) {
                        case 39: 
                        case 92: {
                            return this.token(RubyStringTokenId.STRING_ESCAPE);
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return this.token(RubyStringTokenId.STRING_TEXT);
                        }
                    }
                    return this.token(RubyStringTokenId.STRING_INVALID);
                }
            }
        }
    }

    public Token<RubyStringTokenId> nextTokenDoubleQuotes() {
        while (true) {
            int n = this.input.read();
            block0 : switch (n) {
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(RubyStringTokenId.STRING_TEXT);
                    }
                    return null;
                }
                case 35: {
                    int n2;
                    int n3 = this.input.read();
                    if (n3 != 123) break;
                    if (this.input.readLength() > 2) {
                        this.input.backup(2);
                        return this.tokenFactory.createToken((TokenId)RubyStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    while ((n2 = this.input.read()) != -1 && n2 != 125) {
                    }
                    return this.token(RubyStringTokenId.EMBEDDED_RUBY);
                }
                case 92: {
                    int n2;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)RubyStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    n = this.input.read();
                    switch (n) {
                        case 120: {
                            if (RubyStringLexer.isHexDigit(this.input.read())) {
                                if (RubyStringLexer.isHexDigit(this.input.read())) {
                                    return this.token(RubyStringTokenId.STRING_ESCAPE);
                                }
                                this.input.backup(2);
                                break block0;
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            switch (this.input.read()) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    switch (this.input.read()) {
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: {
                                            return this.token(RubyStringTokenId.STRING_ESCAPE);
                                        }
                                    }
                                    this.input.backup(1);
                                    break;
                                }
                                default: {
                                    this.input.backup(1);
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 99: {
                            n2 = this.input.read();
                            if (n2 == 120) {
                                return this.token(RubyStringTokenId.STRING_ESCAPE);
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        case 67: {
                            n2 = this.input.read();
                            if (n2 == 45) {
                                n2 = this.input.read();
                                if (n2 == 120) {
                                    return this.token(RubyStringTokenId.STRING_ESCAPE);
                                }
                                this.input.backup(2);
                                break block0;
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        case 77: {
                            n2 = this.input.read();
                            if (n2 == 45) {
                                n2 = this.input.read();
                                if (n2 == 120) {
                                    return this.token(RubyStringTokenId.STRING_ESCAPE);
                                }
                                this.input.backup(2);
                                break block0;
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        default: {
                            return this.token(RubyStringTokenId.STRING_ESCAPE);
                        }
                    }
                }
            }
        }
    }

    private static boolean isHexDigit(int n) {
        return Character.isDigit(n) || n >= 97 && n <= 102 || n >= 65 && n <= 70;
    }

    private Token<RubyStringTokenId> token(RubyStringTokenId rubyStringTokenId) {
        return this.tokenFactory.createToken((TokenId)rubyStringTokenId);
    }

    public void release() {
    }
}

