/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedElement
extends RubyElement {
    public static final int DOCUMENTED = 1;
    public static final int PROTECTED = 2;
    public static final int PRIVATE = 4;
    public static final int TOPLEVEL = 8;
    public static final int STATIC = 16;
    public static final int NODOC = 32;
    protected final FileObject file;
    protected final String clz;
    protected final String fqn;
    protected final String require;
    protected final String attributes;
    protected final int flags;
    protected int docLength = -1;
    private Set<Modifier> modifiers;
    private final RubyIndex index;
    private Document document;
    private final FileObject context;
    protected RubyType type;

    protected IndexedElement(RubyIndex rubyIndex, FileObject fileObject, String string, String string2, String string3, String string4, int n, FileObject fileObject2, RubyType rubyType) {
        this.index = rubyIndex;
        this.file = fileObject;
        this.fqn = string;
        this.require = string3;
        this.attributes = string4;
        this.clz = string2;
        this.flags = n;
        this.context = fileObject2;
        this.type = rubyType;
    }

    protected IndexedElement(RubyIndex rubyIndex, IndexResult indexResult, String string, String string2, String string3, String string4, int n, FileObject fileObject, RubyType rubyType) {
        this(rubyIndex, indexResult.getFile(), string, string2, string3, string4, n, fileObject, rubyType);
    }

    protected IndexedElement(RubyIndex rubyIndex, IndexResult indexResult, String string, String string2, String string3, String string4, int n, FileObject fileObject) {
        this(rubyIndex, indexResult, string, string2, string3, string4, n, fileObject, null);
    }

    public abstract String getSignature();

    public final String getRequire() {
        return this.require;
    }

    public final String getFqn() {
        return this.fqn;
    }

    @Override
    public RubyType getType() {
        int n;
        if (this.type == null && this.attributes != null && (n = this.attributes.lastIndexOf(59)) != -1) {
            int n2 = this.attributes.lastIndexOf(59, n - 1);
            if (n != -1) {
                String string = this.attributes.substring(n2 + 1, n);
                this.type = this.parseTypes(string);
            }
        }
        if (this.type == null) {
            this.type = RubyType.createUnknown();
        }
        return this.type;
    }

    private RubyType parseTypes(String string) {
        if (string.length() == 0) {
            return RubyType.createUnknown();
        }
        if (!string.contains("|")) {
            return RubyType.create(string);
        }
        return new RubyType(string.split("\\|"));
    }

    public String toString() {
        return this.getSignature();
    }

    public final String getClz() {
        return this.clz;
    }

    public RubyIndex getIndex() {
        return this.index;
    }

    @Override
    public String getIn() {
        return this.getClz();
    }

    public Document getDocument() {
        if (this.document == null) {
            FileObject fileObject = this.getFileObject();
            if (fileObject == null) {
                return null;
            }
            this.document = GsfUtilities.getDocument((FileObject)fileObject, (boolean)true);
        }
        return this.document;
    }

    @Override
    public FileObject getFileObject() {
        return this.file;
    }

    public String getFileUrl() {
        if (this.file == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)this.file);
        try {
            return file == null ? null : file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    @Override
    public final Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            Modifier modifier = Modifier.PUBLIC;
            if (this.isPrivate()) {
                modifier = Modifier.PRIVATE;
            } else if (this.isProtected()) {
                modifier = Modifier.PROTECTED;
            }
            boolean bl = this.isStatic();
            this.modifiers = modifier != Modifier.PUBLIC ? (bl ? EnumSet.of(modifier, Modifier.STATIC) : EnumSet.of(modifier)) : (bl ? EnumSet.of(Modifier.STATIC) : Collections.emptySet());
        }
        return this.modifiers;
    }

    public int getDocumentationLength() {
        return this.isDocumented() ? 1 : 0;
    }

    public static char flagToFirstChar(int n) {
        char c = (char)(n >>= 4);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static char flagToSecondChar(int n) {
        char c = (char)(n & 0xF);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static String flagToString(int n) {
        return "" + IndexedElement.flagToFirstChar(n) + IndexedElement.flagToSecondChar(n);
    }

    public static int stringToFlag(String string, int n) {
        return IndexedElement.stringToFlag(string.charAt(n), string.charAt(n + 1));
    }

    public static int stringToFlag(char c, char c2) {
        if (c == ';') {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        n = c > '9' ? c - 97 + 10 : c - 48;
        n2 = c2 > '9' ? c2 - 97 + 10 : c2 - 48;
        return (n << 4) + n2;
    }

    public boolean isDocumented() {
        return (this.flags & 1) != 0;
    }

    public boolean isPublic() {
        return (this.flags & 4 & 2) == 0;
    }

    public boolean isPrivate() {
        return (this.flags & 4) != 0 || (this.flags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.flags & 2) != 0;
    }

    public boolean isTopLevel() {
        return (this.flags & 8) != 0;
    }

    public boolean isStatic() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isNoDoc() {
        return (this.flags & 0x20) != 0;
    }

    public static String decodeFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("|DOCUMENTED");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("|PRIVATE");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("|PROTECTED");
        }
        if ((n & 8) != 0) {
            stringBuilder.append("|TOPLEVEL");
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append("|STATIC");
        }
        if ((n & 0x20) != 0) {
            stringBuilder.append("|NODOC");
        }
        return stringBuilder.toString();
    }

    public static int stringToFlags(String string) {
        int n = 0;
        if (string.indexOf("|DOCUMENTED") != -1) {
            ++n;
        }
        if (string.indexOf("|PRIVATE") != -1) {
            n += 4;
        }
        if (string.indexOf("|PROTECTED") != -1) {
            n += 2;
        }
        if (string.indexOf("|TOPLEVEL") != -1) {
            n += 8;
        }
        if (string.indexOf("|STATIC") != -1) {
            n += 16;
        }
        if (string.indexOf("|NODOC") != -1) {
            n += 32;
        }
        return n;
    }

    public boolean doesBelongToModule() {
        return "Module".equals(this.getFqn());
    }
}

