/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class DiffPresenter
extends JPanel {
    public static final String PROP_PROVIDER = "provider";
    public static final String PROP_VISUALIZER = "visualizer";
    public static final String PROP_TOOLBAR = "DiffPresenter.toolbarPanel";
    private Info diffInfo;
    private DiffProvider defaultProvider;
    private DiffVisualizer defaultVisualizer;
    private JComponent progressPanel;
    private final RequestProcessor diffRP = new RequestProcessor("Diff", 1, true);
    private RequestProcessor.Task computationTask = this.diffRP.post(new Runnable(){

        public void run() {
        }
    });
    private boolean added;
    JPanel jPanel1;
    JLabel providerLabel;
    JPanel servicesPanel;
    JPanel toolbarPanel;
    JLabel visualizerLabel;
    JPanel visualizerPanel;

    public DiffPresenter() {
        String string = NbBundle.getMessage(DiffPresenter.class, (String)"diff.prog");
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        this.progressPanel = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        this.add(this.progressPanel);
        progressHandle.start();
    }

    public DiffPresenter(Info info) {
        this.initWithDiffInfo(info);
    }

    public final void initWithDiffInfo(Info info) {
        assert (this.diffInfo == null);
        this.diffInfo = info;
        if (this.progressPanel != null) {
            this.remove(this.progressPanel);
        }
        this.initComponents();
        this.initMyComponents();
        this.providerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffPresenter.class, (String)"ACS_ProviderA11yDesc"));
        this.visualizerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffPresenter.class, (String)"ACS_VisualizerA11yDesc"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.toolbarPanel = new JPanel();
        this.servicesPanel = new JPanel();
        this.providerLabel = new JLabel();
        this.visualizerLabel = new JLabel();
        this.visualizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.toolbarPanel.setLayout(new FlowLayout(1, 0, 0));
        this.toolbarPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.toolbarPanel, gridBagConstraints);
        this.servicesPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.providerLabel, (String)NbBundle.getMessage(DiffPresenter.class, (String)"LBL_Provider"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.servicesPanel.add((Component)this.providerLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.visualizerLabel, (String)NbBundle.getMessage(DiffPresenter.class, (String)"LBL_Visualizer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.servicesPanel.add((Component)this.visualizerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.servicesPanel, gridBagConstraints);
        this.visualizerPanel.setLayout(new BorderLayout());
        this.visualizerPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.visualizerPanel, gridBagConstraints);
    }

    private void initMyComponents() {
        GridBagConstraints gridBagConstraints;
        PropertyPanel propertyPanel;
        DefaultPropertyModel defaultPropertyModel;
        Node node;
        DataObject dataObject;
        FileObject fileObject;
        PropertyDescriptor propertyDescriptor;
        FileObject fileObject2 = FileUtil.getConfigFile((String)"Services");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Object.class);
        if (this.diffInfo.isChooseProviders() && propertyEditor != null) {
            try {
                propertyDescriptor = new PropertyDescriptor(PROP_PROVIDER, this.getClass());
            }
            catch (IntrospectionException introspectionException) {
                return;
            }
            propertyDescriptor.setPropertyEditorClass(propertyEditor.getClass());
            propertyDescriptor.setValue("superClass", DiffProvider.class);
            propertyDescriptor.setValue("suppressCustomEditor", Boolean.TRUE);
            fileObject = fileObject2.getFileObject("DiffProviders");
            try {
                dataObject = DataObject.find((FileObject)fileObject);
                node = dataObject.getNodeDelegate();
                propertyDescriptor.setValue("node", node);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            propertyDescriptor.setValue("helpID", "org.netbeans.modules.diff.DiffPresenter.providers");
            defaultPropertyModel = new DefaultPropertyModel((Object)this, propertyDescriptor);
            propertyPanel = new PropertyPanel((PropertyModel)defaultPropertyModel, 4);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 15);
            gridBagConstraints.anchor = 17;
            if (!this.diffInfo.isChooseVisualizers()) {
                gridBagConstraints.weightx = 1.0;
            }
            gridBagConstraints.gridx = 1;
            this.servicesPanel.add((Component)propertyPanel, gridBagConstraints);
            this.providerLabel.setLabelFor((Component)propertyPanel);
            propertyPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffPresenter.class, (String)"ACS_ProviderPropertyPanelA11yName"));
            propertyPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffPresenter.class, (String)"ACS_ProviderPropertyPanelA11yDesc"));
        }
        if (this.diffInfo.isChooseVisualizers() && propertyEditor != null) {
            try {
                propertyDescriptor = new PropertyDescriptor(PROP_VISUALIZER, this.getClass());
            }
            catch (IntrospectionException introspectionException) {
                return;
            }
            propertyDescriptor.setPropertyEditorClass(propertyEditor.getClass());
            propertyDescriptor.setValue("superClass", DiffVisualizer.class);
            propertyDescriptor.setValue("suppressCustomEditor", Boolean.TRUE);
            fileObject = fileObject2.getFileObject("DiffVisualizers");
            try {
                dataObject = DataObject.find((FileObject)fileObject);
                node = dataObject.getNodeDelegate();
                propertyDescriptor.setValue("node", node);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            propertyDescriptor.setValue("helpID", "org.netbeans.modules.diff.DiffPresenter.visualizers");
            defaultPropertyModel = new DefaultPropertyModel((Object)this, propertyDescriptor);
            propertyPanel = new PropertyPanel((PropertyModel)defaultPropertyModel, 4);
            propertyPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffPresenter.class, (String)"ACS_VisualizerPropertyPanelA11yName"));
            propertyPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffPresenter.class, (String)"ACS_VisualizerPropertyPanelA11yDesc"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 3;
            this.servicesPanel.add((Component)propertyPanel, gridBagConstraints);
            this.visualizerLabel.setLabelFor((Component)propertyPanel);
        }
        this.providerLabel.setVisible(this.diffInfo.isChooseProviders() && propertyEditor != null);
        this.visualizerLabel.setVisible(this.diffInfo.isChooseVisualizers() && propertyEditor != null);
        this.servicesPanel.setVisible((this.diffInfo.isChooseProviders() || this.diffInfo.isChooseVisualizers()) && propertyEditor != null);
    }

    public DiffProvider getProvider() {
        return this.defaultProvider;
    }

    public void setProvider(DiffProvider diffProvider) {
        this.defaultProvider = diffProvider;
        if (this.added) {
            this.asyncDiff(diffProvider, this.defaultVisualizer);
            DiffPresenter.setDefaultDiffService(diffProvider, "Services/DiffProviders");
        }
    }

    public DiffVisualizer getVisualizer() {
        return this.defaultVisualizer;
    }

    public void setVisualizer(DiffVisualizer diffVisualizer) {
        this.defaultVisualizer = diffVisualizer;
        if (this.added) {
            this.asyncDiff(this.defaultProvider, diffVisualizer);
            DiffPresenter.setDefaultDiffService(diffVisualizer, "Services/DiffVisualizers");
        }
    }

    private static void setDefaultDiffService(Object object, String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            InstanceDataObject instanceDataObject;
            if (!(dataObjectArray[i] instanceof InstanceDataObject) || !(instanceDataObject = (InstanceDataObject)dataObjectArray[i]).instanceOf(object.getClass())) continue;
            try {
                if (!object.equals(instanceDataObject.instanceCreate())) continue;
                dataFolder.setOrder(new DataObject[]{instanceDataObject});
                break;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.added = true;
        this.asyncDiff(this.defaultProvider, this.defaultVisualizer);
    }

    public void removeNotify() {
        super.removeNotify();
        this.computationTask.cancel();
    }

    private synchronized void asyncDiff(final DiffProvider diffProvider, final DiffVisualizer diffVisualizer) {
        Object object;
        Difference[] differenceArray;
        Difference[] differenceArray2;
        if (diffVisualizer == null) {
            return;
        }
        if (diffProvider != null) {
            differenceArray2 = this.diffInfo.getInitialDifferences();
            if (differenceArray2 == null) {
                differenceArray = new JPanel();
                differenceArray.setLayout(new BorderLayout());
                object = NbBundle.getMessage(DiffPresenter.class, (String)"BK0001");
                JLabel jLabel = new JLabel((String)object);
                jLabel.setHorizontalAlignment(0);
                differenceArray.add((Component)jLabel, "Center");
                this.setVisualizer((JComponent)differenceArray);
            }
        } else {
            differenceArray2 = this.diffInfo.getDifferences();
        }
        differenceArray = differenceArray2;
        object = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Difference[] differenceArray3 = differenceArray;
                    String string = NbBundle.getMessage(DiffPresenter.class, (String)"BK0001");
                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
                    if (differenceArray3 == null) {
                        try {
                            progressHandle.start();
                            differenceArray3 = diffProvider.computeDiff(DiffPresenter.this.diffInfo.createFirstReader(), DiffPresenter.this.diffInfo.createSecondReader());
                        }
                        finally {
                            progressHandle.finish();
                        }
                    }
                    if (differenceArray3 == null) {
                        return;
                    }
                    final Difference[] differenceArray2 = differenceArray3;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                DiffPresenter.this.viewVisualizer(diffVisualizer, differenceArray2);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(256, (Throwable)iOException);
                            }
                        }
                    });
                }
                catch (InterruptedIOException interruptedIOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)interruptedIOException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(256, (Throwable)iOException);
                }
            }
        };
        this.computationTask.cancel();
        this.computationTask = this.diffRP.post((Runnable)object);
    }

    private void viewVisualizer(DiffVisualizer diffVisualizer, Difference[] differenceArray) throws IOException {
        assert (SwingUtilities.isEventDispatchThread());
        Component component = diffVisualizer.createView(differenceArray, this.diffInfo.getName1(), this.diffInfo.getTitle1(), this.diffInfo.createFirstReader(), this.diffInfo.getName2(), this.diffInfo.getTitle2(), this.diffInfo.createSecondReader(), this.diffInfo.getMimeType());
        this.setVisualizer((JComponent)component);
        TopComponent topComponent = this.diffInfo.getPresentingComponent();
        if (topComponent != null) {
            topComponent.setName(component.getName());
            if (component instanceof TopComponent) {
                TopComponent topComponent2 = (TopComponent)component;
                topComponent.setToolTipText(topComponent2.getToolTipText());
                topComponent.setIcon(topComponent2.getIcon());
            }
        }
        component.requestFocus();
    }

    private void setVisualizer(JComponent jComponent) {
        this.visualizerPanel.removeAll();
        if (jComponent != null) {
            this.toolbarPanel.removeAll();
            JComponent jComponent2 = (JComponent)jComponent.getClientProperty(PROP_TOOLBAR);
            if (jComponent2 != null) {
                this.toolbarPanel.add(jComponent2);
            }
            this.visualizerPanel.add((Component)jComponent, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    public static abstract class Info {
        private String name1;
        private String name2;
        private String title1;
        private String title2;
        private String mimeType;
        private boolean chooseProviders;
        private boolean chooseVisualizers;
        private TopComponent tp;

        public Info(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
            this.name1 = string;
            this.name2 = string2;
            this.title1 = string3;
            this.title2 = string4;
            this.mimeType = string5;
            this.chooseProviders = bl;
            this.chooseVisualizers = bl2;
        }

        public String getName1() {
            return this.name1;
        }

        public String getName2() {
            return this.name2;
        }

        public String getTitle1() {
            return this.title1;
        }

        public String getTitle2() {
            return this.title2;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public boolean isChooseProviders() {
            return this.chooseProviders;
        }

        public boolean isChooseVisualizers() {
            return this.chooseVisualizers;
        }

        public Difference[] getDifferences() {
            return null;
        }

        public Difference[] getInitialDifferences() {
            return null;
        }

        public abstract Reader createFirstReader() throws FileNotFoundException;

        public abstract Reader createSecondReader() throws FileNotFoundException;

        public void setPresentingComponent(TopComponent topComponent) {
            this.tp = topComponent;
        }

        public TopComponent getPresentingComponent() {
            return this.tp;
        }
    }
}

