/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BootClassPathImplementation
implements ClassPathImplementation {
    private static final Logger LOGGER = Logger.getLogger(BootClassPathImplementation.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final ProjectConfigListener projectConfigListener = new ProjectConfigListener();
    private final GrailsProjectConfig config;
    private List<PathResourceImplementation> resourcesCache;
    private long eventId;

    private BootClassPathImplementation(GrailsProjectConfig grailsProjectConfig) {
        this.config = grailsProjectConfig;
    }

    public static BootClassPathImplementation forProject(Project project) {
        GrailsProjectConfig grailsProjectConfig = GrailsProjectConfig.forProject((Project)project);
        BootClassPathImplementation bootClassPathImplementation = new BootClassPathImplementation(grailsProjectConfig);
        grailsProjectConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)bootClassPathImplementation.projectConfigListener, (Object)grailsProjectConfig));
        return bootClassPathImplementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        Object object;
        ClassPath classPath;
        long l;
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            if (this.resourcesCache != null) {
                return this.resourcesCache;
            }
            l = this.eventId;
        }
        bootClassPathImplementation = this.config.getJavaPlatform();
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        if (bootClassPathImplementation != null) {
            classPath = bootClassPathImplementation.getBootstrapLibraries();
            assert (classPath != null) : bootClassPathImplementation;
            for (ClassPath.Entry entry : classPath.entries()) {
                arrayList.add(ClassPathSupport.createResource((URL)entry.getURL()));
            }
        }
        if ((classPath = this.config.getGrailsPlatform()) != null) {
            object = classPath.getClassPath();
            assert (object != null) : classPath;
            for (ClassPath.Entry entry : object.entries()) {
                arrayList.add(ClassPathSupport.createResource((URL)entry.getURL()));
            }
        }
        object = this;
        synchronized (object) {
            if (l == this.eventId) {
                if (this.resourcesCache == null) {
                    this.resourcesCache = Collections.unmodifiableList(arrayList);
                }
                return this.resourcesCache;
            }
            return Collections.unmodifiableList(arrayList);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private class ProjectConfigListener
    implements PropertyChangeListener {
        private ProjectConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("grails.java.platform".equals(propertyChangeEvent.getPropertyName()) || "grails.platform".equals(propertyChangeEvent.getPropertyName())) {
                LOGGER.log(Level.FINE, "Boot classpath changed due to change in {0}", propertyChangeEvent.getPropertyName());
                BootClassPathImplementation bootClassPathImplementation = BootClassPathImplementation.this;
                synchronized (bootClassPathImplementation) {
                    BootClassPathImplementation.this.resourcesCache = null;
                    BootClassPathImplementation.this.eventId++;
                }
                BootClassPathImplementation.this.support.firePropertyChange("resources", null, null);
            }
        }
    }
}

