/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class SessionsTreeModel
implements TreeModel {
    private Listener listener;
    private Vector listeners = new Vector();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            n2 = Math.min(sessionArray.length, n2);
            n = Math.min(sessionArray.length, n);
            Object[] objectArray = new Session[n2 - n];
            System.arraycopy(sessionArray, n, objectArray, 0, n2 - n);
            return objectArray;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Session) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter {
        private WeakReference model;

        public Listener(SessionsTreeModel sessionsTreeModel) {
            this.model = new WeakReference<SessionsTreeModel>(sessionsTreeModel);
            DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)this);
        }

        private SessionsTreeModel getModel() {
            SessionsTreeModel sessionsTreeModel = (SessionsTreeModel)this.model.get();
            if (sessionsTreeModel == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("sessions", (DebuggerManagerListener)this);
            }
            return sessionsTreeModel;
        }

        public void sessionAdded(Session session) {
            SessionsTreeModel sessionsTreeModel = this.getModel();
            if (sessionsTreeModel == null) {
                return;
            }
            sessionsTreeModel.fireTreeChanged();
        }

        public void sessionRemoved(Session session) {
            SessionsTreeModel sessionsTreeModel = this.getModel();
            if (sessionsTreeModel == null) {
                return;
            }
            sessionsTreeModel.fireTreeChanged();
        }
    }
}

