/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.pluginimporter.ClusterUpdateProvider;
import org.netbeans.modules.autoupdate.pluginimporter.ImportManager;
import org.netbeans.modules.autoupdate.pluginimporter.PluginImporter;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer
extends ModuleInstall {
    public static final String KEY_IMPORT_FROM = "import-from";
    public static final String CODE_NAME = "ClusterUpdateProvider";
    public static final String REMOVED = "_removed";
    private static Logger LOG = Logger.getLogger(Installer.class.getName());
    private static final List<String> VERSION_TO_CHECK = Arrays.asList(".netbeans/6.7", ".netbeans/6.5", ".netbeans/6.1", ".netbeans/6.0", ".netbeans/5.5.1", ".netbeans/5.5");
    private static final String IMPORTED = "imported";
    private Runnable doCheck = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Preferences preferences;
            File file = null;
            String string = System.getProperty("plugin.manager.import.from", "");
            Preferences preferences2 = NbPreferences.forModule(Installer.class);
            Preferences preferences3 = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
            if (string.length() > 0) {
                file = new File(string);
            } else if (preferences2.get(Installer.KEY_IMPORT_FROM, null) != null) {
                file = new File(preferences2.get(Installer.KEY_IMPORT_FROM, ""));
            } else {
                file = Installer.checkPrevious(VERSION_TO_CHECK);
                boolean bl = preferences3.getBoolean(Installer.IMPORTED, false);
                if (!bl) {
                    file = null;
                }
            }
            preferences3.putBoolean(Installer.IMPORTED, false);
            if (file == null || !file.exists()) {
                LOG.fine("Nothing to import from " + file);
                return;
            }
            try {
                preferences = preferences3.node("ClusterUpdateProvider_removed");
                preferences.removeNode();
            }
            catch (BackingStoreException backingStoreException) {
                LOG.log(Level.INFO, backingStoreException.getLocalizedMessage(), backingStoreException);
                return;
            }
            preferences = null;
            for (Object object : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
                if (!Installer.CODE_NAME.contains(object.getName())) continue;
                preferences = object;
            }
            assert (preferences != null) : "clusterUpdateProvider must found";
            if (preferences != null) {
                try {
                    Object object;
                    assert (file != null && file.exists()) : file + " exists.";
                    ClusterUpdateProvider.attachCluster(file);
                    List list = preferences.getUpdateUnits();
                    UpdateUnitProviderFactory.getDefault().remove((UpdateUnitProvider)preferences);
                    object = new PluginImporter(list);
                    LOG.fine("Already installed plugins: " + ((PluginImporter)object).getInstalledPlugins());
                    LOG.fine("Plugins available on UC: " + ((PluginImporter)object).getPluginsAvailableToInstall());
                    LOG.fine("Plugins available for import: " + ((PluginImporter)object).getPluginsToImport());
                    if (!((PluginImporter)object).getBrokenPlugins().isEmpty()) {
                        LOG.info("Plugins for import with broken dependencies: " + ((PluginImporter)object).getBrokenPlugins());
                    }
                    if (!((PluginImporter)object).getPluginsToImport().isEmpty() || !((PluginImporter)object).getPluginsAvailableToInstall().isEmpty()) {
                        LOG.info(((PluginImporter)object).getPluginsToImport().size() + ((PluginImporter)object).getPluginsAvailableToInstall().size() + " available plugins for import in " + file);
                        ImportManager importManager = new ImportManager(file, Installer.getUserDir(), (PluginImporter)object);
                        importManager.notifyAvailable();
                    } else {
                        LOG.fine(((PluginImporter)object).getPluginsToImport().size() + ((PluginImporter)object).getPluginsAvailableToInstall().size() + " available plugins for import in " + file);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, exception.getLocalizedMessage() + " while importing plugins from " + file, exception);
                }
                finally {
                    UpdateUnitProviderFactory.getDefault().remove((UpdateUnitProvider)preferences);
                }
            }
        }
    };

    public void restored() {
        if (Boolean.getBoolean("netbeans.full.hack") || Boolean.getBoolean("netbeans.close")) {
            return;
        }
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        preferences.node("ClusterUpdateProvider_removed").putBoolean(REMOVED, true);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(Installer.this.doCheck, Installer.this.getImportDelay());
            }
        });
    }

    private static File getUserDir() {
        String string = System.getProperty("netbeans.user");
        File file = null;
        if (string != null) {
            file = new File(string);
            if (file.getPath().startsWith("\\\\")) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    file = file.getAbsoluteFile();
                }
            } else {
                file = new File(file.toURI().normalize()).getAbsoluteFile();
            }
        }
        return file;
    }

    private static File checkPrevious(List<String> list) {
        String string = System.getProperty("user.home");
        File file = null;
        if (string != null) {
            File file2 = new File(string);
            for (String string2 : list) {
                file = new File(file2.getAbsolutePath(), string2);
                if (!file.exists() || !file.isDirectory()) continue;
                return file;
            }
        }
        return null;
    }

    private int getImportDelay() {
        int n = 50000;
        String string = System.getProperty("plugin.manager.import.delay");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }
}

