/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class SourcesHelper {
    private final Project prj;
    private final RakeProjectHelper project;
    private final PropertyEvaluator evaluator;
    private final List<SourceRoot> principalSourceRoots = new ArrayList<SourceRoot>();
    private final List<Root> nonSourceRoots = new ArrayList<Root>();
    private final List<TypedSourceRoot> typedSourceRoots = new ArrayList<TypedSourceRoot>();
    private int registeredRootAlgorithm;
    private Set<FileObject> lastRegisteredRoots;
    private PropertyChangeListener propChangeL;

    public SourcesHelper(Project project, RakeProjectHelper rakeProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.prj = project;
        this.project = rakeProjectHelper;
        this.evaluator = propertyEvaluator;
    }

    public void addPrincipalSourceRoot(String string, String string2, Icon icon, Icon icon2) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.principalSourceRoots.add(new SourceRoot(string, string2, icon, icon2));
    }

    public void addNonSourceRoot(String string) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.nonSourceRoots.add(new Root(string));
    }

    public void addTypedSourceRoot(String string, String string2, String string3, Icon icon, Icon icon2) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.typedSourceRoots.add(new TypedSourceRoot(string2, string, string3, icon, icon2));
    }

    private Project getProject() {
        return this.prj;
    }

    public void registerExternalRoots(int n) throws IllegalArgumentException, IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called before");
        }
        this.registeredRootAlgorithm = n;
        this.remarkExternalRoots();
    }

    private void remarkExternalRoots() throws IllegalArgumentException {
        HashSet<FileObject> hashSet;
        ArrayList<SourceRoot> arrayList = new ArrayList<SourceRoot>(this.principalSourceRoots);
        arrayList.addAll(this.nonSourceRoots);
        Project project = this.getProject();
        FileObject fileObject = this.project.getProjectDirectory();
        if (this.lastRegisteredRoots == null) {
            hashSet = null;
            this.lastRegisteredRoots = new HashSet<FileObject>();
            this.propChangeL = new PropChangeL();
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propChangeL, (Object)this.evaluator));
        } else {
            hashSet = new HashSet<FileObject>();
        }
        for (Root object : arrayList) {
            File file = object.getActualLocation();
            FileObject fileObject2 = file != null ? FileUtil.toFileObject((File)file) : null;
            if (fileObject2 == null || !fileObject2.isFolder() || FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2) != null) continue;
            try {
                Project project2 = ProjectManager.getDefault().findProject(fileObject2);
                if (project2 != null) {
                }
            }
            catch (IOException iOException) {}
            continue;
            if (hashSet != null) {
                hashSet.add(fileObject2);
                continue;
            }
            this.lastRegisteredRoots.add(fileObject2);
            FileOwnerQuery.markExternalOwner((FileObject)fileObject2, (Project)project, (int)this.registeredRootAlgorithm);
        }
        if (hashSet != null) {
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>(this.lastRegisteredRoots);
            hashSet2.removeAll(hashSet);
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject3 = (FileObject)iterator.next();
                FileOwnerQuery.markExternalOwner((FileObject)fileObject3, null, (int)this.registeredRootAlgorithm);
            }
            hashSet.removeAll(this.lastRegisteredRoots);
            for (FileObject fileObject4 : hashSet) {
                FileOwnerQuery.markExternalOwner((FileObject)fileObject4, (Project)project, (int)this.registeredRootAlgorithm);
            }
        }
    }

    public Sources createSources() {
        return new SourcesImpl();
    }

    private final class PropChangeL
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourcesHelper.this.remarkExternalRoots();
        }
    }

    private final class SourcesImpl
    implements Sources,
    PropertyChangeListener,
    FileChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean haveAttachedListeners;
        private final Set<File> rootsListenedTo = new HashSet<File>();
        private final Map<String, List<URL>> lastComputedRoots = new HashMap<String, List<URL>>();

        public SourcesImpl() {
            SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcesHelper.this.evaluator));
        }

        /*
         * WARNING - void declaration
         */
        public SourceGroup[] getSourceGroups(String string) {
            Object object2;
            AbstractCollection abstractCollection;
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            if (string.equals("generic")) {
                abstractCollection = new ArrayList(SourcesHelper.this.principalSourceRoots);
                abstractCollection.add((SourceRoot)new SourceRoot("", ProjectUtils.getInformation((Project)SourcesHelper.this.getProject()).getDisplayName(), null, null));
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (Object object2 : abstractCollection) {
                    File file = ((Root)object2).getActualLocation();
                    if (file == null) continue;
                    this.listen(file);
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null || linkedHashMap.containsKey(fileObject)) continue;
                    linkedHashMap.put(fileObject, object2);
                }
                Iterator iterator = linkedHashMap.keySet().iterator();
                block3: while (iterator.hasNext()) {
                    void var7_16;
                    object2 = (FileObject)iterator.next();
                    FileObject fileObject = object2.getParent();
                    while (var7_16 != null) {
                        if (linkedHashMap.containsKey(var7_16)) {
                            iterator.remove();
                            continue block3;
                        }
                        FileObject fileObject2 = var7_16.getParent();
                    }
                }
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    arrayList.add(((SourceRoot)entry.getValue()).toGroup((FileObject)entry.getKey()));
                }
            } else {
                abstractCollection = new HashSet();
                for (TypedSourceRoot typedSourceRoot : SourcesHelper.this.typedSourceRoots) {
                    if (!typedSourceRoot.getType().equals(string) || (object2 = typedSourceRoot.getActualLocation()) == null) continue;
                    this.listen((File)object2);
                    FileObject fileObject = FileUtil.toFileObject((File)object2);
                    if (fileObject == null || !abstractCollection.add(fileObject)) continue;
                    arrayList.add(typedSourceRoot.toGroup(fileObject));
                }
            }
            abstractCollection = new ArrayList(arrayList.size());
            for (SourceGroup sourceGroup : arrayList) {
                try {
                    abstractCollection.add(sourceGroup.getRootFolder().getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    assert (false) : fileStateInvalidException;
                }
            }
            this.lastComputedRoots.put(string, (List<URL>)((Object)abstractCollection));
            return arrayList.toArray(new SourceGroup[arrayList.size()]);
        }

        private synchronized void listen(File file) {
            if (this.rootsListenedTo.add(file) && this.haveAttachedListeners) {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
            }
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            if (!this.haveAttachedListeners) {
                this.haveAttachedListeners = true;
                for (File file : this.rootsListenedTo) {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
                }
            }
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        private void maybeFireChange() {
            boolean bl = false;
            for (String string : new HashSet<String>(this.lastComputedRoots.keySet())) {
                ArrayList arrayList = new ArrayList(this.lastComputedRoots.get(string));
                this.getSourceGroups(string);
                List<URL> list = this.lastComputedRoots.get(string);
                if (((Object)list).equals(arrayList)) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.cs.fireChange();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.maybeFireChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.maybeFireChange();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.maybeFireChange();
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.maybeFireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.maybeFireChange();
        }
    }

    private final class TypedSourceRoot
    extends SourceRoot {
        private final String type;

        public TypedSourceRoot(String string, String string2, String string3, Icon icon, Icon icon2) {
            super(string2, string3, icon, icon2);
            this.type = string;
        }

        public final String getType() {
            return this.type;
        }
    }

    private class SourceRoot
    extends Root {
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;

        public SourceRoot(String string, String string2, Icon icon, Icon icon2) {
            super(string);
            this.displayName = string2;
            this.icon = icon;
            this.openedIcon = icon2;
        }

        public final SourceGroup toGroup(FileObject fileObject) {
            assert (fileObject != null);
            return GenericSources.group((Project)SourcesHelper.this.getProject(), (FileObject)fileObject, (String)(this.location.length() > 0 ? this.location : "generic"), (String)this.displayName, (Icon)this.icon, (Icon)this.openedIcon);
        }
    }

    private class Root {
        protected final String location;

        public Root(String string) {
            this.location = string;
        }

        public final File getActualLocation() {
            String string = SourcesHelper.this.evaluator.evaluate(this.location);
            if (string == null) {
                return null;
            }
            return SourcesHelper.this.project.resolveFile(string);
        }
    }
}

