/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.dd.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.DDException;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.api.app.SunApplication;
import org.netbeans.modules.j2ee.sun.dd.api.client.SunApplicationClient;
import org.netbeans.modules.j2ee.sun.dd.api.cmp.SunCmpMappings;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.SunEjbJar;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.dd.impl.RootInterfaceImpl;
import org.netbeans.modules.j2ee.sun.dd.impl.app.SunApplicationProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.client.SunApplicationClientProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.cmp.SunCmpMappingsProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.common.DDProviderDataObject;
import org.netbeans.modules.j2ee.sun.dd.impl.common.SunBaseBean;
import org.netbeans.modules.j2ee.sun.dd.impl.ejb.SunEjbJarProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.serverresources.ResourcesProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.web.SunWebAppProxy;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final DDProvider ddProvider = new DDProvider();
    private Map<Object, RootInterface> ddMap = new WeakHashMap<Object, RootInterface>();
    private Map<FileObject, DDProviderDataObject> dObjMap = new WeakHashMap<FileObject, DDProviderDataObject>();
    private static Map<Class, Map<String, VersionInfo>> apiToVersionMap = new HashMap<Class, Map<String, VersionInfo>>(11);
    private static Map<String, VersionInfo> sunWebAppVersionMap = new HashMap<String, VersionInfo>(11);
    private static Map<String, VersionInfo> sunEjbJarVersionMap = new HashMap<String, VersionInfo>(11);
    private static Map<String, VersionInfo> sunApplicationVersionMap = new HashMap<String, VersionInfo>(11);
    private static Map<String, VersionInfo> sunAppClientVersionMap = new HashMap<String, VersionInfo>(11);
    private static Map<String, VersionInfo> sunResourcesVersionMap = new HashMap<String, VersionInfo>(11);
    private static Map<String, DocTypeInfo> publicIdToInfoMap;

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public SunEjbJar getEjbDDRoot(InputSource inputSource) throws IOException, SAXException {
        DDParse dDParse = new DDParse(inputSource);
        SunEjbJar sunEjbJar = DDProvider.createEjbJar(dDParse);
        SunEjbJarProxy sunEjbJarProxy = new SunEjbJarProxy(sunEjbJar, sunEjbJar.getVersion().toString());
        DDProvider.setErrorStatus(sunEjbJarProxy, dDParse);
        return sunEjbJarProxy;
    }

    public SunWebApp getWebDDRoot(InputSource inputSource) throws IOException, SAXException, DDException {
        return this.processWebAppParseTree(new DDParse(inputSource));
    }

    public SunWebApp getWebDDRoot(InputStream inputStream) throws IOException, SAXException, DDException {
        return this.processWebAppParseTree(new DDParse(inputStream));
    }

    public SunWebApp getWebDDRoot(Document document) throws DDException {
        return this.processWebAppParseTree(new DDParse(document, null));
    }

    private SunWebApp processWebAppParseTree(DDParse dDParse) throws DDException {
        SunWebApp sunWebApp = DDProvider.createWebApp(dDParse);
        SunWebAppProxy sunWebAppProxy = new SunWebAppProxy(sunWebApp, sunWebApp.getVersion().toString());
        DDProvider.setErrorStatus(sunWebAppProxy, dDParse);
        return sunWebAppProxy;
    }

    public SunApplication getAppDDRoot(InputSource inputSource) throws IOException, SAXException {
        DDParse dDParse = new DDParse(inputSource);
        SunApplication sunApplication = DDProvider.createApplication(dDParse);
        SunApplicationProxy sunApplicationProxy = new SunApplicationProxy(sunApplication, sunApplication.getVersion().toString());
        DDProvider.setErrorStatus(sunApplicationProxy, dDParse);
        return sunApplicationProxy;
    }

    public SunApplicationClient getAppClientDDRoot(InputSource inputSource) throws IOException, SAXException {
        DDParse dDParse = new DDParse(inputSource);
        SunApplicationClient sunApplicationClient = DDProvider.createApplicationClient(dDParse);
        SunApplicationClientProxy sunApplicationClientProxy = new SunApplicationClientProxy(sunApplicationClient, sunApplicationClient.getVersion().toString());
        DDProvider.setErrorStatus(sunApplicationClientProxy, dDParse);
        return sunApplicationClientProxy;
    }

    private static void setErrorStatus(RootInterfaceImpl rootInterfaceImpl, DDParse dDParse) {
        SAXParseException sAXParseException = dDParse.getWarning();
        rootInterfaceImpl.setError(sAXParseException);
        if (sAXParseException != null) {
            rootInterfaceImpl.setStatus(1);
        } else {
            rootInterfaceImpl.setStatus(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootInterface getDDRoot(FileObject fileObject) throws IOException {
        Object object;
        if (fileObject == null) {
            return null;
        }
        try {
            object = DataObject.find((FileObject)fileObject);
            if (object instanceof DDProviderDataObject) {
                return this.getDDRoot0((DDProviderDataObject)object, fileObject);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        object = null;
        Object object2 = this.ddMap;
        synchronized (object2) {
            object = this.ddMap.get(fileObject);
            if (object != null) {
                return object;
            }
        }
        fileObject.addFileChangeListener((FileChangeListener)new SunDDFileChangeListener());
        object2 = null;
        try {
            object2 = fileObject.getInputStream();
            DDParse dDParse = new DDParse((InputStream)object2);
            RootInterface rootInterface = dDParse.createProxy();
            Map<Object, RootInterface> map = this.ddMap;
            synchronized (map) {
                object = this.ddMap.get(fileObject);
                if (object == null) {
                    object = rootInterface;
                    this.ddMap.put(fileObject, (RootInterface)object);
                }
            }
        }
        catch (Schema2BeansException schema2BeansException) {
            ErrorManager.getDefault().notify(1, (Throwable)schema2BeansException);
        }
        catch (Schema2BeansRuntimeException schema2BeansRuntimeException) {
            ErrorManager.getDefault().notify(1, (Throwable)schema2BeansRuntimeException);
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            if (object2 != null) {
                try {
                    ((InputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootInterface getDDRoot0(DDProviderDataObject dDProviderDataObject, FileObject fileObject) throws IOException {
        RootInterface rootInterface = null;
        Map<Object, RootInterface> map = this.ddMap;
        synchronized (map) {
            rootInterface = this.ddMap.get(dDProviderDataObject);
            if (rootInterface == null) {
                try {
                    rootInterface = this.getDDRoot(dDProviderDataObject.createReader());
                    if (rootInterface != null) {
                        this.ddMap.put(dDProviderDataObject, rootInterface);
                    }
                }
                catch (Schema2BeansException schema2BeansException) {
                    ErrorManager.getDefault().notify(1, (Throwable)schema2BeansException);
                }
                catch (Schema2BeansRuntimeException schema2BeansRuntimeException) {
                    ErrorManager.getDefault().notify(1, (Throwable)schema2BeansRuntimeException);
                }
                catch (SAXException sAXException) {
                    ErrorManager.getDefault().notify(1, (Throwable)sAXException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            if (rootInterface != null) {
                this.dObjMap.put(fileObject, dDProviderDataObject);
            }
        }
        return rootInterface;
    }

    public RootInterface getDDRoot(Reader reader) throws IOException, SAXException, Schema2BeansException {
        return this.getDDRoot(new InputSource(reader));
    }

    public RootInterface getDDRoot(InputSource inputSource) throws IOException, SAXException, Schema2BeansException {
        return this.getDDRoot(inputSource, null);
    }

    private RootInterface getDDRoot(Reader reader, String string) throws IOException, SAXException, Schema2BeansException {
        return this.getDDRoot(new InputSource(reader), string);
    }

    private RootInterface getDDRoot(InputSource inputSource, String string) throws IOException, SAXException, Schema2BeansException {
        DDParse dDParse = new DDParse(inputSource, string);
        return dDParse.createProxy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RootInterface newGraph(Class clazz, String string) {
        RootInterface rootInterface = null;
        SunBaseBean sunBaseBean = null;
        Object var5_5 = null;
        Map<String, VersionInfo> map = apiToVersionMap.get(clazz);
        if (map == null) throw new IllegalStateException("No version map for " + clazz.getName());
        VersionInfo versionInfo = map.get(string);
        if (versionInfo == null) throw new IllegalStateException("No version information for " + string + " of type " + clazz.getName());
        try {
            sunBaseBean = (SunBaseBean)versionInfo.getImplClass().newInstance();
            sunBaseBean.graphManager().setDoctype(versionInfo.getPublicId(), versionInfo.getSystemId());
            Class clazz2 = versionInfo.getProxyClass();
            Constructor constructor = clazz2.getConstructor(clazz, String.class);
            return (RootInterface)constructor.newInstance(sunBaseBean, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
    }

    private static SunEjbJar createEjbJar(DDParse dDParse) {
        Object var1_1 = null;
        String string = dDParse.getVersion();
        if ("3.10".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_1_0.SunEjbJar(dDParse.getDocument(), 2);
        }
        if ("3.00".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar(dDParse.getDocument(), 2);
        }
        if ("2.11".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar(dDParse.getDocument(), 2);
        }
        if ("2.10".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar(dDParse.getDocument(), 2);
        }
        if ("2.00".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar(dDParse.getDocument(), 2);
        }
        return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar(dDParse.getDocument(), 2);
    }

    private static SunWebApp createWebApp(DDParse dDParse) throws DDException {
        Object var1_1 = null;
        String string = dDParse.getVersion();
        if ("3.00".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_3_0_0.SunWebApp(dDParse.getDocument(), 2);
        }
        if ("2.50".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp(dDParse.getDocument(), 2);
        }
        if ("2.41".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp(dDParse.getDocument(), 2);
        }
        if ("2.40".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp(dDParse.getDocument(), 2);
        }
        if ("2.30".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp(dDParse.getDocument(), 2);
        }
        throw new DDException(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/dd/api/Bundle").getString("MSG_UnknownWebXml"), string));
    }

    private static SunApplication createApplication(DDParse dDParse) {
        SunApplication sunApplication = null;
        String string = dDParse.getVersion();
        if ("6.00".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_6_0_0.SunApplication(dDParse.getDocument(), 2);
        }
        if ("5.00".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication(dDParse.getDocument(), 2);
        }
        if ("1.40".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication(dDParse.getDocument(), 2);
        }
        if ("1.30".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication(dDParse.getDocument(), 2);
        }
        return sunApplication;
    }

    private static SunApplicationClient createApplicationClient(DDParse dDParse) {
        SunApplicationClient sunApplicationClient = null;
        String string = dDParse.getVersion();
        if ("6.00".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_6_0_0.SunApplicationClient(dDParse.getDocument(), 2);
        }
        if ("5.00".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient(dDParse.getDocument(), 2);
        }
        if ("1.41".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient(dDParse.getDocument(), 2);
        }
        if ("1.40".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient(dDParse.getDocument(), 2);
        }
        if ("1.30".equals(string)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient(dDParse.getDocument(), 2);
        }
        return sunApplicationClient;
    }

    public Resources getResourcesGraph() {
        Resources resources = (Resources)this.newGraph(Resources.class, "1.30");
        ResourcesProxy resourcesProxy = new ResourcesProxy(resources);
        return resourcesProxy;
    }

    public Resources getResourcesGraph(InputStream inputStream) {
        org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources resources = org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.createGraph(inputStream);
        ResourcesProxy resourcesProxy = new ResourcesProxy(resources);
        return resourcesProxy;
    }

    private String getPublicIdFromImpl(RootInterfaceImpl rootInterfaceImpl) {
        DocumentType documentType;
        Document document;
        String string = null;
        GraphManager graphManager = rootInterfaceImpl.graphManager();
        if (graphManager != null && (document = graphManager.getXmlDocument()) != null && (documentType = document.getDoctype()) != null) {
            string = documentType.getPublicId();
        }
        return string;
    }

    public void merge(RootInterface rootInterface, Reader reader) {
        RootInterfaceImpl rootInterfaceImpl = (RootInterfaceImpl)((Object)rootInterface);
        try {
            String string = this.getPublicIdFromImpl(rootInterfaceImpl);
            RootInterface rootInterface2 = this.getDDRoot(reader, string);
            RootInterfaceImpl rootInterfaceImpl2 = (RootInterfaceImpl)((Object)rootInterface2);
            if (rootInterface2 == null) {
                rootInterfaceImpl.setStatus(2);
                rootInterfaceImpl.setError(null);
            } else if (rootInterface2.getStatus() == 2) {
                rootInterfaceImpl.setStatus(2);
                rootInterfaceImpl.setError(rootInterfaceImpl2.getError());
            } else {
                rootInterface.merge(rootInterface2, 3);
                rootInterfaceImpl.setStatus(rootInterface2.getStatus());
                rootInterfaceImpl.setError(rootInterfaceImpl2.getError());
            }
        }
        catch (DOMException dOMException) {
            rootInterfaceImpl.setStatus(2);
            rootInterfaceImpl.setError(new SAXParseException(null, null, dOMException));
        }
        catch (SAXParseException sAXParseException) {
            rootInterfaceImpl.setStatus(2);
            rootInterfaceImpl.setError(sAXParseException);
        }
        catch (SAXException sAXException) {
            rootInterfaceImpl.setStatus(2);
            if (sAXException.getException() instanceof SAXParseException) {
                rootInterfaceImpl.setError((SAXParseException)sAXException.getException());
            } else {
                rootInterfaceImpl.setError(new SAXParseException(null, null, sAXException));
            }
        }
        catch (IOException iOException) {
            rootInterfaceImpl.setStatus(2);
        }
        catch (Schema2BeansException schema2BeansException) {
            rootInterfaceImpl.setStatus(2);
            rootInterfaceImpl.setError(new SAXParseException(null, null, (Exception)((Object)schema2BeansException)));
        }
    }

    public static ASDDVersion getASDDVersion(RootInterface rootInterface) {
        return DDProvider.getASDDVersion(rootInterface, null);
    }

    public static ASDDVersion getASDDVersion(RootInterface rootInterface, ASDDVersion aSDDVersion) {
        ASDDVersion aSDDVersion2 = null;
        if (rootInterface instanceof RootInterfaceImpl) {
            RootInterfaceImpl rootInterfaceImpl = (RootInterfaceImpl)((Object)rootInterface);
            aSDDVersion2 = rootInterfaceImpl.getASDDVersion();
        }
        return aSDDVersion2 != null ? aSDDVersion2 : aSDDVersion;
    }

    static {
        sunWebAppVersionMap.put("2.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Servlet 2.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-web-app_2_3-0.dtd"));
        sunWebAppVersionMap.put("2.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 Servlet 2.4//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-0.dtd"));
        sunWebAppVersionMap.put("2.41", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-1.dtd"));
        sunWebAppVersionMap.put("2.50", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Servlet 2.5//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_5-0.dtd"));
        sunWebAppVersionMap.put("3.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_3_0_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Servlet 3.0//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_3_0-0.dtd"));
        sunEjbJarVersionMap.put("2.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_0-0.dtd"));
        sunEjbJarVersionMap.put("2.10", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-0.dtd"));
        sunEjbJarVersionMap.put("2.11", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-1.dtd"));
        sunEjbJarVersionMap.put("3.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 EJB 3.0//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_0-0.dtd"));
        sunEjbJarVersionMap.put("3.10", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_1_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_1-0.dtd"));
        sunApplicationVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_3-0.dtd"));
        sunApplicationVersionMap.put("1.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd"));
        sunApplicationVersionMap.put("5.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Java EE Application 5.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application_5_0-0.dtd"));
        sunApplicationVersionMap.put("6.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_6_0_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Java EE Application 6.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application_6_0-0.dtd"));
        sunAppClientVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client 1.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application-client_1_3-0.dtd"));
        sunAppClientVersionMap.put("1.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 Application Client 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_1_4-0.dtd"));
        sunAppClientVersionMap.put("1.41", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.1 Application Client 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_1_4-1.dtd"));
        sunAppClientVersionMap.put("5.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Application Client 5.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_5_0-0.dtd"));
        sunResourcesVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.class, ResourcesProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN", "http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd"));
        apiToVersionMap.put(SunWebApp.class, sunWebAppVersionMap);
        apiToVersionMap.put(SunEjbJar.class, sunEjbJarVersionMap);
        apiToVersionMap.put(SunApplication.class, sunApplicationVersionMap);
        apiToVersionMap.put(SunApplicationClient.class, sunAppClientVersionMap);
        apiToVersionMap.put(Resources.class, sunResourcesVersionMap);
        publicIdToInfoMap = new HashMap<String, DocTypeInfo>(37);
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", new DocTypeInfo("2.11", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN", new DocTypeInfo("2.10", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 EJB 3.0//EN", new DocTypeInfo("3.00", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_3_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.1.1 EJB 3.0//EN", new DocTypeInfo("3.01", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_1.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_3_0-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 EJB 2.1//EN", new DocTypeInfo("2.10", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN", new DocTypeInfo("2.00", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN", new DocTypeInfo("3.10", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_1_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_3_1-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Servlet 3.0//EN", new DocTypeInfo("3.00", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_3_0_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_3_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Servlet 2.5//EN", new DocTypeInfo("2.50", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_5-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN", new DocTypeInfo("2.41", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 Servlet 2.4//EN", new DocTypeInfo("2.40", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Servlet 2.4//EN", new DocTypeInfo("2.40", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Servlet 2.3//EN", new DocTypeInfo("2.30", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_3-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Java EE Application 5.0//EN", new DocTypeInfo("5.00", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_5_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Java EE Application 6.0//EN", new DocTypeInfo("6.00", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_6_0_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_6_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", new DocTypeInfo("1.40", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 J2EE Application 1.4//EN", new DocTypeInfo("1.40", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN", new DocTypeInfo("1.30", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_3-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Application Client 5.0//EN", new DocTypeInfo("5.00", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_5_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Application Client 6.0//EN", new DocTypeInfo("6.00", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_6_0_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_6_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Application Client 1.4//EN", new DocTypeInfo("1.41", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 Application Client 1.4//EN", new DocTypeInfo("1.40", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Application Client 1.4//EN", new DocTypeInfo("1.40", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client 1.3//EN", new DocTypeInfo("1.30", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_3-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 OR Mapping//EN", new DocTypeInfo("1.2", SunCmpMappingsProxy.class, SunCmpMappings.class, org.netbeans.modules.j2ee.sun.dd.impl.cmp.model_1_2.SunCmpMappings.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-cmp-mapping_1_2.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 OR Mapping//EN", new DocTypeInfo("1.1", SunCmpMappingsProxy.class, SunCmpMappings.class, org.netbeans.modules.j2ee.sun.dd.impl.cmp.model_1_1.SunCmpMappings.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-cmp-mapping_1_1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 OR Mapping //EN", new DocTypeInfo("1.0", SunCmpMappingsProxy.class, SunCmpMappings.class, org.netbeans.modules.j2ee.sun.dd.impl.cmp.model_1_0.SunCmpMappings.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-cmp-mapping_1_0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN", new DocTypeInfo("1.30", ResourcesProxy.class, Resources.class, org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-resources_1_3.dtd"));
    }

    private static class DocTypeInfo {
        private final String version;
        private final Class proxyClass;
        private final Class interfaceClass;
        private final Class implClass;
        private final String resourceDtd;

        public DocTypeInfo(String string, Class clazz, Class clazz2, Class clazz3, String string2) {
            this.version = string;
            this.proxyClass = clazz;
            this.interfaceClass = clazz2;
            this.implClass = clazz3;
            this.resourceDtd = string2;
        }

        public String getVersion() {
            return this.version;
        }

        public String getResourceDtd() {
            return this.resourceDtd;
        }

        public RootInterface createImplementation(Document document) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
            Constructor constructor = this.implClass.getConstructor(Node.class, Integer.TYPE);
            return (RootInterface)constructor.newInstance(document, 2);
        }

        public RootInterfaceImpl createProxy(RootInterface rootInterface) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
            Constructor constructor = this.proxyClass.getConstructor(this.interfaceClass, String.class);
            return (RootInterfaceImpl)constructor.newInstance(this.interfaceClass.cast(rootInterface), this.version);
        }
    }

    private static class DDParse {
        private Document document;
        private SAXParseException saxException;
        private String version;
        private DocTypeInfo documentInfo;

        public DDParse(InputStream inputStream) throws SAXException, IOException {
            this(new InputSource(inputStream));
        }

        public DDParse(Reader reader) throws SAXException, IOException {
            this(new InputSource(reader));
        }

        public DDParse(InputSource inputSource) throws SAXException, IOException {
            this(inputSource, null);
        }

        public DDParse(InputSource inputSource, String string) throws SAXException, IOException {
            try {
                SunDDErrorHandler sunDDErrorHandler = new SunDDErrorHandler();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(sunDDErrorHandler);
                documentBuilder.setEntityResolver(SunDDResolver.getInstance());
                Document document = documentBuilder.parse(inputSource);
                this.initialize(document, sunDDErrorHandler.getError(), string);
            }
            catch (NullPointerException nullPointerException) {
                throw new SAXException(nullPointerException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException.getMessage());
            }
        }

        public DDParse(Document document, SAXParseException sAXParseException) {
            this.initialize(document, sAXParseException, null);
        }

        private void initialize(Document document, SAXParseException sAXParseException, String string) {
            this.document = document;
            this.saxException = sAXParseException;
            this.documentInfo = null;
            this.version = "unknown";
            DocumentType documentType = this.document.getDoctype();
            if (documentType != null) {
                this.documentInfo = (DocTypeInfo)publicIdToInfoMap.get(documentType.getPublicId());
            } else if (string != null) {
                this.documentInfo = (DocTypeInfo)publicIdToInfoMap.get(string);
            }
            if (this.documentInfo != null) {
                this.version = this.documentInfo.getVersion();
            }
        }

        public Document getDocument() {
            return this.document;
        }

        public RootInterface createProxy() throws Schema2BeansException, Schema2BeansRuntimeException {
            RootInterface rootInterface = null;
            if (this.documentInfo != null) {
                try {
                    RootInterface rootInterface2 = this.documentInfo.createImplementation(this.document);
                    RootInterfaceImpl rootInterfaceImpl = this.documentInfo.createProxy(rootInterface2);
                    rootInterfaceImpl.setError(this.saxException);
                    rootInterfaceImpl.setStatus(this.saxException != null ? 1 : 0);
                    rootInterface = rootInterfaceImpl.getRootInterface();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException.getMessage(), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException.getMessage(), illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException;
                    while (((Throwable)throwable).getCause() != null) {
                        throwable = ((Throwable)throwable).getCause();
                    }
                    if (throwable instanceof Schema2BeansException) {
                        throw (Schema2BeansException)throwable;
                    }
                    if (throwable instanceof Schema2BeansRuntimeException) {
                        throw (Schema2BeansRuntimeException)throwable;
                    }
                    throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException.getMessage(), noSuchMethodException);
                }
            }
            return rootInterface;
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class SunDDErrorHandler
    implements ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private SunDDErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class SunDDResolver
    implements EntityResolver {
        static volatile SunDDResolver resolver;

        private SunDDResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static SunDDResolver getInstance() {
            if (resolver != null) return resolver;
            Class<SunDDResolver> clazz = SunDDResolver.class;
            synchronized (SunDDResolver.class) {
                if (resolver != null) return resolver;
                resolver = new SunDDResolver();
                // ** MonitorExit[var0] (shouldn't be in output)
                return resolver;
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = null;
            DocTypeInfo docTypeInfo = (DocTypeInfo)publicIdToInfoMap.get(string);
            if (docTypeInfo != null) {
                String string3 = docTypeInfo.getResourceDtd();
                URL uRL = this.getClass().getResource(string3);
                inputSource = new InputSource(uRL.toString());
            }
            return inputSource;
        }
    }

    private class SunDDFileChangeListener
    extends FileChangeAdapter {
        private SunDDFileChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    RootInterface rootInterface = (RootInterface)DDProvider.this.ddMap.get(fileObject);
                    if (rootInterface != null) {
                        InputStream inputStream = null;
                        try {
                            inputStream = fileObject.getInputStream();
                            String string = EncodingUtil.detectEncoding((InputStream)new BufferedInputStream(inputStream));
                            if (string == null) {
                                string = "UTF8";
                            }
                            DDProvider.this.merge(rootInterface, new InputStreamReader(inputStream, string));
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private static class VersionInfo {
        private Class implClass;
        private Class proxyClass;
        private String publicId;
        private String systemId;

        public VersionInfo(Class clazz, Class clazz2, String string, String string2) {
            this.implClass = clazz;
            this.proxyClass = clazz2;
            this.publicId = string;
            this.systemId = string2;
        }

        public Class getImplClass() {
            return this.implClass;
        }

        public Class getProxyClass() {
            return this.proxyClass;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

