/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.CompilerFlags;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.OptionSource;

public class BasicFlagsPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = -2105207605584107631L;
    private JRadioButton develBuildRB;
    private JRadioButton develDebugCodeRB;
    private JRadioButton develOptDebugCodeRB;
    private JRadioButton finalBuildRB;
    private JCheckBox finalOptTB;
    private JCheckBox finalStripTB;
    private JCheckBox create64BitTB;
    private JCheckBox moduleSupportTB;
    private boolean initialized;

    public BasicFlagsPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_BasicFlagsPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JLabel(this.getString("LBL_BuildMode")), gridBagConstraints);
        this.develBuildRB = new JRadioButton(this.getString("RB_DevelBuild"));
        this.develBuildRB.setSelected(true);
        this.develBuildRB.setMnemonic(this.getString("MNEM_DevelBuild").charAt(0));
        this.add((Component)this.develBuildRB, gridBagConstraints);
        this.develDebugCodeRB = new JRadioButton(this.getString("RB_DebugFlag"));
        this.develDebugCodeRB.setSelected(true);
        this.develDebugCodeRB.setMnemonic(this.getString("MNEM_DebugFlag").charAt(0));
        gridBagConstraints.insets = new Insets(0, 17, 0, 0);
        this.add((Component)this.develDebugCodeRB, gridBagConstraints);
        this.develOptDebugCodeRB = new JRadioButton(this.getString("RB_OptDebugFlag"));
        this.develOptDebugCodeRB.setMnemonic(this.getString("MNEM_OptDebugFlag").charAt(0));
        this.add((Component)this.develOptDebugCodeRB, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.develDebugCodeRB);
        buttonGroup.add(this.develOptDebugCodeRB);
        this.finalBuildRB = new JRadioButton(this.getString("RB_FinalBuild"));
        this.finalBuildRB.setMnemonic(this.getString("MNEM_FinalBuild").charAt(0));
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 0;
        this.add((Component)this.finalBuildRB, gridBagConstraints);
        this.finalOptTB = new JCheckBox(this.getString("TB_OptimizeFlag"));
        this.finalOptTB.setMnemonic(this.getString("MNEM_OptimizeFlag").charAt(0));
        this.finalOptTB.setEnabled(false);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 17;
        this.add((Component)this.finalOptTB, gridBagConstraints);
        this.finalStripTB = new JCheckBox(this.getString("TB_StripFlag"));
        this.finalStripTB.setMnemonic(this.getString("MNEM_StripFlag").charAt(0));
        this.finalStripTB.setEnabled(false);
        this.add((Component)this.finalStripTB, gridBagConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.develBuildRB);
        buttonGroup2.add(this.finalBuildRB);
        this.create64BitTB = new JCheckBox(this.getString("TB_64BitFlag"));
        this.create64BitTB.setMnemonic(this.getString("MNEM_64BitFlag").charAt(0));
        gridBagConstraints.insets.top = 11;
        gridBagConstraints.insets.left = 0;
        this.add((Component)this.create64BitTB, gridBagConstraints);
        this.moduleSupportTB = new JCheckBox(this.getString("TB_EnableModuleSupport"));
        this.moduleSupportTB.setMnemonic(this.getString("MNEM_EnableModuleSupport").charAt(0));
        gridBagConstraints.insets.top = 5;
        this.add((Component)this.moduleSupportTB, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
        this.develBuildRB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (BasicFlagsPanel.this.develBuildRB.isSelected()) {
                    BasicFlagsPanel.this.develDebugCodeRB.setEnabled(true);
                    BasicFlagsPanel.this.develOptDebugCodeRB.setEnabled(true);
                } else {
                    BasicFlagsPanel.this.develDebugCodeRB.setEnabled(false);
                    BasicFlagsPanel.this.develOptDebugCodeRB.setEnabled(false);
                }
            }
        });
        this.finalBuildRB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (BasicFlagsPanel.this.finalBuildRB.isSelected()) {
                    BasicFlagsPanel.this.finalOptTB.setEnabled(true);
                    BasicFlagsPanel.this.finalStripTB.setEnabled(true);
                } else {
                    BasicFlagsPanel.this.finalOptTB.setEnabled(false);
                    BasicFlagsPanel.this.finalStripTB.setEnabled(false);
                }
            }
        });
    }

    public void addNotify() {
        CompilerFlags compilerFlags = this.getMakefileData().getCompilerFlags();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (compilerFlags.getOptionSource() == OptionSource.DEVELOPMENT) {
            this.develBuildRB.setSelected(true);
        } else {
            this.finalBuildRB.setSelected(true);
        }
        this.finalOptTB.setSelected(compilerFlags.isFinalOptimize());
        this.finalStripTB.setSelected(compilerFlags.isFinalStrip());
        this.develDebugCodeRB.setSelected(compilerFlags.isDevelDebug());
        this.create64BitTB.setSelected(compilerFlags.is64Bit());
        this.moduleSupportTB.setSelected(this.getMakefileData().isModuleEnabled());
        if (this.getMakefileData().getToolset() == 1) {
            this.getMakefileData().setModuleEnabled(false);
            this.moduleSupportTB.setEnabled(false);
        }
        IpeUtils.requestFocus(this.develBuildRB);
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        CompilerFlags compilerFlags = this.getMakefileData().getCompilerFlags();
        if (this.develBuildRB.isSelected()) {
            compilerFlags.setOptionSource(OptionSource.DEVELOPMENT);
        } else {
            compilerFlags.setOptionSource(OptionSource.FINAL);
        }
        compilerFlags.setFinalOptimize(this.finalOptTB.isSelected());
        compilerFlags.setFinalStrip(this.finalStripTB.isSelected());
        compilerFlags.setDevelDebug(this.develDebugCodeRB.isSelected());
        compilerFlags.set64Bit(this.create64BitTB.isSelected());
        this.getMakefileData().setModuleEnabled(this.moduleSupportTB.isSelected());
    }
}

