/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.execution.ErrorParserProvider;
import org.netbeans.modules.cnd.execution.impl.ErrorParser;
import org.netbeans.modules.cnd.execution.impl.OutputListenerImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;

public final class SUNErrorParser
extends ErrorParser {
    private final List<Pattern> errorScuners = new ArrayList<Pattern>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private final List<String> severity = new ArrayList<String>();
    private final List<Pattern> SunStudioOutputFilters = new ArrayList<Pattern>();
    private Pattern SUN_DIRECTORY_ENTER;

    public SUNErrorParser(CompilerSet.CompilerFlavor compilerFlavor, ExecutionEnvironment executionEnvironment, FileObject fileObject) {
        super(executionEnvironment, fileObject);
        this.init(compilerFlavor);
    }

    private void init(CompilerSet.CompilerFlavor compilerFlavor) {
        ToolchainManager.ScannerDescriptor scannerDescriptor = compilerFlavor.getToolchainDescriptor().getScanner();
        for (ToolchainManager.ScannerPattern object : scannerDescriptor.getPatterns()) {
            Pattern pattern = Pattern.compile(object.getPattern());
            this.patterns.add(pattern);
            this.severity.add(object.getSeverity());
            this.errorScuners.add(pattern);
        }
        if (scannerDescriptor.getEnterDirectoryPattern() != null) {
            this.SUN_DIRECTORY_ENTER = Pattern.compile(scannerDescriptor.getEnterDirectoryPattern());
            this.patterns.add(this.SUN_DIRECTORY_ENTER);
        }
        for (String string : scannerDescriptor.getFilterOutPatterns()) {
            this.SunStudioOutputFilters.add(Pattern.compile(string));
        }
    }

    public ErrorParserProvider.Result handleLine(String string) throws IOException {
        ErrorParserProvider.Result result = this.handleLineImpl(string);
        if (result == null || result == ErrorParserProvider.NO_RESULT) {
            for (Pattern pattern : this.SunStudioOutputFilters) {
                Matcher matcher = pattern.matcher(string);
                boolean bl = matcher.find();
                if (!bl || matcher.start() != 0) continue;
                return ErrorParserProvider.REMOVE_LINE;
            }
        }
        return result;
    }

    private ErrorParserProvider.Result handleLineImpl(String string) throws IOException {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(string);
            boolean bl = matcher.find();
            if (!bl || matcher.start() != 0) continue;
            return this.handleLine(string, matcher);
        }
        return null;
    }

    private ErrorParserProvider.Result handleLine(String string, Matcher matcher) throws IOException {
        if (matcher.pattern() == this.SUN_DIRECTORY_ENTER) {
            FileObject fileObject = this.resolveFile(matcher.group(1));
            if (fileObject != null) {
                this.relativeTo = fileObject;
            }
            return ErrorParserProvider.NO_RESULT;
        }
        int n = this.errorScuners.indexOf(matcher.pattern());
        if (n >= 0) {
            try {
                String string2 = matcher.group(1);
                Integer n2 = Integer.valueOf(matcher.group(2));
                FileObject fileObject = this.resolveRelativePath(this.relativeTo, string2);
                boolean bl = this.severity.get(n).equals("error");
                if (fileObject != null) {
                    return new ErrorParserProvider.Results(string, new OutputListenerImpl(fileObject, n2 - 1, bl));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return ErrorParserProvider.NO_RESULT;
        }
        throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
    }
}

