/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.projects;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.config.ConfigSupportImpl;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.projects.J2eeModuleProviderAccessor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class DeploymentTargetImpl
implements DeploymentTarget {
    private final J2eeModuleProvider moduleProvider;
    private final String clientName;
    private ServerString server;
    private TargetModule[] targetModules;

    public DeploymentTargetImpl(J2eeModuleProvider j2eeModuleProvider, String string) {
        this.moduleProvider = j2eeModuleProvider;
        this.clientName = string;
    }

    public J2eeModule getModule() {
        return this.moduleProvider.getJ2eeModule();
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this.moduleProvider.getModuleChangeReporter();
    }

    public ResourceChangeReporter getResourceChangeReporter() {
        return this.moduleProvider.getResourceChangeReporter();
    }

    public String getClientUrl(String string) {
        J2eeModule j2eeModule = null;
        String string2 = null;
        if (this.moduleProvider instanceof J2eeApplicationProvider) {
            J2eeApplicationProvider j2eeApplicationProvider = (J2eeApplicationProvider)this.moduleProvider;
            J2eeModuleProvider j2eeModuleProvider = this.getChildModuleProvider(j2eeApplicationProvider, this.clientName);
            if (j2eeModuleProvider != null) {
                j2eeModule = j2eeModuleProvider.getJ2eeModule();
            } else {
                J2eeApplication j2eeApplication = (J2eeApplication)j2eeApplicationProvider.getJ2eeModule();
                J2eeModule[] j2eeModuleArray = j2eeApplication.getModules();
                for (int i = 0; i < j2eeModuleArray.length; ++i) {
                    if (!J2eeModule.Type.WAR.equals(j2eeModuleArray[i].getType())) continue;
                    j2eeModule = j2eeModuleArray[i];
                    break;
                }
            }
        } else {
            j2eeModule = this.moduleProvider.getJ2eeModule();
        }
        if (j2eeModule != null && j2eeModule.getType().equals(J2eeModule.Type.WAR)) {
            string2 = this.findWebUrl(j2eeModule);
            if (string2 != null) {
                if (string.startsWith("/")) {
                    return string2 + string;
                }
                return string2 + "/" + string;
            }
            return null;
        }
        return null;
    }

    private J2eeModuleProvider getChildModuleProvider(J2eeModuleProvider j2eeModuleProvider, String string) {
        J2eeApplicationProvider j2eeApplicationProvider;
        if (string == null) {
            return null;
        }
        J2eeModuleProvider j2eeModuleProvider2 = null;
        if (j2eeModuleProvider instanceof J2eeApplicationProvider && (j2eeModuleProvider2 = (j2eeApplicationProvider = (J2eeApplicationProvider)j2eeModuleProvider).getChildModuleProvider(string)) == null) {
            String string2 = "/";
            string = string.startsWith(string2) ? string.substring(1) : string2 + string;
            j2eeModuleProvider2 = j2eeApplicationProvider.getChildModuleProvider(string);
        }
        return j2eeModuleProvider2;
    }

    private TargetModule getTargetModule() {
        TargetModule[] targetModuleArray = this.getTargetModules();
        if (targetModuleArray == null || targetModuleArray.length == 0) {
            return null;
        }
        if (targetModuleArray[0].delegate() != null) {
            return targetModuleArray[0];
        }
        targetModuleArray[0].initDelegate(J2eeModuleAccessor.getDefault().getJsrModuleType(this.getModule().getType()));
        return targetModuleArray[0];
    }

    private String findWebUrl(J2eeModule j2eeModule) {
        String string;
        TargetModule targetModule = this.getTargetModule();
        if (targetModule == null) {
            return null;
        }
        if (this.getModule() == j2eeModule) {
            return targetModule.getWebURL();
        }
        ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(targetModule.getInstanceUrl());
        IncrementalDeployment incrementalDeployment = serverInstance.getIncrementalDeployment();
        String string2 = string = j2eeModule == null ? "" : j2eeModule.getUrl();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        TargetModuleID[] targetModuleIDArray = targetModule.getChildTargetModuleID();
        String string3 = null;
        TargetModuleID targetModuleID = null;
        for (int i = 0; targetModuleIDArray != null && i < targetModuleIDArray.length; ++i) {
            if (string3 == null || string3.trim().equals("")) {
                string3 = targetModuleIDArray[i].getWebURL();
            }
            String string4 = targetModuleIDArray[i].getModuleID();
            if (incrementalDeployment != null) {
                string4 = incrementalDeployment.getModuleUrl(targetModuleIDArray[i]);
            } else {
                int n = string4.indexOf(35);
                if (n > -1) {
                    string4 = string4.substring(n + 1);
                }
            }
            if (incrementalDeployment == null || !string.equalsIgnoreCase(string4)) continue;
            targetModuleID = targetModuleIDArray[i];
            break;
        }
        if (targetModuleID != null) {
            string3 = targetModuleID.getWebURL();
        }
        return string3;
    }

    public File getConfigurationFile() {
        return J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider).getConfigurationFile();
    }

    public ServerString getServer() {
        if (this.server == null) {
            String string = this.moduleProvider.getServerInstanceID();
            ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
            if (serverInstance == null) {
                throw new RuntimeException(NbBundle.getMessage(DeploymentTargetImpl.class, (String)"MSG_TargetServerNotFound", (Object)string));
            }
            this.server = new ServerString(serverInstance);
        }
        return this.server;
    }

    public TargetModule[] getTargetModules() {
        if (this.targetModules == null || this.targetModules.length == 0) {
            String string = this.getTargetModuleFileName();
            if (string == null) {
                return null;
            }
            this.targetModules = TargetModule.load(this.getServer(), string);
        }
        return (TargetModule[])this.targetModules.clone();
    }

    public void setTargetModules(TargetModule[] targetModuleArray) {
        this.targetModules = (TargetModule[])targetModuleArray.clone();
        for (int i = 0; i < targetModuleArray.length; ++i) {
            String string = this.getTargetModuleFileName();
            if (string == null) continue;
            targetModuleArray[i].updateTimestamp();
            targetModuleArray[i].save(string);
        }
    }

    public ModuleConfigurationProvider getModuleConfigurationProvider() {
        return J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider);
    }

    public J2eeModuleProvider.ConfigSupport getConfigSupport() {
        return this.moduleProvider.getConfigSupport();
    }

    private String getTargetModuleFileName() {
        Object object;
        ConfigSupportImpl configSupportImpl = J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider);
        FileObject fileObject = configSupportImpl.getProjectDirectory();
        if (fileObject != null && (object = FileUtil.toFile((FileObject)fileObject)) != null) {
            return TargetModule.shortNameFromPath(((File)object).getAbsolutePath());
        }
        try {
            if (this.getModule().getContentDirectory() != null && (object = FileUtil.toFile((FileObject)this.getModule().getContentDirectory())) != null) {
                return TargetModule.shortNameFromPath(((File)object).getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        object = this.moduleProvider.getDeploymentName();
        if (object != null) {
            return object;
        }
        return J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider).getDeploymentName();
    }

    public String getDeploymentName() {
        return this.moduleProvider.getDeploymentName();
    }
}

