/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.modules.editor.lib2.highlighting.OffsetGapList;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.WeakListeners;

public final class CompoundHighlightsContainer
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(CompoundHighlightsContainer.class.getName());
    private static final int MIN_CACHE_SIZE = 128;
    private Document doc;
    private HighlightsContainer[] layers;
    private boolean[] blacklisted;
    private long version = 0L;
    private final Object LOCK = new String("CompoundHighlightsContainer.LOCK");
    private final LayerListener listener = new LayerListener(this);
    private OffsetsBag cache;
    private boolean cacheObsolete;
    private CacheBoundaries cacheBoundaries;

    public CompoundHighlightsContainer() {
        this(null, null);
    }

    public CompoundHighlightsContainer(Document document, HighlightsContainer[] highlightsContainerArray) {
        this.setLayers(document, highlightsContainerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        assert (0 <= n) : "offsets must be greater than or equal to zero";
        assert (n <= n2) : "startOffset must be less than or equal to endOffset; startOffset = " + n + " endOffset = " + n2;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.doc == null || this.layers == null || this.layers.length == 0 || n == n2) {
                return HighlightsSequence.EMPTY;
            }
            int[] nArray = null;
            int n3 = this.cacheBoundaries.getLowerBoundary();
            int n4 = this.cacheBoundaries.getUpperBoundary();
            if (this.cacheObsolete) {
                this.cacheObsolete = false;
                this.discardCache();
            } else if (n3 == -1 || n4 == -1) {
                this.discardCache();
            } else if (n2 <= n4 && n < n3) {
                nArray = new int[]{CompoundHighlightsContainer.expandBelow(n, n3), n3};
            } else if (n >= n3 && n2 > n4) {
                nArray = new int[]{n4, CompoundHighlightsContainer.expandAbove(n4, n2)};
            } else if (n < n3 && n2 > n4) {
                nArray = new int[]{CompoundHighlightsContainer.expandBelow(n, n3), n3, n4, CompoundHighlightsContainer.expandAbove(n4, n2)};
            } else if (n < n3 || n2 > n4) {
                this.discardCache();
            }
            OffsetsBag offsetsBag = this.cache;
            if (offsetsBag == null) {
                this.cache = offsetsBag = new OffsetsBag(this.doc, true);
                n4 = -1;
                n3 = -1;
                nArray = new int[]{CompoundHighlightsContainer.expandBelow(n, n2), CompoundHighlightsContainer.expandAbove(n, n2)};
            }
            if (nArray != null) {
                int n5;
                for (n5 = 0; n5 < nArray.length / 2; ++n5) {
                    if (nArray[2 * n5 + 1] >= this.doc.getLength()) {
                        nArray[2 * n5 + 1] = Integer.MAX_VALUE;
                    }
                    this.updateCache(nArray[2 * n5], nArray[2 * n5 + 1], offsetsBag);
                    if (nArray[2 * n5 + 1] == Integer.MAX_VALUE) break;
                }
                if (n3 == -1 || n4 == -1) {
                    this.cacheBoundaries.setBoundaries(nArray[0], nArray[nArray.length - 1]);
                } else {
                    this.cacheBoundaries.setBoundaries(Math.min(n3, nArray[0]), Math.max(n4, nArray[nArray.length - 1]));
                }
                if (LOG.isLoggable(Level.FINE)) {
                    n5 = this.cacheBoundaries.getLowerBoundary();
                    int n6 = this.cacheBoundaries.getUpperBoundary();
                    LOG.fine("Cache boundaries: <" + (n5 == -1 ? "-" : Integer.valueOf(n5)) + ", " + (n6 == -1 ? "-" : Integer.valueOf(n6)) + "> " + "when asked for <" + n + ", " + n2 + ">");
                }
            }
            return new Seq(this.version, offsetsBag.getHighlights(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsContainer[] getLayers() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.layers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayers(Document document, HighlightsContainer[] highlightsContainerArray) {
        Document document2 = null;
        Object object = this.LOCK;
        synchronized (object) {
            int n;
            if (document == null) assert (highlightsContainerArray == null) : "If doc is null the layers must be null too.";
            Document document3 = document2 = document != null ? document : this.doc;
            if (this.layers != null) {
                for (n = 0; n < this.layers.length; ++n) {
                    this.layers[n].removeHighlightsChangeListener(this.listener);
                }
            }
            this.doc = document;
            this.layers = highlightsContainerArray;
            this.blacklisted = highlightsContainerArray == null ? null : new boolean[highlightsContainerArray.length];
            this.cacheObsolete = true;
            this.cacheBoundaries = document == null ? null : new CacheBoundaries(document);
            this.increaseVersion();
            if (this.layers != null) {
                for (n = 0; n < this.layers.length; ++n) {
                    this.layers[n].addHighlightsChangeListener(this.listener);
                }
            }
        }
        if (document2 != null) {
            document2.render(new Runnable(){

                public void run() {
                    CompoundHighlightsContainer.this.fireHighlightsChange(0, Integer.MAX_VALUE);
                }
            });
        }
    }

    public void resetCache() {
        this.layerChanged(null, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layerChanged(HighlightsContainer highlightsContainer, final int n, final int n2) {
        Document document = null;
        Object object = this.LOCK;
        synchronized (object) {
            LOG.fine("Cache obsoleted by changes in " + highlightsContainer);
            this.cacheObsolete = true;
            this.increaseVersion();
            document = this.doc;
        }
        if (document != null) {
            document.render(new Runnable(){

                public void run() {
                    CompoundHighlightsContainer.this.fireHighlightsChange(n, n2);
                }
            });
        }
    }

    private void updateCache(final int n, final int n2, OffsetsBag offsetsBag) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating cache: <" + n + ", " + n2 + ">");
        }
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.blacklisted[i]) continue;
            try {
                final HighlightsSequence highlightsSequence = this.layers[i].getHighlights(n, n2);
                final int n3 = i;
                final HighlightsContainer highlightsContainer = this.layers[i];
                offsetsBag.addAllHighlights(new HighlightsSequence(){
                    int start = -1;
                    int end = -1;

                    public boolean moveNext() {
                        boolean bl;
                        boolean bl2 = bl = highlightsSequence.moveNext();
                        while (bl2) {
                            this.start = highlightsSequence.getStartOffset();
                            this.end = highlightsSequence.getEndOffset();
                            if (this.start > this.end) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "Layer[" + n3 + "]=" + highlightsContainer + " supplied invalid highlight " + CompoundHighlightsContainer.dumpHighlight(highlightsSequence, null) + ", requested range <" + n + ", " + n2 + ">." + " Highlight ignored.");
                                }
                                bl2 = bl = highlightsSequence.moveNext();
                                continue;
                            }
                            if (this.start > n2 || this.end < n) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "Layer[" + n3 + "]=" + highlightsContainer + " supplied highlight " + CompoundHighlightsContainer.dumpHighlight(highlightsSequence, null) + ", which is outside of the requested range <" + n + ", " + n2 + ">." + " Highlight skipped.");
                                }
                                bl2 = bl = highlightsSequence.moveNext();
                                continue;
                            }
                            bl2 = false;
                        }
                        if (bl) {
                            boolean bl3 = false;
                            if (this.start < n) {
                                this.start = n;
                                bl3 = true;
                            }
                            if (this.end > n2) {
                                this.end = n2;
                                bl3 = true;
                            }
                            if (bl3 && LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Layer[" + n3 + "]=" + highlightsContainer + " supplied unclipped highlight " + CompoundHighlightsContainer.dumpHighlight(highlightsSequence, null) + ", requested range <" + n + ", " + n2 + ">." + " Highlight clipped.");
                            }
                        }
                        return bl;
                    }

                    public int getStartOffset() {
                        return this.start;
                    }

                    public int getEndOffset() {
                        return this.end;
                    }

                    public AttributeSet getAttributes() {
                        return highlightsSequence.getAttributes();
                    }
                });
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine(CompoundHighlightsContainer.dumpLayerHighlights(this.layers[i], n, n2));
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.blacklisted[i] = true;
                LOG.log(Level.WARNING, "The layer failed to supply highlights: " + this.layers[i], throwable);
            }
        }
    }

    private void increaseVersion() {
        ++this.version;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("CHC@" + Integer.toHexString(System.identityHashCode(this)) + ", OB@" + (this.cache == null ? "null" : Integer.toHexString(System.identityHashCode(this.cache))) + ", doc@" + Integer.toHexString(System.identityHashCode(this.doc)) + " version=" + this.version);
        }
    }

    private void discardCache() {
        if (this.cache != null) {
            this.cache.discard();
        }
        this.cache = null;
    }

    private static int expandBelow(int n, int n2) {
        if (n == 0 || n2 == Integer.MAX_VALUE) {
            return n;
        }
        int n3 = Math.max(n2 - n >> 2, 128);
        return Math.max(n - n3, 0);
    }

    private static int expandAbove(int n, int n2) {
        if (n2 == Integer.MAX_VALUE) {
            return n2;
        }
        int n3 = Math.max(n2 - n >> 2, 128);
        return n2 + n3;
    }

    private static String dumpLayerHighlights(HighlightsContainer highlightsContainer, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Highlights in " + highlightsContainer + ": {\n");
        HighlightsSequence highlightsSequence = highlightsContainer.getHighlights(n, n2);
        while (highlightsSequence.moveNext()) {
            stringBuilder.append("  ");
            CompoundHighlightsContainer.dumpHighlight(highlightsSequence, stringBuilder);
            stringBuilder.append("\n");
        }
        stringBuilder.append("} End of Highlights in " + highlightsContainer);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static StringBuilder dumpHighlight(HighlightsSequence highlightsSequence, StringBuilder stringBuilder) {
        stringBuilder.append("<");
        stringBuilder.append(highlightsSequence.getStartOffset());
        stringBuilder.append(", ");
        stringBuilder.append(highlightsSequence.getEndOffset());
        stringBuilder.append(", ");
        stringBuilder.append(highlightsSequence.getAttributes().getAttribute(StyleConstants.NameAttribute));
        stringBuilder.append(">");
        return stringBuilder;
    }

    private static final class CacheBoundaries
    implements DocumentListener {
        private final OffsetGapList<OffsetGapList.Offset> boundaries = new OffsetGapList(false);
        private final Document doc;

        public CacheBoundaries(Document document) {
            this.doc = document;
            this.doc.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)this.doc));
        }

        public int getLowerBoundary() {
            if (this.boundaries.size() == 2) {
                return ((OffsetGapList.Offset)this.boundaries.get(0)).getOffset();
            }
            return -1;
        }

        public int getUpperBoundary() {
            if (this.boundaries.size() == 2) {
                OffsetGapList.Offset offset = (OffsetGapList.Offset)this.boundaries.get(1);
                return offset.getOffset() >= this.doc.getLength() ? Integer.MAX_VALUE : offset.getOffset();
            }
            return -1;
        }

        public void setBoundaries(int n, int n2) {
            this.boundaries.clear();
            this.boundaries.add(new OffsetGapList.Offset(n));
            this.boundaries.add(new OffsetGapList.Offset(Math.min(n2, this.doc.getLength() + 1)));
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.boundaries.defaultInsertUpdate(documentEvent.getOffset(), documentEvent.getLength());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.boundaries.defaultRemoveUpdate(documentEvent.getOffset(), documentEvent.getLength());
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private final class Seq
    implements HighlightsSequence {
        private HighlightsSequence seq;
        private long version;
        private int startOffset = -1;
        private int endOffset = -1;
        private AttributeSet attibutes = null;

        public Seq(long l, HighlightsSequence highlightsSequence) {
            this.version = l;
            this.seq = highlightsSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            Object object = CompoundHighlightsContainer.this.LOCK;
            synchronized (object) {
                if (this.checkVersion() && this.seq.moveNext()) {
                    this.startOffset = this.seq.getStartOffset();
                    this.endOffset = this.seq.getEndOffset();
                    this.attibutes = this.seq.getAttributes();
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            Object object = CompoundHighlightsContainer.this.LOCK;
            synchronized (object) {
                assert (this.startOffset != -1) : "Sequence not initialized, call moveNext() first.";
                return this.startOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            Object object = CompoundHighlightsContainer.this.LOCK;
            synchronized (object) {
                assert (this.endOffset != -1) : "Sequence not initialized, call moveNext() first.";
                return this.endOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            Object object = CompoundHighlightsContainer.this.LOCK;
            synchronized (object) {
                assert (this.attibutes != null) : "Sequence not initialized, call moveNext() first.";
                return this.attibutes;
            }
        }

        private boolean checkVersion() {
            return this.version == CompoundHighlightsContainer.this.version;
        }
    }

    private static final class LayerListener
    implements HighlightsChangeListener {
        private WeakReference<CompoundHighlightsContainer> ref;

        public LayerListener(CompoundHighlightsContainer compoundHighlightsContainer) {
            this.ref = new WeakReference<CompoundHighlightsContainer>(compoundHighlightsContainer);
        }

        public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
            CompoundHighlightsContainer compoundHighlightsContainer = (CompoundHighlightsContainer)this.ref.get();
            if (compoundHighlightsContainer != null) {
                compoundHighlightsContainer.layerChanged((HighlightsContainer)highlightsChangeEvent.getSource(), highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
            }
        }
    }
}

