/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.search.BufferedCharSequence;
import org.netbeans.modules.search.RegexpMaker;
import org.netbeans.modules.search.TextDetail;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openidex.search.SearchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasicSearchCriteria {
    private static final int MAX_UNRECOGNIZED_FILE_SIZE = 0x500000;
    private static int instanceCounter;
    private final int instanceId = instanceCounter++;
    private static final Logger LOG;
    private static final Collection<String> searchableXMimeTypes;
    private String textPatternExpr;
    private String fileNamePatternExpr;
    private String replaceExpr;
    private String replaceString;
    private boolean wholeWords;
    private boolean caseSensitive;
    private boolean regexp;
    private boolean textPatternSpecified = false;
    private boolean fileNamePatternSpecified = false;
    private boolean textPatternValid = false;
    private boolean replacePatternValid = false;
    private boolean fileNamePatternValid = false;
    private Pattern textPattern;
    private Pattern fileNamePattern;
    private boolean criteriaUsable = false;
    private ChangeListener usabilityChangeListener;
    private static Pattern patternCR;
    private static Pattern patternLineSeparator;
    private Charset lastCharset = null;
    private Map<DataObject, List<TextDetail>> detailsMap;
    private DataObject dataObject;

    BasicSearchCriteria() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": <init>()");
        }
    }

    BasicSearchCriteria(BasicSearchCriteria basicSearchCriteria) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": <init>(template)");
        }
        this.setCaseSensitive(basicSearchCriteria.caseSensitive);
        this.setWholeWords(basicSearchCriteria.wholeWords);
        this.setRegexp(basicSearchCriteria.regexp);
        this.setTextPattern(basicSearchCriteria.textPatternExpr);
        this.setFileNamePattern(basicSearchCriteria.fileNamePatternExpr);
        this.setReplaceExpr(basicSearchCriteria.replaceExpr);
    }

    Pattern getTextPattern() {
        if (!this.textPatternValid) {
            return null;
        }
        if (this.textPattern != null) {
            return this.textPattern;
        }
        if (this.regexp) {
            this.textPatternValid = this.compileRegexpPattern();
        } else {
            this.compileSimpleTextPattern();
            boolean bl = this.textPatternValid = this.textPattern != null;
        }
        assert (this.textPattern != null);
        return this.textPattern;
    }

    String getTextPatternExpr() {
        return this.textPatternExpr != null ? this.textPatternExpr : "";
    }

    void setTextPattern(String string) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setTextPattern(" + string + ')');
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null && this.textPatternExpr == null || string != null && string.equals(this.textPatternExpr)) {
            LOG.finest(" - no change");
            return;
        }
        if (string == null) {
            this.textPatternExpr = null;
            this.textPattern = null;
            this.textPatternSpecified = false;
            this.textPatternValid = false;
        } else {
            this.textPatternExpr = string;
            this.textPatternSpecified = true;
            if (!this.regexp) {
                this.textPattern = null;
                this.textPatternValid = true;
            } else {
                this.textPatternValid = this.compileRegexpPattern();
                assert (this.textPattern != null || !this.textPatternValid);
            }
        }
        this.replacePatternValid = this.validateReplacePattern();
        this.updateUsability();
    }

    private boolean compileRegexpPattern() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": compileRegexpPattern()");
        }
        assert (this.regexp);
        assert (this.textPatternExpr != null);
        try {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - textPatternExpr = \"" + this.textPatternExpr + '\"');
            }
            int n = 0;
            if (!this.caseSensitive) {
                n |= 2;
                n |= 0x40;
            }
            this.textPattern = Pattern.compile(this.textPatternExpr, n);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LOG.finest(" - invalid regexp - setting 'textPattern' to <null>");
            this.textPattern = null;
            return false;
        }
    }

    private boolean validateReplacePattern() {
        if (this.regexp && this.textPatternValid) {
            int n = this.getTextPattern().matcher("").groupCount();
            String string = "";
            for (int i = 1; i <= n; ++i) {
                string = string + "(" + i + ")";
            }
            try {
                Pattern.compile(string).matcher("123456789").replaceFirst(this.replaceExpr);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private void compileSimpleTextPattern() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": compileRegexpPattern()");
        }
        assert (this.textPatternExpr != null);
        try {
            int n = 0;
            if (!this.caseSensitive) {
                n |= 2;
                n |= 0x40;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - textPatternExpr = \"" + this.textPatternExpr + '\"');
            }
            String string = RegexpMaker.makeRegexp(this.textPatternExpr, this.wholeWords);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - regexp = \"" + string + '\"');
            }
            this.textPattern = Pattern.compile(string, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LOG.finest(" - invalid regexp");
            assert (false);
            this.textPattern = null;
        }
    }

    boolean isRegexp() {
        return this.regexp;
    }

    void setRegexp(boolean bl) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setRegexp(" + bl + ')');
        }
        if (bl == this.regexp) {
            LOG.finest(" - no change");
            return;
        }
        this.regexp = bl;
        if (this.textPatternExpr != null) {
            if (bl) {
                this.textPatternValid = this.compileRegexpPattern();
            } else {
                this.textPatternValid = true;
                this.textPattern = null;
            }
        }
        this.replacePatternValid = this.validateReplacePattern();
        this.updateUsability();
    }

    boolean isWholeWords() {
        return this.wholeWords;
    }

    void setWholeWords(boolean bl) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setWholeWords(" + bl + ')');
        }
        if (bl == this.wholeWords) {
            LOG.finest(" - no change");
            return;
        }
        this.wholeWords = bl;
        if (!this.regexp) {
            this.textPattern = null;
        }
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean bl) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setCaseSensitive(" + bl + ')');
        }
        if (bl == this.caseSensitive) {
            LOG.finest(" - no change");
            return;
        }
        this.caseSensitive = bl;
        this.textPattern = null;
    }

    boolean isFullText() {
        return this.textPatternValid;
    }

    Pattern getFileNamePattern() {
        if (!this.fileNamePatternValid) {
            return null;
        }
        assert (this.fileNamePatternExpr != null && this.fileNamePatternExpr.length() != 0);
        if (this.fileNamePattern != null) {
            return this.fileNamePattern;
        }
        this.compileSimpleFileNamePattern();
        assert (this.fileNamePattern != null);
        return this.fileNamePattern;
    }

    String getFileNamePatternExpr() {
        return this.fileNamePatternExpr != null ? this.fileNamePatternExpr : "";
    }

    void setFileNamePattern(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null && this.fileNamePatternExpr == null || string != null && string.equals(this.fileNamePatternExpr)) {
            return;
        }
        if (string == null) {
            this.fileNamePatternExpr = null;
            this.fileNamePattern = null;
            this.fileNamePatternSpecified = false;
            this.fileNamePatternValid = false;
        } else {
            this.fileNamePatternExpr = string;
            this.fileNamePattern = null;
            this.fileNamePatternValid = this.fileNamePatternSpecified = BasicSearchCriteria.checkFileNamePattern(this.fileNamePatternExpr);
        }
        this.updateUsability();
    }

    private void compileSimpleFileNamePattern() {
        assert (this.fileNamePatternExpr != null);
        try {
            this.fileNamePattern = Pattern.compile(RegexpMaker.makeMultiRegexp(this.fileNamePatternExpr), 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            assert (false);
            this.fileNamePattern = null;
        }
    }

    private static boolean checkFileNamePattern(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (c == ',' || c == ' ') continue;
            return true;
        }
        return false;
    }

    boolean isSearchAndReplace() {
        return this.replaceExpr != null;
    }

    String getReplaceExpr() {
        return this.replaceExpr;
    }

    String getReplaceString() {
        if (this.replaceString == null && this.replaceExpr != null) {
            String[] stringArray = this.replaceExpr.split("\\\\\\\\", this.replaceExpr.length());
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                string2 = string2.replace("\\r", "\r");
                string2 = string2.replace("\\n", "\n");
                string2 = string2.replace("\\t", "\t");
                string = string + string2;
                if (i == stringArray.length - 1) continue;
                string = string + "\\\\";
            }
            this.replaceString = string;
        }
        return this.replaceString;
    }

    void setReplaceExpr(String string) {
        this.replaceExpr = string;
        this.replaceString = null;
        this.replacePatternValid = this.validateReplacePattern();
    }

    private void updateUsability() {
        boolean bl = this.criteriaUsable;
        this.criteriaUsable = this.isUsable();
        if (this.criteriaUsable != bl) {
            this.fireUsabilityChanged();
        }
    }

    boolean isUsable() {
        return (this.textPatternSpecified || !this.isSearchAndReplace() && this.fileNamePatternSpecified) && !this.isInvalid();
    }

    private boolean isInvalid() {
        return this.isTextPatternInvalid() || this.isFileNamePatternInvalid();
    }

    void setUsabilityChangeListener(ChangeListener changeListener) {
        this.usabilityChangeListener = changeListener;
    }

    private void fireUsabilityChanged() {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    boolean isTextPatternUsable() {
        return this.textPatternSpecified && this.textPatternValid;
    }

    boolean isTextPatternInvalid() {
        return this.textPatternSpecified && !this.textPatternValid;
    }

    boolean isReplacePatternInvalid() {
        return !this.replacePatternValid;
    }

    boolean isFileNamePatternUsable() {
        return this.fileNamePatternSpecified && this.fileNamePatternValid;
    }

    boolean isFileNamePatternInvalid() {
        return this.fileNamePatternSpecified && !this.fileNamePatternValid;
    }

    void onOk() {
        LOG.finer("onOk()");
        if (this.textPatternValid && this.textPattern == null) {
            if (this.regexp) {
                this.compileRegexpPattern();
            } else {
                this.compileSimpleTextPattern();
            }
        }
        if (this.fileNamePatternValid && this.fileNamePattern == null) {
            this.compileSimpleFileNamePattern();
        }
        assert (!this.textPatternValid || this.textPattern != null);
        assert (!this.fileNamePatternValid || this.fileNamePattern != null);
    }

    boolean matches(DataObject dataObject) {
        return this.matches(dataObject.getPrimaryFile());
    }

    boolean matches(FileObject fileObject) {
        this.lastCharset = null;
        if (!fileObject.isValid()) {
            return false;
        }
        if (fileObject.isFolder() || !fileObject.isValid() || this.isFullText() && !BasicSearchCriteria.isTextFile(fileObject)) {
            return false;
        }
        if (this.fileNamePatternValid && !this.fileNamePattern.matcher(fileObject.getNameExt()).matches()) {
            return false;
        }
        return !this.textPatternValid || this.checkFileContent(fileObject);
    }

    Charset getLastUsedCharset() {
        return this.lastCharset;
    }

    private static boolean isTextFile(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        if (string.equals("content/unknown")) {
            return fileObject.getSize() <= 0x500000L;
        }
        if (string.startsWith("text/")) {
            return true;
        }
        if (string.startsWith("application/")) {
            String string2 = string.substring(12);
            return string2.equals("rtf") || string2.equals("sgml") || string2.startsWith("xml-") || string2.endsWith("+xml") || string2.startsWith("x-") && searchableXMimeTypes.contains(string2.substring(2));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFileContent(FileObject fileObject) {
        block29: {
            boolean bl;
            this.lastCharset = FileEncodingQuery.getEncoding((FileObject)fileObject);
            SearchPattern searchPattern = this.createSearchPattern();
            BufferedCharSequence bufferedCharSequence = null;
            try {
                FileInputStream fileInputStream = (FileInputStream)fileObject.getInputStream();
                bufferedCharSequence = new BufferedCharSequence(fileInputStream, this.lastCharset);
                ArrayList<TextDetail> arrayList = this.getTextDetails(bufferedCharSequence, fileObject, searchPattern);
                if (arrayList.isEmpty()) {
                    boolean bl2 = false;
                    return bl2;
                }
                assert (this.dataObject != null);
                this.getDetailsMap().put(this.dataObject, arrayList);
                this.freeDataObject();
                bl = true;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.severe("Unable to get data object for the " + fileObject);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", dataObjectNotFoundException);
                break block29;
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.severe("Unable to get input stream for the " + fileObject);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", fileNotFoundException);
                break block29;
            }
            catch (BufferedCharSequence.SourceIOException sourceIOException) {
                LOG.severe("IOException during process for the " + fileObject);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", sourceIOException);
                break block29;
            }
            catch (Exception exception) {
                LOG.severe("Unexpected Exception during process for the " + fileObject);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", exception);
                break block29;
            }
            finally {
                if (bufferedCharSequence != null) {
                    try {
                        bufferedCharSequence.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    private ArrayList<TextDetail> getTextDetails(BufferedCharSequence bufferedCharSequence, FileObject fileObject, SearchPattern searchPattern) throws BufferedCharSequence.SourceIOException, DataObjectNotFoundException {
        ArrayList<TextDetail> arrayList = new ArrayList<TextDetail>();
        FindState findState = new FindState(bufferedCharSequence);
        Matcher matcher = this.textPattern.matcher(bufferedCharSequence);
        while (matcher.find()) {
            int n = matcher.start();
            int n2 = findState.calcColumn(n);
            int n3 = findState.getLineNumber();
            String string = findState.getLineText();
            this.findDataObject(fileObject);
            TextDetail textDetail = this.newTextDetail(searchPattern, matcher);
            textDetail.associate(n3, n2, string);
            arrayList.add(textDetail);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    private TextDetail newTextDetail(SearchPattern searchPattern, Matcher matcher) {
        String string = matcher.group();
        int n = matcher.start();
        int n2 = matcher.end();
        int n3 = this.countCR(string);
        int n4 = n2 - n - n3;
        assert (this.dataObject != null);
        TextDetail textDetail = new TextDetail(this.dataObject, searchPattern);
        textDetail.setMatchedText(string);
        textDetail.setStartOffset(n);
        textDetail.setEndOffset(n2);
        textDetail.setMarkLength(n4);
        return textDetail;
    }

    private int countCR(String string) {
        Matcher matcher = patternCR.matcher(string);
        int n = 0;
        while (matcher.find()) {
            ++n;
        }
        return n;
    }

    public Node[] getDetails(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        if (list == null) {
            return null;
        }
        ArrayList<TextDetail.DetailNode> arrayList = new ArrayList<TextDetail.DetailNode>(list.size());
        for (TextDetail textDetail : list) {
            arrayList.add(new TextDetail.DetailNode(textDetail));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<DataObject, List<TextDetail>> getDetailsMap() {
        if (this.detailsMap != null) {
            return this.detailsMap;
        }
        BasicSearchCriteria basicSearchCriteria = this;
        synchronized (basicSearchCriteria) {
            if (this.detailsMap == null) {
                this.detailsMap = new HashMap<DataObject, List<TextDetail>>(20);
            }
        }
        return this.detailsMap;
    }

    public Node[] getDetails(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return this.getDetails(dataObject);
    }

    public int getDetailsCount(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        return list != null ? list.size() : 0;
    }

    public List<TextDetail> getTextDetails(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        return list != null ? new ArrayList<TextDetail>(list) : null;
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.create((String)this.textPatternExpr, (boolean)this.wholeWords, (boolean)this.caseSensitive, (boolean)this.regexp);
    }

    private void findDataObject(FileObject fileObject) throws DataObjectNotFoundException {
        if (this.dataObject == null) {
            this.dataObject = DataObject.find((FileObject)fileObject);
        }
    }

    private void freeDataObject() {
        this.dataObject = null;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.search.BasicSearchCriteria");
        searchableXMimeTypes = new HashSet<String>(17);
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-eruby");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
        patternCR = Pattern.compile("\r");
        patternLineSeparator = Pattern.compile("(?:\r\n|\n|\r)");
    }

    private class FindState {
        int lineNumber = 1;
        int lineStartOffset = 0;
        int prevCR = 0;
        BufferedCharSequence bcs;

        FindState(BufferedCharSequence bufferedCharSequence) {
            this.bcs = bufferedCharSequence;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        String getLineText() {
            return this.bcs.getLineText(this.lineStartOffset);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int calcColumn(int n) {
            try {
                block6: while (this.bcs.position() < n) {
                    char c = this.bcs.nextChar();
                    switch (c) {
                        case '\n': 
                        case '\f': 
                        case '\u0085': 
                        case '\u2028': 
                        case '\u2029': {
                            ++this.lineNumber;
                            this.lineStartOffset = this.bcs.position();
                            this.prevCR = 0;
                            continue block6;
                        }
                        case '\r': {
                            ++this.prevCR;
                            char c2 = this.bcs.charAt(this.bcs.position());
                            if (c2 == '\n') continue block6;
                            ++this.lineNumber;
                            this.lineStartOffset = this.bcs.position();
                            this.prevCR = 0;
                            continue block6;
                        }
                    }
                    this.prevCR = 0;
                }
                return n - this.lineStartOffset + 1 - this.prevCR;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return n - this.lineStartOffset + 1 - this.prevCR;
        }
    }
}

