/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast.executable;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyFile;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.executable.YARVMachine;
import org.jruby.nb.parser.LocalStaticScope;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class YARVCompiledRunner {
    private Ruby runtime;
    private YARVMachine ym = YARVMachine.INSTANCE;
    private YARVMachine.InstructionSequence iseq;
    private Map jumps = new IdentityHashMap();
    private Map labels = new HashMap();

    public YARVCompiledRunner(Ruby ruby, InputStream inputStream, String string) {
        this.runtime = ruby;
        byte[] byArray = new byte[4];
        try {
            inputStream.read(byArray);
            if (byArray[0] != 82 || byArray[1] != 66 || byArray[2] != 67 || byArray[3] != 77) {
                throw new RuntimeException("File is not a compiled YARV file");
            }
            RubyFile rubyFile = new RubyFile(ruby, string, inputStream);
            IRubyObject iRubyObject = ruby.getMarshal().callMethod(ruby.getCurrentContext(), "load", rubyFile);
            this.iseq = this.transformIntoSequence(iRubyObject);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't read from source", iOException);
        }
    }

    public YARVCompiledRunner(Ruby ruby, YARVMachine.InstructionSequence instructionSequence) {
        this.runtime = ruby;
        this.iseq = instructionSequence;
    }

    public IRubyObject run() {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        LocalStaticScope localStaticScope = new LocalStaticScope(null, this.iseq.locals);
        threadContext.setFile(this.iseq.filename);
        threadContext.setLine(-1);
        return this.ym.exec(threadContext, localStaticScope, this.iseq.body);
    }

    private YARVMachine.InstructionSequence transformIntoSequence(IRubyObject iRubyObject) {
        List list;
        if (!(iRubyObject instanceof RubyArray)) {
            throw new RuntimeException("Error when reading compiled YARV file");
        }
        this.labels.clear();
        this.jumps.clear();
        YARVMachine.InstructionSequence instructionSequence = new YARVMachine.InstructionSequence(this.runtime, null, null, null);
        Iterator iterator = ((RubyArray)iRubyObject).getList().iterator();
        instructionSequence.magic = iterator.next().toString();
        instructionSequence.major = RubyNumeric.fix2int((IRubyObject)iterator.next());
        instructionSequence.minor = RubyNumeric.fix2int((IRubyObject)iterator.next());
        instructionSequence.format_type = RubyNumeric.fix2int((IRubyObject)iterator.next());
        IRubyObject iRubyObject2 = (IRubyObject)iterator.next();
        instructionSequence.misc = iRubyObject2.isNil() ? null : iRubyObject2;
        instructionSequence.name = iterator.next().toString();
        instructionSequence.filename = iterator.next().toString();
        instructionSequence.line = new Object[0];
        iterator.next();
        instructionSequence.type = iterator.next().toString();
        instructionSequence.locals = this.toStringArray((IRubyObject)iterator.next());
        IRubyObject iRubyObject3 = (IRubyObject)iterator.next();
        if (iRubyObject3 instanceof RubyArray) {
            list = ((RubyArray)iRubyObject3).getList();
            instructionSequence.args_argc = RubyNumeric.fix2int((IRubyObject)list.get(0));
            instructionSequence.args_arg_opts = RubyNumeric.fix2int((IRubyObject)list.get(1));
            instructionSequence.args_opt_labels = this.toStringArray((IRubyObject)list.get(2));
            instructionSequence.args_rest = RubyNumeric.fix2int((IRubyObject)list.get(3));
            instructionSequence.args_block = RubyNumeric.fix2int((IRubyObject)list.get(4));
        } else {
            instructionSequence.args_argc = RubyNumeric.fix2int(iRubyObject3);
        }
        instructionSequence.exception = this.getExceptionInformation((IRubyObject)iterator.next());
        list = ((RubyArray)iterator.next()).getList();
        YARVMachine.Instruction[] instructionArray = new YARVMachine.Instruction[list.size()];
        int n = 0;
        int n2 = 0;
        for (Object object : list) {
            if (object instanceof RubyArray) {
                instructionArray[n] = this.intoInstruction((RubyArray)object, n, instructionSequence);
                ++n;
            } else if (object instanceof RubySymbol) {
                this.labels.put(object.toString(), new Integer(n + 1));
            }
            ++n2;
        }
        YARVMachine.Instruction[] instructionArray2 = new YARVMachine.Instruction[n];
        System.arraycopy(instructionArray, 0, instructionArray2, 0, n);
        instructionSequence.body = instructionArray2;
        for (YARVMachine.Instruction instruction : this.jumps.keySet()) {
            instruction.l_op0 = (Integer)this.labels.get(this.jumps.get(instruction)) - 1;
        }
        return instructionSequence;
    }

    private String[] toStringArray(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return new String[0];
        }
        List list = ((RubyArray)iRubyObject).getList();
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().toString();
            ++n;
        }
        return stringArray;
    }

    private YARVMachine.Instruction intoInstruction(RubyArray rubyArray, int n, YARVMachine.InstructionSequence instructionSequence) {
        List list = rubyArray.getList();
        String string = list.get(0).toString();
        int n2 = YARVMachine.instruction(string);
        YARVMachine.Instruction instruction = new YARVMachine.Instruction(n2);
        if (list.size() > 1) {
            IRubyObject iRubyObject = (IRubyObject)list.get(1);
            if (n2 == 1 || n2 == 2) {
                instruction.l_op0 = (long)(instructionSequence.locals.length + 1) - RubyNumeric.fix2long(iRubyObject);
            } else if (n2 == 18 || n2 == 74 || n2 == 56) {
                instruction.o_op0 = iRubyObject;
            } else if (iRubyObject instanceof RubyString || iRubyObject instanceof RubySymbol) {
                instruction.s_op0 = iRubyObject.toString();
            } else if (iRubyObject instanceof RubyNumeric) {
                instruction.l_op0 = RubyNumeric.fix2long(iRubyObject);
            }
            if (n2 == 47) {
                instruction.i_op1 = RubyNumeric.fix2int((IRubyObject)list.get(2));
                instruction.i_op3 = RubyNumeric.fix2int((IRubyObject)list.get(4));
            }
            if (n2 == 40) {
                instruction.iseq_op = this.transformIntoSequence((IRubyObject)list.get(2));
            }
            if (this.isJump(n2)) {
                instruction.index = n;
                this.jumps.put(instruction, list.get(this.jumpIndex(n2)).toString());
            }
        }
        return instruction;
    }

    private boolean isJump(int n) {
        return n == 53 || n == 54 || n == 55 || n == 56 || n == 58;
    }

    private int jumpIndex(int n) {
        if (n == 56) {
            return 2;
        }
        return 1;
    }

    private Object[] getExceptionInformation(IRubyObject iRubyObject) {
        return new Object[0];
    }
}

