/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.BinaryOperatorNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public OrNode(ISourcePosition iSourcePosition, Node node, Node node2) {
        super(iSourcePosition, NodeType.ORNODE);
        assert (node != null) : "firstNode is not null";
        assert (node2 != null) : "secondNode is not null";
        this.firstNode = node;
        this.secondNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitOrNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.firstNode.interpret(ruby, threadContext, iRubyObject, block);
        if (!iRubyObject2.isTrue()) {
            iRubyObject2 = this.secondNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        return iRubyObject2;
    }
}

