/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.nexus.index.QueryCreator;

@Component(role=QueryCreator.class)
public class DefaultQueryCreator
extends AbstractLogEnabled
implements QueryCreator {
    public Query constructQuery(String field, String query) {
        int l;
        char c;
        if (query == null || query.length() == 0) {
            this.getLogger().info("Empty or null query for field:" + field);
            return null;
        }
        String q = query.toLowerCase();
        char h = query.charAt(0);
        if (field.equals("c")) {
            q = q.replaceAll("\\.", "/");
            if (h == '^') {
                if ((q = q.substring(1)).charAt(0) != '/') {
                    q = '/' + q;
                }
            } else if (h != '*') {
                q = "*/" + q;
            }
        } else if (h == '^') {
            q = q.substring(1);
        } else if (h != '*') {
            q = "*" + q;
        }
        if ((c = q.charAt(l = q.length() - 1)) == ' ' || c == '<' || c == '$') {
            q = q.substring(0, q.length() - 1);
        } else if (c != '*') {
            q = q + "*";
        }
        int n = q.indexOf(42);
        if (n == -1) {
            return new TermQuery(new Term(field, q));
        }
        if (n > 0 && n == q.length() - 1) {
            return new PrefixQuery(new Term(field, q.substring(0, q.length() - 2)));
        }
        return new WildcardQuery(new Term(field, q));
    }
}

