/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.openide.util.NbBundle;

public class ActionsPanel
extends JPanel
implements ItemListener {
    private CndBreakpoint breakpoint;
    private JComboBox cbSuspend;
    private JLabel lPrintText;
    private JLabel lSuspend;
    private JLabel lThreadID;
    private JTextField tfPrintText;
    private JTextField tfThreadID;

    public ActionsPanel(CndBreakpoint cndBreakpoint) {
        this.breakpoint = cndBreakpoint;
        this.initComponents();
        this.cbSuspend.addItem(NbBundle.getMessage(ActionsPanel.class, (String)"LBL_CB_Actions_Panel_Suspend_None"));
        this.cbSuspend.addItem(NbBundle.getMessage(ActionsPanel.class, (String)"LBL_CB_Actions_Panel_Suspend_Current"));
        this.cbSuspend.addItem(NbBundle.getMessage(ActionsPanel.class, (String)"LBL_CB_Actions_Panel_Suspend_All"));
        this.tfThreadID.setText(cndBreakpoint.getThreadID());
        switch (cndBreakpoint.getSuspend()) {
            case 0: {
                this.cbSuspend.setSelectedIndex(0);
                this.tfThreadID.setEnabled(false);
                this.lThreadID.setEnabled(false);
                break;
            }
            case 1: {
                this.cbSuspend.setSelectedIndex(1);
                this.tfThreadID.setEnabled(true);
                this.lThreadID.setEnabled(true);
                break;
            }
            default: {
                this.cbSuspend.setSelectedIndex(2);
                this.tfThreadID.setEnabled(false);
                this.lThreadID.setEnabled(false);
            }
        }
        if (cndBreakpoint.getPrintText() != null) {
            this.tfPrintText.setText(cndBreakpoint.getPrintText());
        }
    }

    public void ok() {
        String string = this.tfPrintText.getText();
        if (string.trim().length() > 0) {
            this.breakpoint.setPrintText(string.trim());
        } else {
            this.breakpoint.setPrintText(null);
        }
        switch (this.cbSuspend.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setSuspend(0);
                break;
            }
            case 1: {
                this.breakpoint.setSuspend(1, this.tfThreadID.getText());
                break;
            }
            case 2: {
                this.breakpoint.setSuspend(2);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && itemEvent.getSource() == this.cbSuspend) {
            int n = this.cbSuspend.getSelectedIndex();
            this.tfThreadID.setEnabled(n == 1);
            this.lThreadID.setEnabled(n == 1);
        }
    }

    private void initComponents() {
        this.lSuspend = new JLabel();
        this.cbSuspend = new JComboBox();
        this.cbSuspend.addItemListener(this);
        this.lThreadID = new JLabel();
        this.tfThreadID = new JTextField();
        this.tfPrintText = new JTextField();
        this.lPrintText = new JLabel();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle");
        this.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Actions_Panel_BorderTitle")));
        this.setLayout(new GridBagLayout());
        this.lSuspend.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_Actions_Panel_Suspend").charAt(0));
        this.lSuspend.setLabelFor(this.cbSuspend);
        this.lSuspend.setText(resourceBundle.getString("L_Actions_Panel_Suspend"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lSuspend, gridBagConstraints);
        this.lSuspend.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_L_Actions_Panel_Suspend"));
        this.lSuspend.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Actions_Panel_Suspend"));
        this.cbSuspend.setToolTipText(resourceBundle.getString("TTT_CB_Actions_Panel_Suspend"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSuspend, gridBagConstraints);
        this.cbSuspend.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CB_Actions_Panel_Suspend"));
        this.cbSuspend.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CB_Actions_Panel_Suspend"));
        this.lThreadID.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_ThreadID").charAt(0));
        this.lThreadID.setLabelFor(this.tfThreadID);
        this.lThreadID.setText(NbBundle.getMessage(ActionsPanel.class, (String)"L_Actions_Panel_ThreadID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.add((Component)this.lThreadID, gridBagConstraints);
        this.tfThreadID.setColumns(4);
        this.tfThreadID.setToolTipText(NbBundle.getMessage(ActionsPanel.class, (String)"TT_ThreadID"));
        this.tfThreadID.setMinimumSize(new Dimension(8, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tfThreadID, gridBagConstraints);
        this.tfPrintText.setToolTipText(resourceBundle.getString("TTT_TF_Actions_Panel_Print_Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tfPrintText, gridBagConstraints);
        this.tfPrintText.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_TF_Actions_Panel_Print_Text"));
        this.tfPrintText.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Actions_Panel_Print_Text"));
        this.lPrintText.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_Actions_Panel_Print_Text").charAt(0));
        this.lPrintText.setLabelFor(this.tfPrintText);
        this.lPrintText.setText(resourceBundle.getString("L_Actions_Panel_Print_Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lPrintText, gridBagConstraints);
        this.lPrintText.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_L_Actions_Panel_Print_Text"));
        this.lPrintText.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Actions_Panel_Print_Text"));
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_Actions_Panel"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Actions_Panel"));
    }
}

